/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.command;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.CTRecipeHelper;
import gregtech.api.util.ClipboardUtil;
import gregtech.api.util.GTLog;
import gregtech.integration.groovy.GroovyScriptCompat;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CommandHand
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "hand";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "gregtech.command.hand.usage";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (sender instanceof EntityPlayerMP) {
            Set<String> oreDicts;
            OrePrefix orePrefix;
            MaterialStack material;
            String id;
            String registryName;
            EntityPlayerMP player = (EntityPlayerMP)sender;
            ItemStack stackInHand = player.func_184614_ca();
            if (stackInHand.func_190926_b() && (stackInHand = player.func_184592_cb()).func_190926_b()) {
                throw new CommandException("gregtech.command.hand.no_item", new Object[0]);
            }
            ResourceLocation registryLocation = stackInHand.func_77973_b().getRegistryName();
            if (registryLocation != null) {
                registryName = registryLocation.toString();
            } else {
                registryName = "ERROR";
                GTLog.logger.warn("ItemStack {} has a null registry name", (Object)stackInHand.func_77977_a());
            }
            ClickEvent itemNameEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, registryName);
            player.func_145747_a(new TextComponentTranslation("gregtech.command.hand.item_id", new Object[]{registryName, stackInHand.func_77952_i()}).func_150255_a(new Style().func_150241_a(itemNameEvent)));
            IElectricItem electricItem = (IElectricItem)stackInHand.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stackInHand.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (electricItem != null) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.hand.electric", new Object[]{electricItem.getCharge(), electricItem.getMaxCharge(), electricItem.getTier(), Boolean.toString(electricItem.canProvideChargeExternally())}));
            }
            if (fluidHandlerItem != null) {
                for (IFluidTankProperties properties : fluidHandlerItem.getTankProperties()) {
                    FluidStack contents = properties.getContents();
                    String fluidName = contents == null ? "empty" : contents.getFluid().getName();
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.hand.fluid", new Object[]{contents == null ? 0 : contents.amount, properties.getCapacity(), Boolean.toString(properties.canFill()), Boolean.toString(properties.canDrain())}));
                    if (contents == null) continue;
                    player.func_145747_a(new TextComponentTranslation("gregtech.command.hand.fluid2", new Object[]{fluidName}).func_150257_a(new TextComponentString(" " + fluidName).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN))).func_150255_a(CommandHand.getCopyStyle("<liquid:" + fluidName + ">", false)));
                }
            }
            if ((id = CTRecipeHelper.getMetaItemId(stackInHand)) != null) {
                String ctId = "<metaitem:" + id + ">";
                ClipboardUtil.copyToClipboard(player, ctId);
                player.func_145747_a(new TextComponentTranslation("gregtech.command.hand.meta_item", new Object[]{id}).func_150257_a(new TextComponentString(" " + id).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN))).func_150255_a(CommandHand.getCopyStyle(ctId, true)));
            }
            if (stackInHand.func_77973_b() instanceof IGTTool) {
                IGTTool tool = (IGTTool)stackInHand.func_77973_b();
                player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.hand.tool_stats", new Object[]{tool.getToolClasses(stackInHand)}));
            }
            if ((material = OreDictUnifier.getMaterial(stackInHand)) != null) {
                player.func_145747_a(new TextComponentTranslation("gregtech.command.hand.material", new Object[0]).func_150257_a(new TextComponentString(" " + material.material).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN))).func_150255_a(CommandHand.getCopyStyle("<material:" + material.material + ">", false)));
            }
            if ((orePrefix = OreDictUnifier.getPrefix(stackInHand)) != null) {
                player.func_145747_a(new TextComponentTranslation("gregtech.command.hand.ore_prefix", new Object[0]).func_150257_a(new TextComponentString(" " + orePrefix.name).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN))).func_150255_a(CommandHand.getCopyStyle(orePrefix.name, false)));
            }
            if (!(oreDicts = OreDictUnifier.getOreDictionaryNames(stackInHand)).isEmpty()) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.hand.ore_dict_entries", new Object[0]));
                for (String oreName : oreDicts) {
                    player.func_145747_a(new TextComponentString("    \u00a7e- \u00a7b" + oreName).func_150255_a(CommandHand.getCopyStyle("<ore:" + oreName + ">", false)));
                }
            }
            if (GroovyScriptCompat.isLoaded()) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.hand.groovy", new Object[0]));
            }
        } else {
            throw new CommandException("gregtech.command.hand.not_a_player", new Object[0]);
        }
    }

    public static Style getCopyStyle(String copyMessage, boolean alreadyCopied) {
        Style style = new Style();
        ClickEvent click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/gt copy " + copyMessage);
        style.func_150241_a(click);
        ITextComponent text = alreadyCopied ? new TextComponentString("").func_150257_a(new TextComponentString(copyMessage + " ").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD))).func_150257_a((ITextComponent)new TextComponentTranslation("gregtech.command.copy.copied_and_click", new Object[0])) : new TextComponentTranslation("gregtech.command.copy.click_to_copy", new Object[0]).func_150257_a(new TextComponentString(" " + copyMessage).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, text));
        return style;
    }
}

