/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.ICoverable;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.util.GTLog;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.CoverCraftingTable;
import gregtech.common.covers.CoverDigitalInterface;
import gregtech.common.covers.CoverDigitalInterfaceWireless;
import gregtech.common.covers.CoverEnderFluidLink;
import gregtech.common.covers.CoverFacade;
import gregtech.common.covers.CoverFluidFilter;
import gregtech.common.covers.CoverFluidRegulator;
import gregtech.common.covers.CoverFluidVoiding;
import gregtech.common.covers.CoverFluidVoidingAdvanced;
import gregtech.common.covers.CoverInfiniteWater;
import gregtech.common.covers.CoverItemFilter;
import gregtech.common.covers.CoverItemVoiding;
import gregtech.common.covers.CoverItemVoidingAdvanced;
import gregtech.common.covers.CoverMachineController;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.CoverRoboticArm;
import gregtech.common.covers.CoverScreen;
import gregtech.common.covers.CoverShutter;
import gregtech.common.covers.CoverSolarPanel;
import gregtech.common.covers.CoverStorage;
import gregtech.common.covers.detector.CoverDetectorActivity;
import gregtech.common.covers.detector.CoverDetectorActivityAdvanced;
import gregtech.common.covers.detector.CoverDetectorEnergy;
import gregtech.common.covers.detector.CoverDetectorEnergyAdvanced;
import gregtech.common.covers.detector.CoverDetectorFluid;
import gregtech.common.covers.detector.CoverDetectorFluidAdvanced;
import gregtech.common.covers.detector.CoverDetectorItem;
import gregtech.common.covers.detector.CoverDetectorItemAdvanced;
import gregtech.common.covers.filter.OreDictionaryItemFilter;
import gregtech.common.covers.filter.SimpleFluidFilter;
import gregtech.common.covers.filter.SimpleItemFilter;
import gregtech.common.covers.filter.SmartItemFilter;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.CoverDigitalInterfaceWirelessPlaceBehaviour;
import gregtech.common.items.behaviors.CoverPlaceBehavior;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class CoverBehaviors {
    private static int rollingId = 0;

    public static void init() {
        GTLog.logger.info("Registering cover behaviors...");
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "conveyor.lv"), MetaItems.CONVEYOR_MODULE_LV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 1, 8));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "conveyor.mv"), MetaItems.CONVEYOR_MODULE_MV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 2, 32));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "conveyor.hv"), MetaItems.CONVEYOR_MODULE_HV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 3, 64));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "conveyor.ev"), MetaItems.CONVEYOR_MODULE_EV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 4, 192));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "conveyor.iv"), MetaItems.CONVEYOR_MODULE_IV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 5, 512));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "conveyor.luv"), MetaItems.CONVEYOR_MODULE_LuV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 6, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "conveyor.zpm"), MetaItems.CONVEYOR_MODULE_ZPM, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 7, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "conveyor.uv"), MetaItems.CONVEYOR_MODULE_UV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 8, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "robotic_arm.lv"), MetaItems.ROBOT_ARM_LV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 1, 8));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "robotic_arm.mv"), MetaItems.ROBOT_ARM_MV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 2, 32));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "robotic_arm.hv"), MetaItems.ROBOT_ARM_HV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 3, 64));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "robotic_arm.ev"), MetaItems.ROBOT_ARM_EV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 4, 192));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "robotic_arm.iv"), MetaItems.ROBOT_ARM_IV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 5, 512));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "robotic_arm.luv"), MetaItems.ROBOT_ARM_LuV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 6, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "robotic_arm.zpm"), MetaItems.ROBOT_ARM_ZPM, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 7, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "robotic_arm.uv"), MetaItems.ROBOT_ARM_UV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 8, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "ore_dictionary_filter"), MetaItems.ORE_DICTIONARY_FILTER, (tile, side) -> new CoverItemFilter((ICoverable)tile, (EnumFacing)side, "cover.ore_dictionary_filter.title", Textures.ORE_DICTIONARY_FILTER_OVERLAY, new OreDictionaryItemFilter()));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "item_filter"), MetaItems.ITEM_FILTER, (tile, side) -> new CoverItemFilter((ICoverable)tile, (EnumFacing)side, "cover.item_filter.title", Textures.ITEM_FILTER_FILTER_OVERLAY, new SimpleItemFilter()));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "fluid_filter"), MetaItems.FLUID_FILTER, (tile, side) -> new CoverFluidFilter((ICoverable)tile, (EnumFacing)side, "cover.fluid_filter.title", Textures.FLUID_FILTER_OVERLAY, new SimpleFluidFilter()));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "shutter"), MetaItems.COVER_SHUTTER, CoverShutter::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "solar_panel.basic"), MetaItems.COVER_SOLAR_PANEL, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, 1L));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "solar_panel.ulv"), MetaItems.COVER_SOLAR_PANEL_ULV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[0]));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "solar_panel.lv"), MetaItems.COVER_SOLAR_PANEL_LV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[1]));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "solar_panel.mv"), MetaItems.COVER_SOLAR_PANEL_MV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[2]));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "solar_panel.hv"), MetaItems.COVER_SOLAR_PANEL_HV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[3]));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "solar_panel.ev"), MetaItems.COVER_SOLAR_PANEL_EV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[4]));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "solar_panel.iv"), MetaItems.COVER_SOLAR_PANEL_IV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[5]));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "solar_panel.luv"), MetaItems.COVER_SOLAR_PANEL_LUV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[6]));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "solar_panel.zpm"), MetaItems.COVER_SOLAR_PANEL_ZPM, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[7]));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "solar_panel.uv"), MetaItems.COVER_SOLAR_PANEL_UV, (tile, side) -> new CoverSolarPanel((ICoverable)tile, (EnumFacing)side, GTValues.V[8]));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "machine_controller"), MetaItems.COVER_MACHINE_CONTROLLER, CoverMachineController::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "smart_filter"), MetaItems.SMART_FILTER, (tile, side) -> new CoverItemFilter((ICoverable)tile, (EnumFacing)side, "cover.smart_item_filter.title", Textures.SMART_FILTER_FILTER_OVERLAY, new SmartItemFilter()));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "facade"), MetaItems.COVER_FACADE, CoverFacade::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "screen"), MetaItems.COVER_SCREEN, CoverScreen::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "energy_detector"), MetaItems.COVER_ENERGY_DETECTOR, CoverDetectorEnergy::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "energy_detector_advanced"), MetaItems.COVER_ENERGY_DETECTOR_ADVANCED, CoverDetectorEnergyAdvanced::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "fluid_detector"), MetaItems.COVER_FLUID_DETECTOR, CoverDetectorFluid::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "fluid_detector_advanced"), MetaItems.COVER_FLUID_DETECTOR_ADVANCED, CoverDetectorFluidAdvanced::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "item_detector"), MetaItems.COVER_ITEM_DETECTOR, CoverDetectorItem::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "item_detector_advanced"), MetaItems.COVER_ITEM_DETECTOR_ADVANCED, CoverDetectorItemAdvanced::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "activity_detector"), MetaItems.COVER_ACTIVITY_DETECTOR, CoverDetectorActivity::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "activity_detector_advanced"), MetaItems.COVER_ACTIVITY_DETECTOR_ADVANCED, CoverDetectorActivityAdvanced::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "crafting_table"), MetaItems.COVER_CRAFTING, CoverCraftingTable::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "infinite_water"), MetaItems.COVER_INFINITE_WATER, CoverInfiniteWater::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "ender_fluid_link"), MetaItems.COVER_ENDER_FLUID_LINK, CoverEnderFluidLink::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "cover.digital"), MetaItems.COVER_DIGITAL_INTERFACE, CoverDigitalInterface::new);
        MetaItems.COVER_DIGITAL_INTERFACE_WIRELESS.addComponents(new CoverDigitalInterfaceWirelessPlaceBehaviour(CoverBehaviors.registerCover(new ResourceLocation("gregtech", "cover.digital.wireless"), MetaItems.COVER_DIGITAL_INTERFACE_WIRELESS, CoverDigitalInterfaceWireless::new)));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "pump.lv"), MetaItems.ELECTRIC_PUMP_LV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 1, 1280));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "pump.mv"), MetaItems.ELECTRIC_PUMP_MV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 2, 5120));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "pump.hv"), MetaItems.ELECTRIC_PUMP_HV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 3, 20480));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "pump.ev"), MetaItems.ELECTRIC_PUMP_EV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 4, 81920));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "pump.iv"), MetaItems.ELECTRIC_PUMP_IV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 5, 327680));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "pump.luv"), MetaItems.ELECTRIC_PUMP_LuV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 6, 0x140000));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "pump.zpm"), MetaItems.ELECTRIC_PUMP_ZPM, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 7, 0x500000));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "pump.uv"), MetaItems.ELECTRIC_PUMP_UV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 8, 0x1400000));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "fluid.regulator.lv"), MetaItems.FLUID_REGULATOR_LV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 1, 1280));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "fluid.regulator.mv"), MetaItems.FLUID_REGULATOR_MV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 2, 5120));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "fluid.regulator.hv"), MetaItems.FLUID_REGULATOR_HV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 3, 20480));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "fluid.regulator.ev"), MetaItems.FLUID_REGULATOR_EV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 4, 81920));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "fluid.regulator.iv"), MetaItems.FLUID_REGULATOR_IV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 5, 327680));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "fluid.regulator.luv"), MetaItems.FLUID_REGULATOR_LUV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 6, 0x140000));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "fluid.regulator.zpm"), MetaItems.FLUID_REGULATOR_ZPM, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 7, 0x500000));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "fluid.regulator.uv"), MetaItems.FLUID_REGULATOR_UV, (tile, side) -> new CoverFluidRegulator((ICoverable)tile, (EnumFacing)side, 8, 0x1400000));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "conveyor.uhv"), MetaItems.CONVEYOR_MODULE_UHV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 9, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "conveyor.uev"), MetaItems.CONVEYOR_MODULE_UEV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 10, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "conveyor.uiv"), MetaItems.CONVEYOR_MODULE_UIV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 11, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "conveyor.uxv"), MetaItems.CONVEYOR_MODULE_UXV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 12, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "conveyor.opv"), MetaItems.CONVEYOR_MODULE_OpV, (tile, side) -> new CoverConveyor((ICoverable)tile, (EnumFacing)side, 13, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "robotic_arm.uhv"), MetaItems.ROBOT_ARM_UHV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 9, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "robotic_arm.uev"), MetaItems.ROBOT_ARM_UEV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 10, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "robotic_arm.uiv"), MetaItems.ROBOT_ARM_UIV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 11, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "robotic_arm.uxv"), MetaItems.ROBOT_ARM_UXV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 12, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "robotic_arm.opv"), MetaItems.ROBOT_ARM_OpV, (tile, side) -> new CoverRoboticArm((ICoverable)tile, (EnumFacing)side, 13, 1024));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "pump.uhv"), MetaItems.ELECTRIC_PUMP_UHV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 9, 0x1400000));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "pump.uev"), MetaItems.ELECTRIC_PUMP_UEV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 10, 0x1400000));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "pump.uiv"), MetaItems.ELECTRIC_PUMP_UIV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 11, 0x1400000));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "pump.uxv"), MetaItems.ELECTRIC_PUMP_UXV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 12, 0x1400000));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "pump.opv"), MetaItems.ELECTRIC_PUMP_OpV, (tile, side) -> new CoverPump((ICoverable)tile, (EnumFacing)side, 13, 0x1400000));
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "fluid_voiding"), MetaItems.COVER_FLUID_VOIDING, CoverFluidVoiding::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "fluid_voiding.advanced"), MetaItems.COVER_FLUID_VOIDING_ADVANCED, CoverFluidVoidingAdvanced::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "item_voiding"), MetaItems.COVER_ITEM_VOIDING, CoverItemVoiding::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "item_voiding.advanced"), MetaItems.COVER_ITEM_VOIDING_ADVANCED, CoverItemVoidingAdvanced::new);
        CoverBehaviors.registerBehavior(new ResourceLocation("gregtech", "storage"), MetaItems.COVER_STORAGE, CoverStorage::new);
    }

    @Deprecated
    public static void registerBehavior(int coverNetworkId, @Nonnull ResourceLocation coverId, @Nonnull MetaItem.MetaValueItem placerItem, @Nonnull BiFunction<ICoverable, EnumFacing, CoverBehavior> behaviorCreator) {
        CoverBehaviors.registerBehavior(coverId, placerItem, behaviorCreator);
    }

    public static void registerBehavior(@Nonnull ResourceLocation coverId, @Nonnull MetaItem.MetaValueItem placerItem, @Nonnull BiFunction<ICoverable, EnumFacing, CoverBehavior> behaviorCreator) {
        placerItem.addComponents(new CoverPlaceBehavior(CoverBehaviors.registerCover(coverId, placerItem, behaviorCreator)));
    }

    @Nonnull
    @Deprecated
    public static CoverDefinition registerCover(int coverNetworkId, @Nonnull ResourceLocation coverId, @Nonnull MetaItem.MetaValueItem itemStack, @Nonnull BiFunction<ICoverable, EnumFacing, CoverBehavior> behaviorCreator) {
        return CoverBehaviors.registerCover(coverId, itemStack, behaviorCreator);
    }

    @Nonnull
    public static CoverDefinition registerCover(@Nonnull ResourceLocation coverId, @Nonnull MetaItem.MetaValueItem itemStack, @Nonnull BiFunction<ICoverable, EnumFacing, CoverBehavior> behaviorCreator) {
        CoverDefinition coverDefinition = new CoverDefinition(coverId, behaviorCreator, itemStack.getStackForm());
        GregTechAPI.COVER_REGISTRY.register(rollingId++, coverId, coverDefinition);
        return coverDefinition;
    }
}

