/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.google.common.base.Preconditions;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.storage.ICraftingStorage;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.inventory.handlers.SingleItemStackHandler;
import gregtech.common.inventory.handlers.ToolItemStackHandler;
import gregtech.common.inventory.itemsource.ItemSources;
import gregtech.common.inventory.itemsource.sources.InventoryItemSource;
import gregtech.common.metatileentities.storage.CraftingRecipeLogic;
import gregtech.common.metatileentities.storage.CraftingRecipeMemory;
import gregtech.common.metatileentities.storage.MetaTileEntityWorkbench;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CoverCraftingTable
extends CoverBehavior
implements CoverWithUI,
ITickable,
ICraftingStorage {
    private final ItemStackHandler internalInventory = new ItemStackHandler(18);
    private final ItemStackHandler craftingGrid = new SingleItemStackHandler(9);
    private final ItemStackHandler toolInventory = new ToolItemStackHandler(9);
    private final CraftingRecipeMemory recipeMemory = new CraftingRecipeMemory(9);
    private CraftingRecipeLogic recipeLogic = null;
    private int itemsCrafted = 0;

    public CoverCraftingTable(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
    }

    @Override
    public boolean canAttach() {
        return true;
    }

    @Override
    public boolean shouldAutoConnect() {
        return false;
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.CRAFTING.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    private void createCraftingRecipeLogic() {
        this.recipeLogic = new CraftingRecipeLogic(this);
        this.recipeLogic.setItemsCraftedAmount(this.itemsCrafted);
        ItemSources itemSources = this.recipeLogic.getItemSourceList();
        itemSources.addItemHandler(new InventoryItemSource(this.coverHolder.getWorld(), (IItemHandler)this.toolInventory, -2));
        itemSources.addItemHandler(new InventoryItemSource(this.coverHolder.getWorld(), (IItemHandler)this.internalInventory, -1));
        this.recipeLogic.checkNeighbourInventories(this.coverHolder.getPos());
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!playerIn.field_70170_p.field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_73660_a() {
        if (!this.coverHolder.getWorld().field_72995_K && this.recipeLogic == null) {
            this.createCraftingRecipeLogic();
        }
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.getRecipeLogic().update();
        }
    }

    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        MetaTileEntity.clearInventory(itemBuffer, (IItemHandlerModifiable)this.internalInventory);
        MetaTileEntity.clearInventory(itemBuffer, (IItemHandlerModifiable)this.toolInventory);
    }

    private CraftingRecipeLogic getRecipeLogic() {
        Preconditions.checkState((this.coverHolder.getWorld() != null ? 1 : 0) != 0, (Object)"getRecipeResolver called too early");
        return this.recipeLogic;
    }

    @Override
    public List<ItemStack> getDrops() {
        int i;
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (i = 0; i < this.internalInventory.getSlots(); ++i) {
            itemStacks.add(this.internalInventory.getStackInSlot(i));
        }
        for (i = 0; i < this.toolInventory.getSlots(); ++i) {
            itemStacks.add(this.toolInventory.getStackInSlot(i));
        }
        itemStacks.add(this.getPickItem());
        return itemStacks;
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 221).bindPlayerInventory(player.field_71071_by, 139);
        builder.label(5, 5, "metaitem.cover.crafting.name");
        builder.widget(MetaTileEntityWorkbench.createWorkbenchTab(this.recipeLogic, this.craftingGrid, this.recipeMemory, this.toolInventory, this.internalInventory));
        return builder.build(this, player);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74782_a("CraftingGridInventory", (NBTBase)this.craftingGrid.serializeNBT());
        tagCompound.func_74782_a("ToolInventory", (NBTBase)this.toolInventory.serializeNBT());
        tagCompound.func_74782_a("InternalInventory", (NBTBase)this.internalInventory.serializeNBT());
        tagCompound.func_74768_a("ItemsCrafted", this.recipeLogic == null ? this.itemsCrafted : this.recipeLogic.getItemsCraftedAmount());
        tagCompound.func_74782_a("RecipeMemory", (NBTBase)this.recipeMemory.serializeNBT());
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.craftingGrid.deserializeNBT(tagCompound.func_74775_l("CraftingGridInventory"));
        this.toolInventory.deserializeNBT(tagCompound.func_74775_l("ToolInventory"));
        this.internalInventory.deserializeNBT(tagCompound.func_74775_l("InternalInventory"));
        this.itemsCrafted = tagCompound.func_74762_e("ItemsCrafted");
        this.recipeMemory.deserializeNBT(tagCompound.func_74775_l("RecipeMemory"));
    }

    @Override
    public World getWorld() {
        return this.coverHolder.getWorld();
    }

    @Override
    public ItemStackHandler getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public CraftingRecipeMemory getRecipeMemory() {
        return this.recipeMemory;
    }
}

