/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.math.IntMath;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.IncrementButtonWidget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.TransferMode;
import gregtech.common.covers.filter.FluidFilter;
import gregtech.common.covers.filter.FluidFilterContainer;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.message.FormattedMessage;

public class CoverFluidRegulator
extends CoverPump {
    protected TransferMode transferMode = TransferMode.TRANSFER_ANY;
    protected int transferAmount = 0;

    public CoverFluidRegulator(ICoverable coverHolder, EnumFacing attachedSide, int tier, int mbPerTick) {
        super(coverHolder, attachedSide, tier, mbPerTick);
        this.fluidFilter = new FluidFilterContainer(this, this::shouldShowTip, this.maxFluidTransferRate * 100);
    }

    @Override
    protected boolean shouldShowTip() {
        return this.transferMode != TransferMode.TRANSFER_ANY;
    }

    public int getTransferAmount() {
        return this.transferAmount;
    }

    @Override
    protected int doTransferFluidsInternal(IFluidHandler myFluidHandler, IFluidHandler fluidHandler, int transferLimit) {
        IFluidHandler destHandler;
        IFluidHandler sourceHandler;
        if (this.pumpMode == CoverPump.PumpMode.IMPORT) {
            sourceHandler = fluidHandler;
            destHandler = myFluidHandler;
        } else if (this.pumpMode == CoverPump.PumpMode.EXPORT) {
            sourceHandler = myFluidHandler;
            destHandler = fluidHandler;
        } else {
            return 0;
        }
        switch (this.transferMode) {
            case TRANSFER_ANY: {
                return GTTransferUtils.transferFluids(sourceHandler, destHandler, transferLimit, this.fluidFilter::testFluidStack);
            }
            case KEEP_EXACT: {
                return this.doKeepExact(transferLimit, sourceHandler, destHandler, this.fluidFilter::testFluidStack, this.transferAmount);
            }
            case TRANSFER_EXACT: {
                return this.doTransferExact(transferLimit, sourceHandler, destHandler, this.fluidFilter::testFluidStack, this.transferAmount);
            }
        }
        return 0;
    }

    protected int doTransferExact(int transferLimit, IFluidHandler sourceHandler, IFluidHandler destHandler, Predicate<FluidStack> fluidFilter, int supplyAmount) {
        int fluidLeftToTransfer = transferLimit;
        for (IFluidTankProperties tankProperties : sourceHandler.getTankProperties()) {
            FluidStack sourceFluid = tankProperties.getContents();
            if (this.fluidFilter.getFilterWrapper().getFluidFilter() != null && this.transferMode != TransferMode.TRANSFER_ANY) {
                supplyAmount = this.fluidFilter.getFilterWrapper().getFluidFilter().getFluidTransferLimit(sourceFluid);
            }
            if (fluidLeftToTransfer < supplyAmount) break;
            if (sourceFluid == null || sourceFluid.amount == 0 || !fluidFilter.test(sourceFluid)) continue;
            sourceFluid.amount = supplyAmount;
            if (GTTransferUtils.transferExactFluidStack(sourceHandler, destHandler, sourceFluid.copy())) {
                fluidLeftToTransfer -= sourceFluid.amount;
            }
            if (fluidLeftToTransfer == 0) break;
        }
        return transferLimit - fluidLeftToTransfer;
    }

    protected int doKeepExact(int transferLimit, IFluidHandler sourceHandler, IFluidHandler destHandler, Predicate<FluidStack> fluidFilter, int keepAmount) {
        if (sourceHandler == null || destHandler == null || fluidFilter == null) {
            return 0;
        }
        Map<FluidStack, Integer> sourceFluids = CoverFluidRegulator.collectDistinctFluids(sourceHandler, IFluidTankProperties::canDrain, fluidFilter);
        Map<FluidStack, Integer> destFluids = CoverFluidRegulator.collectDistinctFluids(destHandler, IFluidTankProperties::canFill, fluidFilter);
        int transferred = 0;
        for (FluidStack fluidStack : sourceFluids.keySet()) {
            int drainable;
            int fillResult;
            FluidStack drainedResult;
            int amountToMove;
            int amountInDest;
            if (transferred >= transferLimit) break;
            if (this.fluidFilter.getFilterWrapper().getFluidFilter() != null && this.transferMode != TransferMode.TRANSFER_ANY) {
                keepAmount = this.fluidFilter.getFilterWrapper().getFluidFilter().getFluidTransferLimit(fluidStack);
            }
            if ((amountInDest = destFluids.getOrDefault(fluidStack, 0).intValue()) >= keepAmount || (amountToMove = Math.min(transferLimit - transferred, keepAmount - amountInDest)) <= 0 || (drainedResult = sourceHandler.drain(CoverFluidRegulator.copyFluidStackWithAmount(fluidStack, amountToMove), false)) == null || drainedResult.amount <= 0 || !fluidStack.equals((Object)drainedResult) || (fillResult = destHandler.fill(CoverFluidRegulator.copyFluidStackWithAmount(fluidStack, drainable = Math.min(amountToMove, drainedResult.amount)), false)) <= 0) continue;
            int fluidToMove = Math.min(drainable, fillResult);
            FluidStack drainedActual = sourceHandler.drain(CoverFluidRegulator.copyFluidStackWithAmount(fluidStack, fluidToMove), true);
            if (drainedActual == null) {
                throw new RuntimeException("Misbehaving fluid container: drain produced null after simulation succeeded");
            }
            if (!fluidStack.equals((Object)drainedActual)) {
                throw new RuntimeException("Misbehaving fluid container: drain produced a different fluid than the simulation");
            }
            if (drainedActual.amount != fluidToMove) {
                throw new RuntimeException(new FormattedMessage("Misbehaving fluid container: drain expected: {}, actual: {}", (Object)fluidToMove, (Object)drainedActual.amount).getFormattedMessage());
            }
            int filledActual = destHandler.fill(CoverFluidRegulator.copyFluidStackWithAmount(fluidStack, fluidToMove), true);
            if (filledActual != fluidToMove) {
                throw new RuntimeException(new FormattedMessage("Misbehaving fluid container: fill expected: {}, actual: {}", (Object)fluidToMove, (Object)filledActual).getFormattedMessage());
            }
            transferred += fluidToMove;
        }
        return transferred;
    }

    private static FluidStack copyFluidStackWithAmount(FluidStack fs, int amount) {
        FluidStack fs2 = fs.copy();
        fs2.amount = amount;
        return fs2;
    }

    private static Map<FluidStack, Integer> collectDistinctFluids(IFluidHandler handler, Predicate<IFluidTankProperties> tankTypeFilter, Predicate<FluidStack> fluidTypeFilter) {
        Object2IntOpenHashMap summedFluids = new Object2IntOpenHashMap();
        Arrays.stream(handler.getTankProperties()).filter(tankTypeFilter).map(IFluidTankProperties::getContents).filter(Objects::nonNull).filter(fluidTypeFilter).forEach(arg_0 -> CoverFluidRegulator.lambda$collectDistinctFluids$1((Map)summedFluids, arg_0));
        return summedFluids;
    }

    public void setTransferMode(TransferMode transferMode) {
        this.transferMode = transferMode;
        this.coverHolder.markDirty();
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    private boolean shouldDisplayAmountSlider() {
        if (this.fluidFilter.getFilterWrapper().getFluidFilter() != null) {
            return false;
        }
        return this.transferMode == TransferMode.TRANSFER_EXACT || this.transferMode == TransferMode.KEEP_EXACT;
    }

    public String getTransferAmountString() {
        return Integer.toString(this.bucketMode == CoverPump.BucketMode.BUCKET ? this.transferAmount / 1000 : this.transferAmount);
    }

    private String getTransferSizeString() {
        int val = this.transferAmount;
        if (this.bucketMode == CoverPump.BucketMode.BUCKET) {
            val /= 1000;
        }
        return val == -1 ? "" : TextFormattingUtil.formatLongToCompactString(val);
    }

    protected void getHoverString(List<ITextComponent> textList) {
        TextComponentString keepComponent = new TextComponentString(this.getTransferSizeString());
        TextComponentTranslation hoverKeep = new TextComponentTranslation("cover.fluid_regulator." + this.transferMode.name().toLowerCase(), new Object[]{this.transferAmount});
        keepComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)hoverKeep));
        textList.add((ITextComponent)keepComponent);
    }

    @Override
    public void setBucketMode(CoverPump.BucketMode bucketMode) {
        super.setBucketMode(bucketMode);
        if (this.bucketMode == CoverPump.BucketMode.BUCKET) {
            this.setTransferAmount(this.transferAmount / 1000 * 1000);
        }
    }

    private void adjustTransferSize(int amount) {
        if (this.bucketMode == CoverPump.BucketMode.BUCKET) {
            amount *= 1000;
        }
        switch (this.transferMode) {
            case TRANSFER_EXACT: {
                this.setTransferAmount(MathHelper.func_76125_a((int)(this.transferAmount + amount), (int)0, (int)this.maxFluidTransferRate));
                break;
            }
            case KEEP_EXACT: {
                this.setTransferAmount(MathHelper.func_76125_a((int)(this.transferAmount + amount), (int)0, (int)Integer.MAX_VALUE));
            }
        }
    }

    private void setTransferAmount(int transferAmount) {
        this.transferAmount = transferAmount;
        this.coverHolder.markDirty();
    }

    @Override
    protected String getUITitle() {
        return "cover.fluid_regulator.title";
    }

    @Override
    protected ModularUI buildUI(ModularUI.Builder builder, EntityPlayer player) {
        WidgetGroup filterGroup = new WidgetGroup();
        filterGroup.addWidget(new CycleButtonWidget(92, 43, 75, 18, TransferMode.class, this::getTransferMode, this::setTransferMode).setTooltipHoverString("cover.fluid_regulator.transfer_mode.description"));
        ServerWidgetGroup stackSizeGroup = new ServerWidgetGroup(this::shouldDisplayAmountSlider);
        stackSizeGroup.addWidget(new ImageWidget(110, 64, 38, 18, GuiTextures.DISPLAY));
        stackSizeGroup.addWidget(new IncrementButtonWidget(148, 64, 18, 18, 1, 10, 100, 1000, this::adjustTransferSize).setDefaultTooltip().setTextScale(0.7f).setShouldClientCallback(false));
        stackSizeGroup.addWidget(new IncrementButtonWidget(92, 64, 18, 18, -1, -10, -100, -1000, this::adjustTransferSize).setDefaultTooltip().setTextScale(0.7f).setShouldClientCallback(false));
        stackSizeGroup.addWidget(new TextFieldWidget2(111, 70, 36, 11, this::getTransferAmountString, val -> {
            if (val != null && !val.isEmpty()) {
                int amount = Integer.parseInt(val);
                if (this.bucketMode == CoverPump.BucketMode.BUCKET) {
                    amount = IntMath.saturatedMultiply((int)amount, (int)1000);
                }
                this.setTransferAmount(amount);
            }
        }).setCentered(true).setNumbersOnly(1, this.transferMode == TransferMode.TRANSFER_EXACT ? this.maxFluidTransferRate : Integer.MAX_VALUE).setMaxLength(10).setScale(0.6f));
        stackSizeGroup.addWidget(new SimpleTextWidget(129, 78, "", 0xFFFFFF, () -> this.bucketMode.localeName).setScale(0.6f));
        return super.buildUI(builder.widget(filterGroup).widget(stackSizeGroup), player);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferMode", this.transferMode.ordinal());
        tagCompound.func_74768_a("TransferAmount", this.transferAmount);
        tagCompound.func_74782_a("filterv2", (NBTBase)new NBTTagCompound());
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        FluidFilter filter;
        super.readFromNBT(tagCompound);
        this.transferMode = TransferMode.values()[tagCompound.func_74762_e("TransferMode")];
        if (!tagCompound.func_74764_b("filterv2") && tagCompound.func_74764_b("TransferAmount") && (filter = this.getFluidFilterContainer().getFilterWrapper().getFluidFilter()) != null) {
            filter.configureFilterTanks(tagCompound.func_74762_e("TransferAmount"));
        }
        this.transferAmount = tagCompound.func_74762_e("TransferAmount");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected TextureAtlasSprite getPlateSprite() {
        return Textures.VOLTAGE_CASINGS[this.tier].getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.SIDE);
    }

    private static /* synthetic */ void lambda$collectDistinctFluids$1(Map summedFluids, FluidStack fs) {
        summedFluids.putIfAbsent(fs, 0);
        summedFluids.computeIfPresent(fs, (k, v) -> v + fs.amount);
    }
}

