/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.IncrementButtonWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.util.GTTransferUtils;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverFluidVoiding;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.ManualImportExportMode;
import gregtech.common.covers.VoidingMode;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CoverFluidVoidingAdvanced
extends CoverFluidVoiding {
    protected VoidingMode voidingMode = VoidingMode.VOID_ANY;
    protected int transferAmount = 0;

    public CoverFluidVoidingAdvanced(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
    }

    @Override
    protected boolean shouldShowTip() {
        return this.voidingMode != VoidingMode.VOID_ANY;
    }

    @Override
    protected void doTransferFluids() {
        IFluidHandler myFluidHandler = (IFluidHandler)this.coverHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.attachedSide);
        if (myFluidHandler == null) {
            return;
        }
        switch (this.voidingMode) {
            case VOID_ANY: {
                GTTransferUtils.transferFluids(myFluidHandler, (IFluidHandler)this.nullFluidTank, Integer.MAX_VALUE, this.fluidFilter::testFluidStack);
                break;
            }
            case VOID_OVERFLOW: {
                this.voidOverflow(myFluidHandler, this.fluidFilter::testFluidStack, this.transferAmount);
            }
        }
    }

    protected void voidOverflow(IFluidHandler sourceHandler, Predicate<FluidStack> fluidFilter, int keepAmount) {
        if (sourceHandler == null || fluidFilter == null) {
            return;
        }
        for (IFluidTankProperties tankProperties : sourceHandler.getTankProperties()) {
            FluidStack sourceFluid = tankProperties.getContents();
            if (this.fluidFilter.getFilterWrapper().getFluidFilter() != null && this.voidingMode == VoidingMode.VOID_OVERFLOW) {
                keepAmount = this.fluidFilter.getFilterWrapper().getFluidFilter().getFluidTransferLimit(sourceFluid);
            }
            if (sourceFluid == null || sourceFluid.amount == 0 || !this.getFluidFilterContainer().testFluidStack(sourceFluid, true)) continue;
            sourceFluid.amount -= keepAmount;
            sourceHandler.drain(sourceFluid, true);
        }
    }

    @Override
    public void setBucketMode(CoverPump.BucketMode bucketMode) {
        super.setBucketMode(bucketMode);
        if (this.bucketMode == CoverPump.BucketMode.BUCKET) {
            this.setTransferAmount(this.transferAmount / 1000 * 1000);
        }
    }

    private void adjustTransferSize(int amount) {
        if (this.bucketMode == CoverPump.BucketMode.BUCKET) {
            amount *= 1000;
        }
        if (this.voidingMode == VoidingMode.VOID_OVERFLOW) {
            this.setTransferAmount(MathHelper.func_76125_a((int)(this.transferAmount + amount), (int)0, (int)Integer.MAX_VALUE));
        }
    }

    private void setTransferAmount(int transferAmount) {
        this.transferAmount = transferAmount;
        this.coverHolder.markDirty();
    }

    public int getTransferAmount() {
        return this.transferAmount;
    }

    public void setVoidingMode(VoidingMode transferMode) {
        this.voidingMode = transferMode;
        this.coverHolder.markDirty();
    }

    public VoidingMode getVoidingMode() {
        return this.voidingMode;
    }

    private boolean shouldDisplayAmountSlider() {
        if (this.fluidFilter.getFilterWrapper().getFluidFilter() != null) {
            return false;
        }
        return this.voidingMode == VoidingMode.VOID_OVERFLOW;
    }

    public String getTransferAmountString() {
        return Integer.toString(this.bucketMode == CoverPump.BucketMode.BUCKET ? this.transferAmount / 1000 : this.transferAmount);
    }

    @Override
    protected String getUITitle() {
        return "cover.fluid.voiding.advanced.title";
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup primaryGroup = new WidgetGroup();
        primaryGroup.addWidget(new LabelWidget(10, 5, this.getUITitle(), new Object[0]));
        primaryGroup.addWidget(new CycleButtonWidget(92, 15, 75, 18, VoidingMode.class, this::getVoidingMode, this::setVoidingMode).setTooltipHoverString("cover.voiding.voiding_mode.description"));
        this.initFilterUI(20, primaryGroup::addWidget);
        primaryGroup.addWidget(new CycleButtonWidget(10, 92, 80, 18, this::isWorkingEnabled, this::setWorkingEnabled, "cover.voiding.label.disabled", "cover.voiding.label.enabled").setTooltipHoverString("cover.voiding.tooltip"));
        primaryGroup.addWidget(new CycleButtonWidget(10, 112, 116, 18, ManualImportExportMode.class, this::getManualImportExportMode, this::setManualImportExportMode).setTooltipHoverString("cover.universal.manual_import_export.mode.description"));
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 222).widget(primaryGroup).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 7, 140);
        return this.buildUI(builder, player);
    }

    public void initFilterUI(int y, Consumer<Widget> widgetGroup) {
        widgetGroup.accept(new LabelWidget(10, y, "cover.pump.fluid_filter.title", new Object[0]));
        widgetGroup.accept(new SlotWidget((IItemHandlerModifiable)this.fluidFilter.getFilterInventory(), 0, 10, y + 15).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.FILTER_SLOT_OVERLAY));
        ServerWidgetGroup stackSizeGroup = new ServerWidgetGroup(this::shouldDisplayAmountSlider);
        stackSizeGroup.addWidget(new ImageWidget(110, 34, 38, 18, GuiTextures.DISPLAY));
        stackSizeGroup.addWidget(new IncrementButtonWidget(148, 34, 18, 18, 1, 10, 100, 1000, this::adjustTransferSize).setDefaultTooltip().setTextScale(0.7f).setShouldClientCallback(false));
        stackSizeGroup.addWidget(new IncrementButtonWidget(92, 34, 18, 18, -1, -10, -100, -1000, this::adjustTransferSize).setDefaultTooltip().setTextScale(0.7f).setShouldClientCallback(false));
        stackSizeGroup.addWidget(new TextFieldWidget2(111, 39, 37, 11, this::getTransferAmountString, val -> {
            if (val != null && !val.isEmpty()) {
                int amount = Integer.parseInt(val);
                if (this.bucketMode == CoverPump.BucketMode.BUCKET) {
                    amount *= 1000;
                }
                this.setTransferAmount(amount);
            }
        }).setCentered(true).setNumbersOnly(1, Integer.MAX_VALUE).setMaxLength(10).setScale(0.6f));
        stackSizeGroup.addWidget(new SimpleTextWidget(129, 47, "", 0xFFFFFF, () -> this.bucketMode.localeName).setScale(0.6f));
        stackSizeGroup.addWidget(new CycleButtonWidget(114, 53, 30, 20, CoverPump.BucketMode.class, this::getBucketMode, mode -> {
            if (mode != this.bucketMode) {
                this.setBucketMode((CoverPump.BucketMode)((Object)mode));
            }
        }));
        widgetGroup.accept(stackSizeGroup);
        this.fluidFilter.getFilterWrapper().initUI(y + 15, widgetGroup);
        this.fluidFilter.getFilterWrapper().blacklistUI(y + 15, widgetGroup, () -> this.voidingMode != VoidingMode.VOID_OVERFLOW);
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.FLUID_VOIDING_ADVANCED.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("VoidingMode", this.voidingMode.ordinal());
        tagCompound.func_74768_a("TransferAmount", this.transferAmount);
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.voidingMode = VoidingMode.values()[tagCompound.func_74762_e("VoidingMode")];
        this.transferAmount = tagCompound.func_74762_e("TransferAmount");
    }
}

