/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.IncrementButtonWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.CoverItemVoiding;
import gregtech.common.covers.ManualImportExportMode;
import gregtech.common.covers.VoidingMode;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CoverItemVoidingAdvanced
extends CoverItemVoiding {
    protected VoidingMode voidingMode = VoidingMode.VOID_ANY;

    public CoverItemVoidingAdvanced(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
        this.itemFilterContainer.setMaxStackSize(1);
    }

    @Override
    protected void doTransferItems() {
        IItemHandler myItemHandler = (IItemHandler)this.coverHolder.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.attachedSide);
        if (myItemHandler == null) {
            return;
        }
        switch (this.voidingMode) {
            case VOID_ANY: {
                this.voidAny(myItemHandler);
                break;
            }
            case VOID_OVERFLOW: {
                this.voidOverflow(myItemHandler);
            }
        }
    }

    protected void voidOverflow(IItemHandler myItemHandler) {
        Map<ItemStack, CoverConveyor.TypeItemInfo> itemTypeCount = this.countInventoryItemsByType(myItemHandler);
        block0: for (CoverConveyor.TypeItemInfo typeItemInfo : itemTypeCount.values()) {
            int itemToVoidAmount = 0;
            if (this.getItemFilterContainer().getFilterWrapper().getItemFilter() == null) {
                itemToVoidAmount = typeItemInfo.totalCount - this.itemFilterContainer.getTransferStackSize();
            } else if (this.itemFilterContainer.testItemStack(typeItemInfo.itemStack)) {
                Object matchedSlot = this.itemFilterContainer.matchItemStack(typeItemInfo.itemStack);
                itemToVoidAmount = typeItemInfo.totalCount - this.itemFilterContainer.getSlotTransferLimit(matchedSlot);
            }
            if (itemToVoidAmount <= 0) continue;
            for (int srcIndex = 0; srcIndex < myItemHandler.getSlots(); ++srcIndex) {
                ItemStack extracted;
                ItemStack is = myItemHandler.getStackInSlot(srcIndex);
                if (!is.func_190926_b() && ItemStack.func_179545_c((ItemStack)is, (ItemStack)typeItemInfo.itemStack) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)typeItemInfo.itemStack) && !(extracted = myItemHandler.extractItem(srcIndex, itemToVoidAmount, false)).func_190926_b()) {
                    itemToVoidAmount -= extracted.func_190916_E();
                }
                if (itemToVoidAmount == 0) continue block0;
            }
        }
    }

    @Override
    protected String getUITitle() {
        return "cover.item.voiding.advanced.title";
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup primaryGroup = new WidgetGroup();
        primaryGroup.addWidget(new LabelWidget(10, 5, this.getUITitle(), new Object[0]));
        primaryGroup.addWidget(new CycleButtonWidget(91, 14, 75, 20, VoidingMode.class, this::getVoidingMode, this::setVoidingMode).setTooltipHoverString("cover.voiding.voiding_mode.description"));
        this.initFilterUI(20, primaryGroup::addWidget);
        primaryGroup.addWidget(new CycleButtonWidget(10, 115, 80, 18, this::isWorkingEnabled, this::setWorkingEnabled, "cover.voiding.label.disabled", "cover.voiding.label.enabled").setTooltipHoverString("cover.voiding.tooltip"));
        primaryGroup.addWidget(new CycleButtonWidget(10, 135, 116, 18, ManualImportExportMode.class, this::getManualImportExportMode, this::setManualImportExportMode).setTooltipHoverString("cover.universal.manual_import_export.mode.description"));
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 247).widget(primaryGroup).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 7, 165);
        return this.buildUI(builder, player);
    }

    public void initFilterUI(int y, Consumer<Widget> widgetGroup) {
        widgetGroup.accept(new LabelWidget(10, y, "cover.conveyor.item_filter.title", new Object[0]));
        widgetGroup.accept(new SlotWidget((IItemHandlerModifiable)this.itemFilterContainer.getFilterInventory(), 0, 10, y + 15).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.FILTER_SLOT_OVERLAY));
        ServerWidgetGroup stackSizeGroup = new ServerWidgetGroup(() -> this.itemFilterContainer.getFilterWrapper().getItemFilter() == null && this.voidingMode == VoidingMode.VOID_OVERFLOW);
        stackSizeGroup.addWidget(new ImageWidget(111, 34, 35, 20, GuiTextures.DISPLAY));
        stackSizeGroup.addWidget(new IncrementButtonWidget(146, 34, 20, 20, 1, 8, 64, 512, this.itemFilterContainer::adjustTransferStackSize).setDefaultTooltip().setTextScale(0.7f).setShouldClientCallback(false));
        stackSizeGroup.addWidget(new IncrementButtonWidget(91, 34, 20, 20, -1, -8, -64, -512, this.itemFilterContainer::adjustTransferStackSize).setDefaultTooltip().setTextScale(0.7f).setShouldClientCallback(false));
        stackSizeGroup.addWidget(new TextFieldWidget2(113, 41, 31, 20, () -> String.valueOf(this.itemFilterContainer.getTransferStackSize()), val -> {
            if (val != null && !val.isEmpty()) {
                this.itemFilterContainer.setTransferStackSize(MathHelper.func_76125_a((int)Integer.parseInt(val), (int)1, (int)this.voidingMode.maxStackSize));
            }
        }).setCentered(true).setNumbersOnly(1, Integer.MAX_VALUE).setMaxLength(10).setScale(0.9f));
        widgetGroup.accept(stackSizeGroup);
        this.itemFilterContainer.getFilterWrapper().initUI(y + 38, widgetGroup);
        this.itemFilterContainer.getFilterWrapper().blacklistUI(y + 38, widgetGroup, () -> this.voidingMode != VoidingMode.VOID_OVERFLOW);
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.ITEM_VOIDING_ADVANCED.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    public void setVoidingMode(VoidingMode voidingMode) {
        this.voidingMode = voidingMode;
        this.itemFilterContainer.setMaxStackSize(voidingMode.maxStackSize);
        this.coverHolder.markDirty();
    }

    public VoidingMode getVoidingMode() {
        return this.voidingMode;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("VoidMode", this.voidingMode.ordinal());
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.voidingMode = VoidingMode.values()[tagCompound.func_74762_e("VoidMode")];
    }
}

