/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.IncrementButtonWidget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.TransferMode;
import gregtech.common.pipelike.itempipe.net.ItemNetHandler;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;

public class CoverRoboticArm
extends CoverConveyor {
    protected TransferMode transferMode = TransferMode.TRANSFER_ANY;
    protected int itemsTransferBuffered;

    public CoverRoboticArm(ICoverable coverable, EnumFacing attachedSide, int tier, int itemsPerSecond) {
        super(coverable, attachedSide, tier, itemsPerSecond);
        this.itemFilterContainer.setMaxStackSize(1);
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        if (this.conveyorMode == CoverConveyor.ConveyorMode.EXPORT) {
            Textures.ARM_OVERLAY.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
        } else {
            Textures.ARM_OVERLAY_INVERTED.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
        }
    }

    @Override
    protected int doTransferItems(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        if (this.conveyorMode == CoverConveyor.ConveyorMode.EXPORT && itemHandler instanceof ItemNetHandler && this.transferMode == TransferMode.KEEP_EXACT) {
            return 0;
        }
        if (this.conveyorMode == CoverConveyor.ConveyorMode.IMPORT && myItemHandler instanceof ItemNetHandler && this.transferMode == TransferMode.KEEP_EXACT) {
            return 0;
        }
        switch (this.transferMode) {
            case TRANSFER_ANY: {
                return this.doTransferItemsAny(itemHandler, myItemHandler, maxTransferAmount);
            }
            case TRANSFER_EXACT: {
                return this.doTransferExact(itemHandler, myItemHandler, maxTransferAmount);
            }
            case KEEP_EXACT: {
                return this.doKeepExact(itemHandler, myItemHandler, maxTransferAmount);
            }
        }
        return 0;
    }

    protected int doTransferExact(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        Map<ItemStack, CoverConveyor.TypeItemInfo> sourceItemAmount = this.doCountSourceInventoryItemsByType(itemHandler, myItemHandler);
        Iterator<ItemStack> iterator = sourceItemAmount.keySet().iterator();
        while (iterator.hasNext()) {
            CoverConveyor.TypeItemInfo sourceInfo = sourceItemAmount.get(iterator.next());
            int itemAmount = sourceInfo.totalCount;
            int itemToMoveAmount = this.itemFilterContainer.getSlotTransferLimit(sourceInfo.filterSlot);
            if (itemAmount >= itemToMoveAmount) {
                sourceInfo.totalCount = itemToMoveAmount;
                continue;
            }
            iterator.remove();
        }
        int itemsTransferred = 0;
        int maxTotalTransferAmount = maxTransferAmount + this.itemsTransferBuffered;
        boolean notEnoughTransferRate = false;
        for (CoverConveyor.TypeItemInfo itemInfo : sourceItemAmount.values()) {
            if (maxTotalTransferAmount >= itemInfo.totalCount) {
                boolean result = this.doTransferItemsExact(itemHandler, myItemHandler, itemInfo);
                itemsTransferred += result ? itemInfo.totalCount : 0;
                maxTotalTransferAmount -= result ? itemInfo.totalCount : 0;
                continue;
            }
            notEnoughTransferRate = true;
        }
        this.itemsTransferBuffered = itemsTransferred == 0 && notEnoughTransferRate ? (this.itemsTransferBuffered += maxTransferAmount) : 0;
        return Math.min(itemsTransferred, maxTransferAmount);
    }

    protected int doKeepExact(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        Map<Object, CoverConveyor.GroupItemInfo> currentItemAmount = this.doCountDestinationInventoryItemsByMatchIndex(itemHandler, myItemHandler);
        Map<Object, CoverConveyor.GroupItemInfo> sourceItemAmounts = this.doCountDestinationInventoryItemsByMatchIndex(myItemHandler, itemHandler);
        Iterator<Object> iterator = sourceItemAmounts.keySet().iterator();
        while (iterator.hasNext()) {
            Object filterSlotIndex = iterator.next();
            CoverConveyor.GroupItemInfo sourceInfo = sourceItemAmounts.get(filterSlotIndex);
            int itemToKeepAmount = this.itemFilterContainer.getSlotTransferLimit(sourceInfo.filterSlot);
            int itemAmount = 0;
            if (currentItemAmount.containsKey(filterSlotIndex)) {
                CoverConveyor.GroupItemInfo destItemInfo = currentItemAmount.get(filterSlotIndex);
                itemAmount = destItemInfo.totalCount;
            }
            if (itemAmount < itemToKeepAmount) {
                sourceInfo.totalCount = itemToKeepAmount - itemAmount;
                continue;
            }
            iterator.remove();
        }
        return this.doTransferItemsByGroup(itemHandler, myItemHandler, sourceItemAmounts, maxTransferAmount);
    }

    public int getBuffer() {
        return this.itemsTransferBuffered;
    }

    public void buffer(int amount) {
        this.itemsTransferBuffered += amount;
    }

    public void clearBuffer() {
        this.itemsTransferBuffered = 0;
    }

    public void setTransferMode(TransferMode transferMode) {
        this.transferMode = transferMode;
        this.coverHolder.markDirty();
        this.itemFilterContainer.setMaxStackSize(transferMode.maxStackSize);
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    private boolean shouldDisplayAmountSlider() {
        if (this.transferMode == TransferMode.TRANSFER_ANY) {
            return false;
        }
        return this.itemFilterContainer.showGlobalTransferLimitSlider();
    }

    @Override
    protected String getUITitle() {
        return "cover.robotic_arm.title";
    }

    @Override
    protected ModularUI buildUI(ModularUI.Builder builder, EntityPlayer player) {
        WidgetGroup primaryGroup = new WidgetGroup();
        primaryGroup.addWidget(new CycleButtonWidget(91, 45, 75, 20, TransferMode.class, this::getTransferMode, this::setTransferMode).setTooltipHoverString("cover.robotic_arm.transfer_mode.description"));
        ServerWidgetGroup stackSizeGroup = new ServerWidgetGroup(this::shouldDisplayAmountSlider);
        stackSizeGroup.addWidget(new ImageWidget(111, 70, 35, 20, GuiTextures.DISPLAY));
        stackSizeGroup.addWidget(new IncrementButtonWidget(146, 70, 20, 20, 1, 8, 64, 512, this.itemFilterContainer::adjustTransferStackSize).setDefaultTooltip().setTextScale(0.7f).setShouldClientCallback(false));
        stackSizeGroup.addWidget(new IncrementButtonWidget(91, 70, 20, 20, -1, -8, -64, -512, this.itemFilterContainer::adjustTransferStackSize).setDefaultTooltip().setTextScale(0.7f).setShouldClientCallback(false));
        stackSizeGroup.addWidget(new TextFieldWidget2(113, 77, 31, 20, () -> String.valueOf(this.itemFilterContainer.getTransferStackSize()), val -> {
            if (val != null && !val.isEmpty()) {
                this.itemFilterContainer.setTransferStackSize(MathHelper.func_76125_a((int)Integer.parseInt(val), (int)1, (int)this.transferMode.maxStackSize));
            }
        }).setNumbersOnly(1, this.transferMode.maxStackSize).setMaxLength(4).setScale(0.9f));
        primaryGroup.addWidget(stackSizeGroup);
        return super.buildUI(builder.widget(primaryGroup), player);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferMode", this.transferMode.ordinal());
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.transferMode = TransferMode.values()[tagCompound.func_74762_e("TransferMode")];
    }
}

