/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.detector;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.ICoverable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class CoverDetectorBase
extends CoverBehavior {
    protected static final String NBT_KEY_IS_INVERTED = "isInverted";
    private boolean isInverted = false;

    public CoverDetectorBase(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
    }

    protected boolean isInverted() {
        return this.isInverted;
    }

    protected void setInverted(boolean isInverted) {
        this.isInverted = isInverted;
    }

    private void toggleInvertedWithNotification() {
        this.setInverted(!this.isInverted());
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.coverHolder.writeCoverData(this, 100, b -> b.writeBoolean(this.isInverted()));
            this.coverHolder.notifyBlockUpdate();
            this.coverHolder.markDirty();
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74757_a(NBT_KEY_IS_INVERTED, this.isInverted());
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        if (tagCompound.func_74764_b(NBT_KEY_IS_INVERTED)) {
            this.setInverted(tagCompound.func_74767_n(NBT_KEY_IS_INVERTED));
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeBoolean(this.isInverted());
    }

    @Override
    public void readInitialSyncData(PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.setInverted(packetBuffer.readBoolean());
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (this.coverHolder.getWorld().field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        String translationKey = this.isInverted() ? "gregtech.cover.detector_base.message_inverted_state" : "gregtech.cover.detector_base.message_normal_state";
        playerIn.func_145747_a((ITextComponent)new TextComponentTranslation(translationKey, new Object[0]));
        this.toggleInvertedWithNotification();
        return EnumActionResult.SUCCESS;
    }
}

