/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.detector;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RedstoneUtil;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.detector.CoverDetectorEnergy;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;

public class CoverDetectorEnergyAdvanced
extends CoverDetectorEnergy
implements CoverWithUI {
    private static final int PADDING = 5;
    private static final int SIZE = 18;
    private static final long DEFAULT_MIN_EU = 0L;
    private static final long DEFAULT_MAX_EU = 2048L;
    private static final int DEFAULT_MIN_PERCENT = 33;
    private static final int DEFAULT_MAX_PERCENT = 66;
    public long minValue = 0L;
    public long maxValue = 2048L;
    private int outputAmount = 0;
    private boolean usePercent = false;
    private WidgetGroup widgetsToUpdate;

    public CoverDetectorEnergyAdvanced(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.DETECTOR_ENERGY_ADVANCED.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void func_73660_a() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        IEnergyContainer energyContainer = this.coverHolder.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null);
        if (energyContainer != null) {
            if (this.usePercent) {
                if (energyContainer.getEnergyCapacity() > 0L) {
                    float ratio = (float)energyContainer.getEnergyStored() / (float)energyContainer.getEnergyCapacity();
                    this.outputAmount = RedstoneUtil.computeLatchedRedstoneBetweenValues(ratio * 100.0f, this.maxValue, this.minValue, this.isInverted(), this.outputAmount);
                } else {
                    this.outputAmount = this.isInverted() ? 0 : 15;
                }
            } else {
                this.outputAmount = RedstoneUtil.computeLatchedRedstoneBetweenValues(energyContainer.getEnergyStored(), this.maxValue, this.minValue, this.isInverted(), this.outputAmount);
            }
        }
        this.setRedstoneSignalOutput(this.outputAmount);
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup group = new WidgetGroup();
        group.addWidget(new LabelWidget(10, 8, "cover.advanced_energy_detector.label", new Object[0]));
        group.addWidget(new LabelWidget(10, 28, "cover.advanced_energy_detector.min", new Object[0]));
        group.addWidget(new ImageWidget(72, 23, 144, 18, GuiTextures.DISPLAY));
        group.addWidget(new LabelWidget(10, 51, "cover.advanced_energy_detector.max", new Object[0]));
        group.addWidget(new ImageWidget(72, 46, 144, 18, GuiTextures.DISPLAY));
        this.widgetsToUpdate = this.constructWidgetsToUpdate();
        group.addWidget(new LabelWidget(10, 74, "cover.advanced_energy_detector.modes_label", new Object[0]));
        group.addWidget(new CycleButtonWidget(72, 69, 72, 18, this::isUsePercent, this::setUsePercent, "cover.advanced_energy_detector.mode_eu", "cover.advanced_energy_detector.mode_percent").setTooltipHoverString("cover.advanced_energy_detector.modes_tooltip"));
        group.addWidget(new LabelWidget(10, 97, "cover.advanced_energy_detector.invert_label", new Object[0]));
        group.addWidget(new CycleButtonWidget(72, 92, 72, 18, this::isInverted, this::setInverted, "cover.advanced_energy_detector.normal", "cover.advanced_energy_detector.inverted").setTooltipHoverString("cover.advanced_energy_detector.invert_tooltip"));
        return ModularUI.builder(GuiTextures.BACKGROUND, 230, 126).widget(group).widget(this.widgetsToUpdate).build(this, player);
    }

    private WidgetGroup constructWidgetsToUpdate() {
        WidgetGroup sync = new WidgetGroup();
        sync.addWidget(new TextFieldWidget2(76, 28, 144, 18, this::getMinValue, this::setMinValue).setAllowedChars(TextFieldWidget2.NATURAL_NUMS).setMaxLength(this.getLength()).setPostFix(this.getPostFix()));
        sync.addWidget(new TextFieldWidget2(76, 51, 144, 18, this::getMaxValue, this::setMaxValue).setAllowedChars(TextFieldWidget2.NATURAL_NUMS).setMaxLength(this.getLength()).setPostFix(this.getPostFix()));
        return sync;
    }

    private String getMinValue() {
        return String.valueOf(this.minValue);
    }

    private String getMaxValue() {
        return String.valueOf(this.maxValue);
    }

    private void setMinValue(String val) {
        long parsedValue = GTUtility.tryParseLong(val, this.usePercent ? 33L : 0L);
        this.minValue = Math.min(this.maxValue - 1L, Math.max(0L, parsedValue));
    }

    private void setMaxValue(String val) {
        long parsedValue = GTUtility.tryParseLong(val, this.usePercent ? 66L : 2048L);
        long maxUpperLimit = this.usePercent ? 100L : Long.MAX_VALUE;
        this.maxValue = Math.max(this.minValue + 1L, Math.min(parsedValue, maxUpperLimit));
    }

    private boolean isUsePercent() {
        return this.usePercent;
    }

    private void setUsePercent(boolean b) {
        this.usePercent = b;
        if (this.usePercent) {
            this.minValue = 33L;
            this.maxValue = 66L;
        } else {
            this.minValue = 0L;
            this.maxValue = 2048L;
        }
        this.updateSyncedWidgets();
    }

    private void updateSyncedWidgets() {
        for (Widget widget : this.widgetsToUpdate.widgets) {
            ((TextFieldWidget2)widget).setPostFix(this.getPostFix());
            ((TextFieldWidget2)widget).setMaxLength(this.getLength());
        }
    }

    private String getPostFix() {
        return this.usePercent ? " %" : " EU";
    }

    private int getLength() {
        return this.usePercent ? 3 : 19;
    }

    @Override
    @Nonnull
    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74772_a("maxEU", this.maxValue);
        tagCompound.func_74772_a("minEU", this.minValue);
        tagCompound.func_74768_a("outputAmount", this.outputAmount);
        tagCompound.func_74757_a("usePercent", this.usePercent);
        return tagCompound;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.minValue = tagCompound.func_74763_f("minEU");
        this.maxValue = tagCompound.func_74763_f("maxEU");
        this.outputAmount = tagCompound.func_74762_e("outputAmount");
        this.usePercent = tagCompound.func_74767_n("usePercent");
        this.readDeprecatedInvertedKeyFromNBT(tagCompound);
    }

    private void readDeprecatedInvertedKeyFromNBT(@Nonnull NBTTagCompound tagCompound) {
        String oldInvertedKey = "inverted";
        if (!tagCompound.func_74764_b("isInverted") && tagCompound.func_74764_b(oldInvertedKey)) {
            this.setInverted(tagCompound.func_74767_n(oldInvertedKey));
        }
    }

    @Override
    public void writeInitialSyncData(@Nonnull PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeLong(this.minValue);
        packetBuffer.writeLong(this.maxValue);
        packetBuffer.writeInt(this.outputAmount);
        packetBuffer.writeBoolean(this.usePercent);
    }

    @Override
    public void readInitialSyncData(@Nonnull PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.minValue = packetBuffer.readLong();
        this.maxValue = packetBuffer.readLong();
        this.outputAmount = packetBuffer.readInt();
        this.usePercent = packetBuffer.readBoolean();
    }
}

