/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.detector;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RedstoneUtil;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.detector.CoverDetectorFluid;
import gregtech.common.covers.filter.FluidFilterContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CoverDetectorFluidAdvanced
extends CoverDetectorFluid
implements CoverWithUI {
    private static final int PADDING = 3;
    private static final int SIZE = 18;
    private static final int DEFAULT_MIN = 1000;
    private static final int DEFAULT_MAX = 16000;
    private int min = 1000;
    private int max = 16000;
    protected FluidFilterContainer fluidFilter = new FluidFilterContainer(this);

    public CoverDetectorFluidAdvanced(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.DETECTOR_FLUID_ADVANCED.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup group = new WidgetGroup();
        group.addWidget(new LabelWidget(10, 8, "cover.advanced_fluid_detector.label", new Object[0]));
        group.addWidget(new LabelWidget(10, 26, "cover.advanced_fluid_detector.min", new Object[0]));
        group.addWidget(new ImageWidget(94, 21, 72, 18, GuiTextures.DISPLAY));
        group.addWidget(new TextFieldWidget2(98, 26, 72, 18, this::getMinValue, this::setMinValue).setMaxLength(10).setAllowedChars(TextFieldWidget2.WHOLE_NUMS).setPostFix("L"));
        group.addWidget(new LabelWidget(10, 47, "cover.advanced_fluid_detector.max", new Object[0]));
        group.addWidget(new ImageWidget(94, 42, 72, 18, GuiTextures.DISPLAY));
        group.addWidget(new TextFieldWidget2(98, 47, 72, 18, this::getMaxValue, this::setMaxValue).setMaxLength(10).setAllowedChars(TextFieldWidget2.WHOLE_NUMS).setPostFix("L"));
        group.addWidget(new LabelWidget(10, 68, "cover.advanced_energy_detector.invert_label", new Object[0]));
        group.addWidget(new CycleButtonWidget(94, 63, 72, 18, this::isInverted, this::setInverted, "cover.advanced_energy_detector.normal", "cover.advanced_energy_detector.inverted").setTooltipHoverString("cover.advanced_fluid_detector.invert_tooltip"));
        this.fluidFilter.initUI(89, group::addWidget);
        return ModularUI.builder(GuiTextures.BACKGROUND, 176, 246).widget(group).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 7, 164).build(this, player);
    }

    private String getMinValue() {
        return String.valueOf(this.min);
    }

    private String getMaxValue() {
        return String.valueOf(this.max);
    }

    private void setMinValue(String val) {
        int parsedValue = GTUtility.tryParseInt(val, 1000);
        this.min = Math.min(this.max - 1, Math.max(0, parsedValue));
    }

    private void setMaxValue(String val) {
        int parsedValue = GTUtility.tryParseInt(val, 16000);
        this.max = Math.max(this.min + 1, parsedValue);
    }

    @Override
    public void func_73660_a() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        IFluidHandler fluidHandler = (IFluidHandler)this.coverHolder.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (fluidHandler == null) {
            return;
        }
        IFluidTankProperties[] tankProperties = fluidHandler.getTankProperties();
        int storedFluid = 0;
        for (IFluidTankProperties properties : tankProperties) {
            FluidStack contents = properties.getContents();
            if (contents == null || !this.fluidFilter.testFluidStack(contents)) continue;
            storedFluid += contents.amount;
        }
        this.setRedstoneSignalOutput(RedstoneUtil.computeRedstoneBetweenValues(storedFluid, this.max, this.min, this.isInverted()));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("min", this.min);
        tagCompound.func_74768_a("max", this.max);
        tagCompound.func_74782_a("filter", (NBTBase)this.fluidFilter.serializeNBT());
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.min = tagCompound.func_74762_e("min");
        this.max = tagCompound.func_74762_e("max");
        this.fluidFilter.deserializeNBT(tagCompound.func_74775_l("filter"));
    }

    @Override
    public void writeInitialSyncData(PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeInt(this.min);
        packetBuffer.writeInt(this.max);
    }

    @Override
    public void readInitialSyncData(PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.min = packetBuffer.readInt();
        this.max = packetBuffer.readInt();
    }
}

