/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.detector;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RedstoneUtil;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.detector.CoverDetectorItem;
import gregtech.common.covers.filter.ItemFilterContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CoverDetectorItemAdvanced
extends CoverDetectorItem
implements CoverWithUI {
    private static final int PADDING = 3;
    private static final int SIZE = 18;
    private static final int DEFAULT_MIN = 64;
    private static final int DEFAULT_MAX = 512;
    private int min = 64;
    private int max = 512;
    protected ItemFilterContainer itemFilter = new ItemFilterContainer(this);

    public CoverDetectorItemAdvanced(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.DETECTOR_ITEM_ADVANCED.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup group = new WidgetGroup();
        group.addWidget(new LabelWidget(10, 8, "cover.advanced_item_detector.label", new Object[0]));
        group.addWidget(new LabelWidget(10, 26, "cover.advanced_item_detector.min", new Object[0]));
        group.addWidget(new ImageWidget(94, 21, 72, 18, GuiTextures.DISPLAY));
        group.addWidget(new TextFieldWidget2(98, 26, 72, 18, this::getMinValue, this::setMinValue).setMaxLength(10).setAllowedChars(TextFieldWidget2.WHOLE_NUMS));
        group.addWidget(new LabelWidget(10, 47, "cover.advanced_item_detector.max", new Object[0]));
        group.addWidget(new ImageWidget(94, 42, 72, 18, GuiTextures.DISPLAY));
        group.addWidget(new TextFieldWidget2(98, 47, 72, 18, this::getMaxValue, this::setMaxValue).setMaxLength(10).setAllowedChars(TextFieldWidget2.WHOLE_NUMS));
        group.addWidget(new LabelWidget(10, 68, "cover.advanced_energy_detector.invert_label", new Object[0]));
        group.addWidget(new CycleButtonWidget(94, 63, 72, 18, this::isInverted, this::setInverted, "cover.advanced_energy_detector.normal", "cover.advanced_energy_detector.inverted").setTooltipHoverString("cover.advanced_item_detector.invert_tooltip"));
        this.itemFilter.initUI(89, group::addWidget);
        return ModularUI.builder(GuiTextures.BACKGROUND, 176, 270).widget(group).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, 7, 188).build(this, player);
    }

    private String getMinValue() {
        return String.valueOf(this.min);
    }

    private String getMaxValue() {
        return String.valueOf(this.max);
    }

    private void setMinValue(String val) {
        int parsedValue = GTUtility.tryParseInt(val, 64);
        this.min = Math.min(this.max - 1, Math.max(0, parsedValue));
    }

    private void setMaxValue(String val) {
        int parsedValue = GTUtility.tryParseInt(val, 512);
        this.max = Math.max(this.min + 1, parsedValue);
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void func_73660_a() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        IItemHandler itemHandler = (IItemHandler)this.coverHolder.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (itemHandler == null) {
            return;
        }
        int storedItems = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!this.itemFilter.testItemStack(itemHandler.getStackInSlot(i))) continue;
            storedItems += itemHandler.getStackInSlot(i).func_190916_E();
        }
        this.setRedstoneSignalOutput(RedstoneUtil.computeRedstoneBetweenValues(storedItems, this.max, this.min, this.isInverted()));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("min", this.min);
        tagCompound.func_74768_a("max", this.max);
        tagCompound.func_74782_a("filter", (NBTBase)this.itemFilter.serializeNBT());
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.min = tagCompound.func_74762_e("min");
        this.max = tagCompound.func_74762_e("max");
        this.itemFilter.deserializeNBT(tagCompound.func_74775_l("filter"));
    }

    @Override
    public void writeInitialSyncData(PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeInt(this.min);
        packetBuffer.writeInt(this.max);
    }

    @Override
    public void readInitialSyncData(PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.min = packetBuffer.readInt();
        this.max = packetBuffer.readInt();
    }
}

