/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.unification.stack.ItemAndMetadata;
import gregtech.common.covers.filter.ItemFilter;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IStringSerializable;

public class SmartItemFilter
extends ItemFilter {
    private SmartFilteringMode filteringMode = SmartFilteringMode.ELECTROLYZER;

    public SmartFilteringMode getFilteringMode() {
        return this.filteringMode;
    }

    public void setFilteringMode(SmartFilteringMode filteringMode) {
        this.filteringMode = filteringMode;
        this.markDirty();
    }

    @Override
    public int getSlotTransferLimit(Object matchSlot, int globalTransferLimit) {
        ItemAndMetadataAndStackSize itemAndMetadata = (ItemAndMetadataAndStackSize)matchSlot;
        return itemAndMetadata.transferStackSize;
    }

    @Override
    public Object matchItemStack(ItemStack itemStack) {
        ItemAndMetadata itemAndMetadata = new ItemAndMetadata(itemStack);
        Integer cachedTransferRateValue = (Integer)this.filteringMode.transferStackSizesCache.get(itemAndMetadata);
        if (cachedTransferRateValue == null) {
            ItemStack infinitelyBigStack = itemStack.func_77946_l();
            infinitelyBigStack.func_190920_e(Integer.MAX_VALUE);
            Recipe recipe = this.filteringMode.recipeMap.findRecipe(Long.MAX_VALUE, Collections.singletonList(infinitelyBigStack), Collections.emptyList());
            if (recipe == null) {
                this.filteringMode.transferStackSizesCache.put(itemAndMetadata, 0);
                cachedTransferRateValue = 0;
            } else {
                GTRecipeInput inputIngredient = recipe.getInputs().iterator().next();
                this.filteringMode.transferStackSizesCache.put(itemAndMetadata, inputIngredient.getAmount());
                cachedTransferRateValue = inputIngredient.getAmount();
            }
        }
        if (cachedTransferRateValue == 0) {
            return null;
        }
        return new ItemAndMetadataAndStackSize(itemAndMetadata, cachedTransferRateValue);
    }

    @Override
    public void initUI(Consumer<Widget> widgetGroup) {
        widgetGroup.accept(new CycleButtonWidget(10, 0, 75, 20, SmartFilteringMode.class, this::getFilteringMode, this::setFilteringMode).setTooltipHoverString("cover.smart_item_filter.filtering_mode.description"));
    }

    @Override
    public int getTotalOccupiedHeight() {
        return 20;
    }

    @Override
    public boolean showGlobalTransferLimitSlider() {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("FilterMode", this.filteringMode.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        this.filteringMode = SmartFilteringMode.values()[tagCompound.func_74762_e("FilterMode")];
    }

    public static enum SmartFilteringMode implements IStringSerializable
    {
        ELECTROLYZER("cover.smart_item_filter.filtering_mode.electrolyzer", RecipeMaps.ELECTROLYZER_RECIPES),
        CENTRIFUGE("cover.smart_item_filter.filtering_mode.centrifuge", RecipeMaps.CENTRIFUGE_RECIPES),
        SIFTER("cover.smart_item_filter.filtering_mode.sifter", RecipeMaps.SIFTER_RECIPES);

        private final Map<ItemAndMetadata, Integer> transferStackSizesCache = new Object2IntOpenHashMap();
        public final String localeName;
        public final RecipeMap<?> recipeMap;

        private SmartFilteringMode(String localeName, RecipeMap<?> recipeMap) {
            this.localeName = localeName;
            this.recipeMap = recipeMap;
        }

        @Nonnull
        public String func_176610_l() {
            return this.localeName;
        }
    }

    private static class ItemAndMetadataAndStackSize {
        public final ItemAndMetadata itemAndMetadata;
        public final int transferStackSize;

        public ItemAndMetadataAndStackSize(ItemAndMetadata itemAndMetadata, int transferStackSize) {
            this.itemAndMetadata = itemAndMetadata;
            this.transferStackSize = transferStackSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ItemAndMetadataAndStackSize)) {
                return false;
            }
            ItemAndMetadataAndStackSize that = (ItemAndMetadataAndStackSize)o;
            return this.itemAndMetadata.equals(that.itemAndMetadata);
        }

        public int hashCode() {
            return this.itemAndMetadata.hashCode();
        }
    }
}

