/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.util.Position;
import gregtech.common.covers.filter.FilterTypeRegistry;
import gregtech.common.covers.filter.ItemFilter;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public class WidgetGroupItemFilter
extends AbstractWidgetGroup {
    private final Supplier<ItemFilter> itemFilterSupplier;
    private ItemFilter itemFilter;
    private int maxStackSize = 1;

    public WidgetGroupItemFilter(int yPosition, Supplier<ItemFilter> itemFilterSupplier) {
        super(new Position(0, yPosition));
        this.itemFilterSupplier = itemFilterSupplier;
    }

    @Override
    public void detectAndSendChanges() {
        int newMaxStackSize;
        super.detectAndSendChanges();
        ItemFilter newItemFilter = this.itemFilterSupplier.get();
        if (this.itemFilter != newItemFilter) {
            this.clearAllWidgets();
            this.itemFilter = newItemFilter;
            if (this.itemFilter != null) {
                this.itemFilter.initUI(this::addWidget);
            }
            this.writeUpdateInfo(2, buffer -> {
                if (this.itemFilter != null) {
                    buffer.writeBoolean(true);
                    int filterId = FilterTypeRegistry.getIdForItemFilter(this.itemFilter);
                    buffer.func_150787_b(filterId);
                } else {
                    buffer.writeBoolean(false);
                }
            });
        }
        int n = newMaxStackSize = this.itemFilter == null ? 1 : this.itemFilter.getMaxStackSize();
        if (this.maxStackSize != newMaxStackSize) {
            this.maxStackSize = newMaxStackSize;
            this.writeUpdateInfo(3, buffer -> buffer.func_150787_b(this.maxStackSize));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 2) {
            this.clearAllWidgets();
            if (buffer.readBoolean()) {
                int filterId = buffer.func_150792_a();
                this.itemFilter = FilterTypeRegistry.createItemFilterById(filterId);
                this.itemFilter.initUI(this::addWidget);
                this.itemFilter.setMaxStackSize(this.maxStackSize);
            }
        } else if (id == 3) {
            this.maxStackSize = buffer.func_150792_a();
            if (this.itemFilter != null) {
                this.itemFilter.setMaxStackSize(this.maxStackSize);
            }
        }
    }
}

