/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.impl;

import gregtech.common.covers.filter.oreglob.node.BranchNode;
import gregtech.common.covers.filter.oreglob.node.NodeVisitor;
import gregtech.common.covers.filter.oreglob.node.OreGlobNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;

class NodeInterpreter
implements NodeVisitor {
    private final String input;
    private IntSet inputStates;
    private IntSet outputStates = new IntLinkedOpenHashSet();

    NodeInterpreter(String input) {
        this.input = input;
        this.inputStates = new IntLinkedOpenHashSet();
        this.inputStates.add(0);
    }

    private NodeInterpreter(String input, IntCollection inputStates) {
        this.input = input;
        this.inputStates = new IntLinkedOpenHashSet(inputStates);
    }

    NodeInterpreter evaluate(OreGlobNode root) {
        boolean first = true;
        while (root != null) {
            if (first) {
                first = false;
            } else {
                this.swapStateBuffer();
            }
            root = root.visit(this);
            if (!this.outputStates.isEmpty()) continue;
            break;
        }
        return this;
    }

    boolean isMatch() {
        return this.outputStates.contains(this.input.length());
    }

    private void swapStateBuffer() {
        IntSet t = this.inputStates;
        this.inputStates = this.outputStates;
        this.outputStates = t;
        t.clear();
    }

    @Override
    public void match(String match, boolean ignoreCase, boolean not) {
        IntIterator it = this.inputStates.iterator();
        while (it.hasNext()) {
            int state = it.nextInt();
            if (!this.input.regionMatches(ignoreCase, state, match, 0, match.length())) continue;
            this.outputStates.add(state + match.length());
        }
        if (not) {
            this.negate();
        }
    }

    @Override
    public void chars(int amount, boolean not) {
        if (not) {
            int state;
            int i = state + amount;
            for (state = this.computeMinInputState(); state < i; ++state) {
                this.outputStates.add(state);
            }
            ++state;
            while (state <= this.input.length()) {
                if (!this.inputStates.contains(state - amount)) {
                    this.outputStates.add(state);
                }
                ++state;
            }
        } else {
            IntIterator it = this.inputStates.iterator();
            while (it.hasNext()) {
                int state = it.nextInt();
                if (state + amount > this.input.length()) continue;
                this.outputStates.add(state + amount);
            }
        }
    }

    @Override
    public void charsOrMore(int amount, boolean not) {
        IntIterator it = this.inputStates.iterator();
        if (not) {
            while (it.hasNext()) {
                int state;
                for (int i = state = it.nextInt(); i < state + amount; ++i) {
                    this.outputStates.add(i);
                }
            }
        } else {
            while (it.hasNext()) {
                int state = it.nextInt();
                for (int i = state + amount; i <= this.input.length(); ++i) {
                    this.outputStates.add(i);
                }
            }
        }
    }

    @Override
    public void group(OreGlobNode node, boolean not) {
        this.evaluate(node);
        if (not) {
            this.negate();
        }
    }

    @Override
    public void branch(BranchNode.BranchType type, List<OreGlobNode> nodes, boolean not) {
        block0 : switch (type) {
            case OR: {
                int maxPossibleBranches = this.input.length() - this.computeMinInputState() + 1;
                for (OreGlobNode node : nodes) {
                    NodeInterpreter branchState = new NodeInterpreter(this.input, (IntCollection)this.inputStates).evaluate(node);
                    this.outputStates.addAll((IntCollection)branchState.outputStates);
                    if (this.outputStates.size() < maxPossibleBranches) continue;
                    break block0;
                }
                break;
            }
            case AND: {
                boolean first = true;
                for (OreGlobNode node : nodes) {
                    NodeInterpreter branchState = new NodeInterpreter(this.input, (IntCollection)this.inputStates).evaluate(node);
                    if (first) {
                        this.outputStates.addAll((IntCollection)branchState.outputStates);
                        first = false;
                    } else {
                        this.outputStates.retainAll((IntCollection)branchState.outputStates);
                    }
                    if (!this.outputStates.isEmpty()) continue;
                    break block0;
                }
                break;
            }
            case XOR: {
                for (OreGlobNode node : nodes) {
                    NodeInterpreter branchState = new NodeInterpreter(this.input, (IntCollection)this.inputStates).evaluate(node);
                    IntOpenHashSet out2 = new IntOpenHashSet((IntCollection)branchState.outputStates);
                    out2.removeAll((IntCollection)this.outputStates);
                    this.outputStates.removeAll((IntCollection)branchState.outputStates);
                    this.outputStates.addAll((IntCollection)out2);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown BranchType '" + (Object)((Object)type) + "'");
            }
        }
        if (not) {
            this.negate();
        }
    }

    @Override
    public void everything() {
        for (int i = this.computeMinInputState(); i <= this.input.length(); ++i) {
            this.outputStates.add(i);
        }
    }

    @Override
    public void nothing() {
    }

    @Override
    public void nonempty() {
        for (int i = this.computeMinInputState() + 1; i <= this.input.length(); ++i) {
            this.outputStates.add(i);
        }
    }

    @Override
    public void empty() {
        this.outputStates.addAll((IntCollection)this.inputStates);
    }

    @Override
    public void error() {
    }

    private int computeMinInputState() {
        int minInputState = this.input.length();
        IntIterator it = this.inputStates.iterator();
        while (it.hasNext()) {
            minInputState = Math.min(minInputState, it.nextInt());
        }
        return minInputState;
    }

    private void negate() {
        int minInputState = this.computeMinInputState();
        int maxPossibleBranches = this.input.length() - minInputState + 1;
        if (this.outputStates.size() >= maxPossibleBranches) {
            this.outputStates.clear();
            return;
        }
        this.swapStateBuffer();
        for (int i = minInputState; i <= this.input.length(); ++i) {
            if (this.inputStates.contains(i)) continue;
            this.outputStates.add(i);
        }
    }
}

