/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.impl;

import gregtech.api.util.oreglob.OreGlob;
import gregtech.common.covers.filter.oreglob.node.BranchNode;
import gregtech.common.covers.filter.oreglob.node.NodeVisitor;
import gregtech.common.covers.filter.oreglob.node.OreGlobNode;
import java.util.List;

class NodeVisualizer
implements NodeVisitor {
    private final OreGlob.Visualizer visualizer;
    private final int indents;

    NodeVisualizer(OreGlob.Visualizer visualizer) {
        this(visualizer, 0);
    }

    NodeVisualizer(OreGlob.Visualizer visualizer, int indents) {
        this.visualizer = visualizer;
        this.indents = indents;
    }

    void visit(OreGlobNode node) {
        boolean first = true;
        while (node != null) {
            if (first) {
                first = false;
            } else {
                this.visualizer.newLine(this.indents);
                this.visualizer.text("... followed by ");
            }
            node = node.visit(this);
        }
    }

    @Override
    public void match(String match, boolean ignoreCase, boolean not) {
        if (not) {
            this.visualizer.text("not ", OreGlob.VisualizationHint.NEGATION);
        }
        this.visualizer.text("'", OreGlob.VisualizationHint.NODE);
        this.visualizer.text(match, OreGlob.VisualizationHint.VALUE);
        this.visualizer.text("'", OreGlob.VisualizationHint.NODE);
    }

    @Override
    public void chars(int amount, boolean not) {
        if (not) {
            this.visualizer.text("either more or less than ", OreGlob.VisualizationHint.NEGATION);
        }
        this.visualizer.number(amount, OreGlob.VisualizationHint.VALUE);
        this.visualizer.text(amount == 1 ? " character" : " characters", OreGlob.VisualizationHint.NODE);
    }

    @Override
    public void charsOrMore(int amount, boolean not) {
        if (not) {
            this.visualizer.text("less than ", OreGlob.VisualizationHint.NODE);
            this.visualizer.number(amount);
            this.visualizer.text(" characters", OreGlob.VisualizationHint.NODE);
        } else {
            this.visualizer.number(amount);
            this.visualizer.text(" or more characters", OreGlob.VisualizationHint.NODE);
        }
    }

    @Override
    public void group(OreGlobNode node, boolean not) {
        if (not) {
            this.visualizer.text("not", OreGlob.VisualizationHint.NEGATION);
            this.visualizer.text(":", OreGlob.VisualizationHint.NODE);
            this.visualizer.newLine(this.indents + 1);
            new NodeVisualizer(this.visualizer, this.indents + 1).visit(node);
        } else {
            this.visit(node);
        }
    }

    @Override
    public void branch(BranchNode.BranchType type, List<OreGlobNode> nodes, boolean not) {
        switch (type) {
            case OR: {
                if (not) {
                    this.visualizer.text("anything that ", OreGlob.VisualizationHint.NODE);
                    this.visualizer.text("isn't", OreGlob.VisualizationHint.NEGATION);
                    this.visualizer.text(" one of...", OreGlob.VisualizationHint.NODE);
                } else {
                    this.visualizer.text("one of...", OreGlob.VisualizationHint.NODE);
                }
                for (int i = 0; i < nodes.size(); ++i) {
                    OreGlobNode node = nodes.get(i);
                    this.visualizer.newLine(this.indents);
                    if (i == 0) {
                        this.visualizer.text("> ", OreGlob.VisualizationHint.LABEL);
                    } else {
                        this.visualizer.text("> or ", OreGlob.VisualizationHint.LABEL);
                    }
                    new NodeVisualizer(this.visualizer, this.indents + 1).visit(node);
                }
                return;
            }
            case AND: {
                if (not) {
                    this.visualizer.text("anything that ", OreGlob.VisualizationHint.NODE);
                    this.visualizer.text("isn't", OreGlob.VisualizationHint.NEGATION);
                    this.visualizer.text("...", OreGlob.VisualizationHint.NODE);
                } else {
                    this.visualizer.text("anything that is...", OreGlob.VisualizationHint.NODE);
                }
                for (int i = 0; i < nodes.size(); ++i) {
                    OreGlobNode node = nodes.get(i);
                    this.visualizer.newLine(this.indents);
                    if (i == 0) {
                        this.visualizer.text("> ", OreGlob.VisualizationHint.LABEL);
                    } else {
                        this.visualizer.text("> and ", OreGlob.VisualizationHint.LABEL);
                    }
                    new NodeVisualizer(this.visualizer, this.indents + 1).visit(node);
                }
                return;
            }
            case XOR: {
                if (not) {
                    this.visualizer.text("either both or none of...", OreGlob.VisualizationHint.NEGATION);
                } else {
                    this.visualizer.text("only one of...", OreGlob.VisualizationHint.NODE);
                }
                for (int i = 0; i < nodes.size() - 1; ++i) {
                    this.visualizer.newLine(this.indents + i);
                    this.visualizer.text("> ", OreGlob.VisualizationHint.LABEL);
                    new NodeVisualizer(this.visualizer, this.indents + i + 1).visit(nodes.get(i));
                    this.visualizer.newLine(this.indents + i);
                    this.visualizer.text("> ", OreGlob.VisualizationHint.LABEL);
                    if (i == nodes.size() - 2) {
                        new NodeVisualizer(this.visualizer, this.indents + i + 1).visit(nodes.get(nodes.size() - 1));
                        continue;
                    }
                    this.visualizer.text("only one of...", OreGlob.VisualizationHint.NODE);
                }
                return;
            }
        }
        throw new IllegalStateException("Unknown BranchType '" + (Object)((Object)type) + "'");
    }

    @Override
    public void everything() {
        NodeVisualizer.everything(this.visualizer);
    }

    @Override
    public void nothing() {
        NodeVisualizer.impossible(this.visualizer);
    }

    @Override
    public void nonempty() {
        NodeVisualizer.nonempty(this.visualizer);
    }

    @Override
    public void empty() {
        NodeVisualizer.empty(this.visualizer);
    }

    @Override
    public void error() {
        NodeVisualizer.error(this.visualizer);
    }

    public static void everything(OreGlob.Visualizer visualizer) {
        visualizer.text("anything", OreGlob.VisualizationHint.NODE);
    }

    public static void impossible(OreGlob.Visualizer visualizer) {
        visualizer.text("(impossible to match)", OreGlob.VisualizationHint.NEGATION);
    }

    public static void nonempty(OreGlob.Visualizer visualizer) {
        visualizer.text("something", OreGlob.VisualizationHint.NODE);
    }

    public static void empty(OreGlob.Visualizer visualizer) {
        visualizer.text("nothing", OreGlob.VisualizationHint.NEGATION);
    }

    public static void error(OreGlob.Visualizer visualizer) {
        visualizer.text("ERROR!", OreGlob.VisualizationHint.ERROR);
    }
}

