/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.impl;

import gregtech.api.util.oreglob.OreGlobCompileResult;
import gregtech.common.covers.filter.oreglob.impl.ImpossibleOreGlob;
import gregtech.common.covers.filter.oreglob.impl.NodeOreGlob;
import gregtech.common.covers.filter.oreglob.node.MatchNode;
import gregtech.common.covers.filter.oreglob.node.OreGlobNode;
import gregtech.common.covers.filter.oreglob.node.OreGlobNodes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class OreGlobParser {
    private static final int CHAR_EOF = -1;
    private final String input;
    private final List<OreGlobCompileResult.Report> reports = new ArrayList<OreGlobCompileResult.Report>();
    private boolean error;
    private boolean caseSensitive;
    private int inputIndex;
    private TokenType tokenType;
    private int tokenStart;
    private int tokenLength;
    @Nullable
    private String tokenLiteralValue;

    public OreGlobParser(String input) {
        this.input = input;
    }

    private int readNextChar() {
        if (this.input.length() <= this.inputIndex) {
            return -1;
        }
        int i = this.inputIndex;
        this.inputIndex += Character.isSurrogate(this.input.charAt(i)) ? 2 : 1;
        return this.input.codePointAt(i);
    }

    private void advance() {
        int start;
        boolean first = this.inputIndex == 0;
        block13: while (true) {
            start = this.inputIndex;
            switch (this.readNextChar()) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block13;
                }
                case 40: {
                    this.setCurrentToken(TokenType.LPAR, start, 1);
                    return;
                }
                case 41: {
                    this.setCurrentToken(TokenType.RPAR, start, 1);
                    return;
                }
                case 124: {
                    this.setCurrentToken(TokenType.OR, start, 1);
                    return;
                }
                case 38: {
                    this.setCurrentToken(TokenType.AND, start, 1);
                    return;
                }
                case 33: {
                    this.setCurrentToken(TokenType.NOT, start, 1);
                    return;
                }
                case 94: {
                    this.setCurrentToken(TokenType.XOR, start, 1);
                    return;
                }
                case 42: {
                    this.setCurrentToken(TokenType.ANY, start, 1);
                    return;
                }
                case 63: {
                    this.setCurrentToken(TokenType.ANY_CHAR, start, 1);
                    return;
                }
                case 36: {
                    if (!first) {
                        this.error("Compilation flags in the middle of expression", start, 1);
                    }
                    this.gatherFlags(first);
                    first = false;
                    continue block13;
                }
                case -1: {
                    this.setCurrentToken(TokenType.EOF, this.input.length(), 0);
                    return;
                }
            }
            break;
        }
        this.inputIndex = start;
        String literalValue = this.gatherLiteralValue();
        this.setCurrentToken(TokenType.LITERAL, start, this.inputIndex - start, literalValue);
    }

    private void setCurrentToken(TokenType type, int start, int len) {
        this.setCurrentToken(type, start, len, null);
    }

    private void setCurrentToken(TokenType type, int start, int len, @Nullable String literalValue) {
        this.tokenType = type;
        this.tokenStart = start;
        this.tokenLength = len;
        this.tokenLiteralValue = literalValue;
    }

    private String getTokenSection() {
        return this.tokenType == TokenType.EOF ? "** End of line **" : this.input.substring(this.tokenStart, this.tokenStart + this.tokenLength);
    }

    private String gatherLiteralValue() {
        StringBuilder stb = new StringBuilder();
        while (true) {
            int i = this.inputIndex;
            int c = this.readNextChar();
            switch (c) {
                case 92: {
                    c = this.readNextChar();
                    if (c != -1) break;
                    this.error("End of file after escape character ('\\')", i, 1);
                    return stb.toString();
                }
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 33: 
                case 36: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 63: 
                case 94: 
                case 124: {
                    this.inputIndex = i;
                    return stb.toString();
                }
            }
            if (c > 65535) {
                this.error("Characters above 0xFFFF can't be used", i, 1);
                c = 63;
            }
            stb.appendCodePoint(c);
        }
    }

    private void gatherFlags(boolean add) {
        int i;
        boolean flagsAdded = false;
        block4: while (true) {
            i = this.inputIndex;
            int c = this.readNextChar();
            switch (c) {
                case 92: {
                    c = this.readNextChar();
                    if (c == -1) {
                        this.error("End of file after escape character ('\\')", i, 1);
                        break block4;
                    }
                    if (add) {
                        this.addFlag(c, i);
                        flagsAdded = true;
                        continue block4;
                    }
                }
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break block4;
                }
                default: {
                    if (!add) continue block4;
                    this.addFlag(c, i);
                    flagsAdded = true;
                    continue block4;
                }
            }
            break;
        }
        if (!flagsAdded && add) {
            this.error("No compilation flags given", i, 1);
        }
    }

    private void addFlag(int flag, int index) {
        switch (flag) {
            case 67: 
            case 99: {
                if (this.caseSensitive) {
                    this.warn("Compilation flag 'c' written twice", index, 1);
                    break;
                }
                this.caseSensitive = true;
                break;
            }
            default: {
                this.warn(new StringBuilder("Unknown compilation flag '").appendCodePoint(flag).append('\'').toString(), index, 1);
            }
        }
    }

    private boolean advanceIf(TokenType type) {
        if (this.tokenType != type) {
            return false;
        }
        this.advance();
        return true;
    }

    public OreGlobCompileResult compile() {
        this.advance();
        if (this.tokenType != TokenType.EOF) {
            OreGlobNode expr = this.or();
            if (this.tokenType != TokenType.EOF) {
                this.error("Unexpected token " + this.getTokenSection() + " after end of expression");
            }
            if (!this.error) {
                return new OreGlobCompileResult(new NodeOreGlob(expr), this.reports);
            }
        }
        return new OreGlobCompileResult(ImpossibleOreGlob.getInstance(), this.reports);
    }

    private OreGlobNode or() {
        OreGlobNode expr = this.and();
        if (!this.advanceIf(TokenType.OR)) {
            return expr;
        }
        ArrayList<OreGlobNode> nodes = new ArrayList<OreGlobNode>();
        nodes.add(expr);
        while (true) {
            if (this.advanceIf(TokenType.OR)) {
                continue;
            }
            nodes.add(this.and());
            if (!this.advanceIf(TokenType.OR)) break;
        }
        return OreGlobNodes.or(nodes);
    }

    private OreGlobNode and() {
        OreGlobNode expr = this.xor();
        if (!this.advanceIf(TokenType.AND)) {
            return expr;
        }
        ArrayList<OreGlobNode> nodes = new ArrayList<OreGlobNode>();
        nodes.add(expr);
        while (true) {
            if (this.advanceIf(TokenType.AND)) {
                continue;
            }
            nodes.add(this.xor());
            if (!this.advanceIf(TokenType.AND)) break;
        }
        return OreGlobNodes.and(nodes);
    }

    private OreGlobNode xor() {
        OreGlobNode expr = this.not();
        if (!this.advanceIf(TokenType.XOR)) {
            return expr;
        }
        ArrayList<OreGlobNode> nodes = new ArrayList<OreGlobNode>();
        nodes.add(expr);
        do {
            nodes.add(this.not());
        } while (this.advanceIf(TokenType.XOR));
        return OreGlobNodes.xor(nodes);
    }

    private OreGlobNode not() {
        return this.not(false);
    }

    private OreGlobNode not(boolean insideNegation) {
        OreGlobNode root;
        boolean not = false;
        while (this.advanceIf(TokenType.NOT)) {
            not = !not;
        }
        if (not && this.advanceIf(TokenType.LPAR)) {
            not = false;
            if (this.advanceIf(TokenType.RPAR)) {
                root = OreGlobNodes.not(OreGlobNodes.empty());
            } else {
                root = OreGlobNodes.not(this.or());
                switch (this.tokenType) {
                    case RPAR: {
                        this.advance();
                    }
                    case EOF: {
                        break;
                    }
                    default: {
                        this.error("Unexpected token " + this.getTokenSection() + " after end of expression");
                        break;
                    }
                }
            }
        } else {
            if (not && insideNegation) {
                this.warn("Nested negations can be unintuitive. Consider using groups ( () ) to eliminate ambiguity.");
            }
            root = this.primary();
        }
        switch (this.tokenType) {
            case NOT: 
            case LITERAL: 
            case LPAR: 
            case ANY: 
            case ANY_CHAR: {
                int tokenStart = this.tokenStart;
                OreGlobNode node = this.not(insideNegation || not);
                if (root instanceof MatchNode && root.isNegated() && node instanceof MatchNode && node.isNegated()) {
                    this.warn("Consecutive negations can be unintuitive. Please check if the evaluation result is desirable.", tokenStart, this.tokenStart + this.tokenLength - tokenStart);
                }
                root = OreGlobNodes.append(root, node);
            }
        }
        return not ? OreGlobNodes.not(root) : root;
    }

    private OreGlobNode primary() {
        switch (this.tokenType) {
            case LITERAL: {
                if (this.tokenLiteralValue != null) {
                    OreGlobNode result = OreGlobNodes.match(this.tokenLiteralValue, !this.caseSensitive);
                    this.advance();
                    return result;
                }
                this.error("Literal token without value");
                this.advance();
                return OreGlobNodes.error();
            }
            case LPAR: {
                this.advance();
                switch (this.tokenType) {
                    case RPAR: {
                        this.advance();
                    }
                    case EOF: {
                        return OreGlobNodes.empty();
                    }
                }
                OreGlobNode result = this.or();
                this.advanceIf(TokenType.RPAR);
                return result;
            }
            case ANY: {
                return this.nOrMore(0, true);
            }
            case ANY_CHAR: {
                return this.nOrMore(1, false);
            }
            case EOF: {
                this.error("Unexpected end of expression");
                return OreGlobNodes.error();
            }
        }
        this.error("Unexpected token '" + this.getTokenSection() + "'");
        this.advance();
        return OreGlobNodes.error();
    }

    private OreGlobNode nOrMore(int n, boolean more) {
        block4: while (true) {
            this.advance();
            switch (this.tokenType) {
                case ANY_CHAR: {
                    ++n;
                    continue block4;
                }
                case ANY: {
                    more = true;
                    continue block4;
                }
            }
            break;
        }
        return OreGlobNodes.chars(n, more);
    }

    private void error(String message) {
        this.error(message, this.tokenStart, this.tokenLength);
    }

    private void error(String message, int start, int len) {
        this.error = true;
        this.reports.add(new OreGlobCompileResult.Report(message, true, start, len));
    }

    private void warn(String message) {
        this.warn(message, this.tokenStart, this.tokenLength);
    }

    private void warn(String message, int start, int len) {
        this.reports.add(new OreGlobCompileResult.Report(message, false, start, len));
    }

    static enum TokenType {
        LITERAL,
        LPAR,
        RPAR,
        OR,
        AND,
        NOT,
        XOR,
        ANY,
        ANY_CHAR,
        EOF;

    }
}

