/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.node;

import gregtech.common.covers.filter.oreglob.node.MatchDescription;
import gregtech.common.covers.filter.oreglob.node.NodeVisitor;
import gregtech.common.covers.filter.oreglob.node.OreGlobNode;
import java.util.List;
import javax.annotation.Nonnull;

public class BranchNode
extends OreGlobNode {
    final BranchType type;
    final List<OreGlobNode> expressions;

    BranchNode(BranchType type, List<OreGlobNode> expressions) {
        this.type = type;
        this.expressions = expressions;
    }

    @Override
    protected void visitInternal(NodeVisitor visitor) {
        if (this.expressions.size() == 1) {
            visitor.group(this.expressions.get(0), this.isNegated());
        } else {
            visitor.branch(this.type, this.expressions, this.isNegated());
        }
    }

    @Override
    protected MatchDescription getIndividualNodeMatchDescription() {
        switch (this.expressions.size()) {
            case 0: {
                return this.type == BranchType.AND ? MatchDescription.EVERYTHING : MatchDescription.NOTHING;
            }
            case 1: {
                return this.expressions.get(0).getIndividualNodeMatchDescription();
            }
        }
        switch (this.type) {
            case OR: {
                MatchDescription union = MatchDescription.NOTHING;
                for (OreGlobNode node : this.expressions) {
                    MatchDescription desc = node.getMatchDescription();
                    if (desc == MatchDescription.NOTHING || (union = union.or(desc)) != MatchDescription.EVERYTHING) continue;
                    return MatchDescription.EVERYTHING;
                }
                return union;
            }
            case AND: {
                MatchDescription intersection = MatchDescription.EVERYTHING;
                for (OreGlobNode node : this.expressions) {
                    MatchDescription desc = node.getMatchDescription();
                    if (desc == MatchDescription.EVERYTHING || (intersection = intersection.and(desc)) != MatchDescription.EMPTY) continue;
                    return MatchDescription.EMPTY;
                }
                return intersection;
            }
            case XOR: {
                MatchDescription disjunction = MatchDescription.NOTHING;
                for (OreGlobNode node : this.expressions) {
                    MatchDescription desc = node.getMatchDescription();
                    disjunction = disjunction.xor(desc);
                }
                return disjunction;
            }
        }
        throw new IllegalStateException("Unreachable");
    }

    @Override
    public boolean isPropertyEqualTo(@Nonnull OreGlobNode node) {
        if (!(node instanceof BranchNode)) {
            return false;
        }
        BranchNode br = (BranchNode)node;
        if (this.type != br.type) {
            return false;
        }
        if (this.expressions.size() != br.expressions.size()) {
            return false;
        }
        boolean[] matchFlag = new boolean[this.expressions.size()];
        for (OreGlobNode node1 : this.expressions) {
            boolean matched = false;
            for (int i2 = 0; i2 < br.expressions.size(); ++i2) {
                if (matchFlag[i2] || !node1.isStructurallyEqualTo(br.expressions.get(i2))) continue;
                matchFlag[i2] = true;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public static enum BranchType {
        OR,
        AND,
        XOR;

    }
}

