/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.node;

public enum MatchDescription {
    EVERYTHING,
    NOTHING,
    NONEMPTY,
    EMPTY,
    OTHER_EXCLUDING_EMPTY,
    OTHER_INCLUDING_EMPTY;


    public boolean canMatchNonEmpty() {
        return this == EVERYTHING || this == NONEMPTY || this == OTHER_EXCLUDING_EMPTY || this == OTHER_INCLUDING_EMPTY;
    }

    public boolean canMatchNothing() {
        return this == EVERYTHING || this == EMPTY || this == OTHER_INCLUDING_EMPTY;
    }

    public boolean isComplete() {
        return !this.isIncomplete();
    }

    public boolean isIncomplete() {
        return this == OTHER_EXCLUDING_EMPTY || this == OTHER_INCLUDING_EMPTY;
    }

    public boolean covers(MatchDescription desc) {
        switch (this) {
            case EVERYTHING: {
                return true;
            }
            case NOTHING: 
            case OTHER_EXCLUDING_EMPTY: {
                return desc == NOTHING;
            }
            case NONEMPTY: {
                return !desc.canMatchNothing();
            }
            case EMPTY: 
            case OTHER_INCLUDING_EMPTY: {
                return !desc.canMatchNonEmpty();
            }
        }
        throw new IllegalStateException("Unreachable");
    }

    public MatchDescription append(MatchDescription another) {
        if (another == NOTHING) {
            return NOTHING;
        }
        switch (this) {
            case EVERYTHING: {
                switch (another) {
                    case NONEMPTY: {
                        return NONEMPTY;
                    }
                    case OTHER_EXCLUDING_EMPTY: {
                        return OTHER_EXCLUDING_EMPTY;
                    }
                    case OTHER_INCLUDING_EMPTY: {
                        return OTHER_INCLUDING_EMPTY;
                    }
                }
                return EVERYTHING;
            }
            case NOTHING: {
                return NOTHING;
            }
            case NONEMPTY: {
                switch (another) {
                    case OTHER_EXCLUDING_EMPTY: 
                    case NONEMPTY: 
                    case OTHER_INCLUDING_EMPTY: {
                        return OTHER_EXCLUDING_EMPTY;
                    }
                }
                return NONEMPTY;
            }
            case EMPTY: {
                return another;
            }
            case OTHER_EXCLUDING_EMPTY: {
                return OTHER_EXCLUDING_EMPTY;
            }
            case OTHER_INCLUDING_EMPTY: {
                return another.canMatchNothing() ? OTHER_INCLUDING_EMPTY : OTHER_EXCLUDING_EMPTY;
            }
        }
        throw new IllegalStateException("Unreachable");
    }

    public MatchDescription or(MatchDescription desc) {
        if (desc == NOTHING) {
            return this;
        }
        if (desc == EVERYTHING) {
            return EVERYTHING;
        }
        switch (this) {
            case EVERYTHING: {
                return EVERYTHING;
            }
            case NOTHING: {
                return desc;
            }
            case NONEMPTY: {
                return desc.canMatchNothing() ? EVERYTHING : NONEMPTY;
            }
            case EMPTY: {
                switch (desc) {
                    case NONEMPTY: {
                        return EVERYTHING;
                    }
                    case OTHER_EXCLUDING_EMPTY: {
                        return OTHER_INCLUDING_EMPTY;
                    }
                }
                return desc;
            }
            case OTHER_EXCLUDING_EMPTY: {
                switch (desc) {
                    case NONEMPTY: {
                        return NONEMPTY;
                    }
                    case OTHER_EXCLUDING_EMPTY: {
                        return OTHER_EXCLUDING_EMPTY;
                    }
                }
                return OTHER_INCLUDING_EMPTY;
            }
            case OTHER_INCLUDING_EMPTY: {
                if (desc == NONEMPTY) {
                    return EVERYTHING;
                }
                return OTHER_INCLUDING_EMPTY;
            }
        }
        throw new IllegalStateException("Unreachable");
    }

    public MatchDescription and(MatchDescription desc) {
        if (desc == NOTHING) {
            return NOTHING;
        }
        if (desc == EVERYTHING) {
            return this;
        }
        if (this == desc) {
            return this;
        }
        switch (this) {
            case EVERYTHING: {
                return desc;
            }
            case NOTHING: {
                return NOTHING;
            }
            case OTHER_EXCLUDING_EMPTY: 
            case NONEMPTY: {
                if (desc == EMPTY) {
                    return NOTHING;
                }
                return OTHER_EXCLUDING_EMPTY;
            }
            case EMPTY: {
                return desc.canMatchNothing() ? EMPTY : NOTHING;
            }
            case OTHER_INCLUDING_EMPTY: {
                if (desc == EMPTY) {
                    return EMPTY;
                }
                return OTHER_EXCLUDING_EMPTY;
            }
        }
        throw new IllegalStateException("Unreachable");
    }

    public MatchDescription xor(MatchDescription desc) {
        if (this == desc) {
            return this.isComplete() ? NOTHING : OTHER_EXCLUDING_EMPTY;
        }
        if (this == NOTHING) {
            return desc;
        }
        if (desc == NOTHING) {
            return this;
        }
        if (this == EVERYTHING) {
            return desc.complement();
        }
        if (desc == EVERYTHING) {
            return this.complement();
        }
        switch (this) {
            case NONEMPTY: {
                if (desc == EMPTY) {
                    return EVERYTHING;
                }
                return desc;
            }
            case EMPTY: {
                switch (desc) {
                    case NONEMPTY: {
                        return EVERYTHING;
                    }
                    case OTHER_EXCLUDING_EMPTY: {
                        return OTHER_INCLUDING_EMPTY;
                    }
                    case OTHER_INCLUDING_EMPTY: {
                        return OTHER_EXCLUDING_EMPTY;
                    }
                }
                throw new IllegalStateException("Unreachable");
            }
            case OTHER_EXCLUDING_EMPTY: {
                if (desc == NONEMPTY) {
                    return OTHER_EXCLUDING_EMPTY;
                }
                return OTHER_INCLUDING_EMPTY;
            }
            case OTHER_INCLUDING_EMPTY: {
                if (desc == EMPTY) {
                    return OTHER_EXCLUDING_EMPTY;
                }
                return OTHER_INCLUDING_EMPTY;
            }
        }
        throw new IllegalStateException("Unreachable");
    }

    public MatchDescription complement() {
        switch (this) {
            case EVERYTHING: {
                return NOTHING;
            }
            case NOTHING: {
                return EVERYTHING;
            }
            case NONEMPTY: {
                return EMPTY;
            }
            case EMPTY: {
                return NONEMPTY;
            }
            case OTHER_EXCLUDING_EMPTY: {
                return OTHER_INCLUDING_EMPTY;
            }
            case OTHER_INCLUDING_EMPTY: {
                return OTHER_EXCLUDING_EMPTY;
            }
        }
        throw new IllegalStateException("Unreachable");
    }
}

