/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.node;

import gregtech.common.covers.filter.oreglob.node.ErrorNode;
import gregtech.common.covers.filter.oreglob.node.MatchDescription;
import gregtech.common.covers.filter.oreglob.node.NodeVisitor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class OreGlobNode {
    @Nullable
    private OreGlobNode next;
    private boolean negated;
    @Nullable
    private MatchDescription descriptionCache;
    @Nullable
    private MatchDescription selfDescriptionCache;

    OreGlobNode() {
    }

    @Nullable
    public final OreGlobNode getNext() {
        return this.next;
    }

    public final boolean hasNext() {
        return this.next != null;
    }

    final void setNext(@Nullable OreGlobNode next) {
        if (this.next != next) {
            this.next = next;
            this.clearMatchDescriptionCache();
        }
    }

    public final boolean isNegated() {
        return this.negated;
    }

    final void setNegated(boolean negated) {
        if (this.negated != negated) {
            this.negated = negated;
            this.clearMatchDescriptionCache();
        }
    }

    @Nullable
    public OreGlobNode visit(NodeVisitor visitor) {
        switch (this.getMatchDescription()) {
            case EVERYTHING: {
                visitor.everything();
                break;
            }
            case NOTHING: {
                visitor.nothing();
                break;
            }
            case NONEMPTY: {
                visitor.nonempty();
                break;
            }
            case EMPTY: {
                visitor.empty();
                break;
            }
            default: {
                this.visitInternal(visitor);
            }
        }
        return this.getNext();
    }

    protected abstract void visitInternal(NodeVisitor var1);

    public boolean isStructurallyEqualTo(@Nonnull OreGlobNode node) {
        if (this == node) {
            return true;
        }
        if (this.isNegated() != node.isNegated()) {
            return false;
        }
        return this.isPropertyEqualTo(node) && OreGlobNode.isStructurallyEqualTo(this.getNext(), node.getNext());
    }

    public final MatchDescription getMatchDescription() {
        if (this.descriptionCache == null) {
            MatchDescription t = this.getSelfMatchDescription();
            if (t != MatchDescription.NOTHING && this.getNext() != null) {
                t = t.append(this.getNext().getMatchDescription());
            }
            this.descriptionCache = t;
            return this.descriptionCache;
        }
        return this.descriptionCache;
    }

    public final MatchDescription getSelfMatchDescription() {
        if (this.selfDescriptionCache == null) {
            MatchDescription t = this.getIndividualNodeMatchDescription();
            if (this.isNegated() && !(this instanceof ErrorNode)) {
                t = t.complement();
            }
            this.selfDescriptionCache = t;
            return this.selfDescriptionCache;
        }
        return this.selfDescriptionCache;
    }

    public final boolean isEverything() {
        return this.getMatchDescription() == MatchDescription.EVERYTHING;
    }

    public final boolean isImpossibleToMatch() {
        return this.getMatchDescription() == MatchDescription.NOTHING;
    }

    public final boolean isSomething() {
        return this.getMatchDescription() == MatchDescription.NONEMPTY;
    }

    public final boolean isNothing() {
        return this.getMatchDescription() == MatchDescription.EMPTY;
    }

    public abstract boolean isPropertyEqualTo(@Nonnull OreGlobNode var1);

    protected abstract MatchDescription getIndividualNodeMatchDescription();

    final void clearMatchDescriptionCache() {
        this.descriptionCache = null;
        this.selfDescriptionCache = null;
    }

    public static boolean isStructurallyEqualTo(@Nullable OreGlobNode node1, @Nullable OreGlobNode node2) {
        if (node1 == node2) {
            return true;
        }
        if (node1 == null) {
            return node2.isNothing();
        }
        if (node2 == null) {
            return node1.isNothing();
        }
        return node1.isStructurallyEqualTo(node2);
    }
}

