/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.crafting;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class GTFluidCraftingIngredient
extends Ingredient {
    private final FluidStack fluidStack;

    GTFluidCraftingIngredient(ItemStack ... stacks) {
        super(stacks);
        IFluidHandlerItem handler = (IFluidHandlerItem)stacks[0].getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (handler == null) {
            throw new IllegalArgumentException("The ItemStack " + stacks[0] + " has no FLUID_HANDLER_ITEM_CAPABILITY!");
        }
        this.fluidStack = handler.drain(Integer.MAX_VALUE, false);
    }

    public boolean apply(@Nullable ItemStack testedStack) {
        FluidStack drained;
        if (testedStack == null || testedStack.func_190926_b()) {
            return false;
        }
        IFluidHandlerItem handler = null;
        if (!testedStack.func_77973_b().hasContainerItem(testedStack)) {
            return false;
        }
        if (testedStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            if (testedStack.func_190916_E() > 1) {
                testedStack = testedStack.func_77946_l();
                testedStack.func_190920_e(1);
            }
            handler = (IFluidHandlerItem)testedStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        }
        if (handler != null && (drained = handler.drain(this.fluidStack, false)) != null && drained.amount >= this.fluidStack.amount) {
            return drained.isFluidEqual(this.fluidStack);
        }
        return false;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }
}

