/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.crafting;

import com.google.gson.JsonElement;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTStringUtils;
import gregtech.common.crafting.GTFluidCraftingIngredient;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class GTShapelessOreRecipe
extends ShapelessOreRecipe {
    boolean isClearing;
    public static Constructor<IngredientNBT> ingredientNBT = ReflectionHelper.findConstructor(IngredientNBT.class, (Class[])new Class[]{ItemStack.class});

    public GTShapelessOreRecipe(boolean isClearing, ResourceLocation group, @Nonnull ItemStack result, Object ... recipe) {
        super(group, result, new Object[0]);
        this.isClearing = isClearing;
        for (Object in : recipe) {
            Ingredient ing = GTShapelessOreRecipe.getIngredient(isClearing, in);
            if (ing == null) {
                StringBuilder ret = new StringBuilder("Invalid shapeless ore recipe: ");
                for (Object tmp : recipe) {
                    ret.append(tmp).append(", ");
                }
                ret.append(this.output);
                throw new RuntimeException(ret.toString());
            }
            this.input.add((Object)ing);
            this.isSimple = this.isSimple && ing.isSimple();
        }
    }

    private static Ingredient getIngredient(boolean isClearing, Object obj) {
        if (obj instanceof Ingredient) {
            return (Ingredient)obj;
        }
        if (obj instanceof ItemStack) {
            IFluidHandlerItem handler;
            ItemStack ing = (ItemStack)obj;
            if (ing.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (handler = (IFluidHandlerItem)ing.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
                FluidStack drained = handler.drain(Integer.MAX_VALUE, false);
                if (drained != null && drained.amount > 0) {
                    return new GTFluidCraftingIngredient(((ItemStack)obj).func_77946_l());
                }
                if (!isClearing) {
                    ItemStack i = ((ItemStack)obj).func_77946_l();
                    try {
                        return (Ingredient)ingredientNBT.newInstance(i);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        GTLog.logger.error("Failure to instantiate an IngredientNBT of item {}", (Object)GTStringUtils.prettyPrintItemStack(i));
                    }
                }
            }
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemStack)obj).func_77946_l()});
        }
        if (obj instanceof Item) {
            return Ingredient.func_193367_a((Item)((Item)obj));
        }
        if (obj instanceof Block) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)obj, 1, Short.MAX_VALUE)});
        }
        if (obj instanceof String) {
            return new OreIngredient((String)obj);
        }
        if (obj instanceof JsonElement) {
            throw new IllegalArgumentException("JsonObjects must use getIngredient(JsonObject, JsonContext)");
        }
        return null;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inv) {
        if (this.isClearing) {
            return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        }
        return super.func_179532_b(inv);
    }
}

