/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.entities;

import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.wood.BlockGregPlanks;
import gregtech.common.items.MetaItems;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class GTBoatEntity
extends EntityBoat {
    private static final DataParameter<Integer> GT_BOAT_TYPE = EntityDataManager.func_187226_a(GTBoatEntity.class, (DataSerializer)DataSerializers.field_187192_b);

    public GTBoatEntity(World world) {
        super(world);
    }

    public GTBoatEntity(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GT_BOAT_TYPE, (Object)0);
    }

    protected void dropBoatItems(boolean destroyed) {
        switch (this.getGTBoatType()) {
            case RUBBER_WOOD_BOAT: {
                if (destroyed) {
                    this.func_70099_a(MetaBlocks.PLANKS.getItemVariant(BlockGregPlanks.BlockType.RUBBER_PLANK, 3), 0.0f);
                    this.func_70099_a(new ItemStack(Items.field_151055_y, 2), 0.0f);
                    break;
                }
                this.func_70099_a(MetaItems.RUBBER_WOOD_BOAT.getStackForm(), 0.0f);
                break;
            }
            case TREATED_WOOD_BOAT: {
                this.func_70099_a(MetaItems.TREATED_WOOD_BOAT.getStackForm(), 0.0f);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.func_70269_c(-this.func_70267_i());
            this.func_70265_b(10);
            this.func_70266_a(this.func_70271_g() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.func_70271_g() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    this.dropBoatItems(false);
                }
                this.func_70106_y();
            }
        }
        return true;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        this.field_184473_aH = this.field_70181_x;
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.field_184469_aF != EntityBoat.Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_180430_e(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                            this.dropBoatItems(true);
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b()).func_185904_a() != Material.field_151586_h && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public ItemStack getPickedResult(RayTraceResult ray) {
        switch (this.getGTBoatType()) {
            case RUBBER_WOOD_BOAT: {
                return MetaItems.RUBBER_WOOD_BOAT.getStackForm();
            }
            case TREATED_WOOD_BOAT: {
                return MetaItems.TREATED_WOOD_BOAT.getStackForm();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public void func_184458_a(EntityBoat.Type type) {
        super.func_184458_a(type);
    }

    @Deprecated
    public EntityBoat.Type func_184453_r() {
        return super.func_184453_r();
    }

    public void setGTBoatType(GTBoatType type) {
        this.field_70180_af.func_187227_b(GT_BOAT_TYPE, (Object)type.ordinal());
    }

    public GTBoatType getGTBoatType() {
        switch ((Integer)this.field_70180_af.func_187225_a(GT_BOAT_TYPE)) {
            case 1: {
                return GTBoatType.TREATED_WOOD_BOAT;
            }
        }
        return GTBoatType.RUBBER_WOOD_BOAT;
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74778_a("GTType", this.getGTBoatType().toString());
    }

    protected void func_70037_a(NBTTagCompound tag) {
        String type = tag.func_74779_i("GTType");
        if (type.equalsIgnoreCase("TREATED_WOOD_BOAT")) {
            this.setGTBoatType(GTBoatType.TREATED_WOOD_BOAT);
        } else {
            this.setGTBoatType(GTBoatType.RUBBER_WOOD_BOAT);
        }
    }

    public static enum GTBoatType {
        RUBBER_WOOD_BOAT,
        TREATED_WOOD_BOAT;

    }
}

