/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.SizedTextureArea;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.client.utils.RenderUtil;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;

public class WidgetScrollBar
extends Widget {
    protected final float min;
    protected final float max;
    protected final float dur;
    protected int xOffset;
    protected boolean draggedOnScrollBar;
    protected TextureArea buttonTexture;
    protected int buttonWidth;
    protected int buttonHeight;
    protected int lineColor;
    protected String title;
    protected int titleColor;
    protected Consumer<Float> onChanged;

    public WidgetScrollBar(int x, int y, int width, float min, float max, float dur, Consumer<Float> onChanged) {
        super(new Position(x, y), new Size(width, 20));
        this.max = max;
        this.min = min;
        this.dur = dur;
        this.xOffset = width / 2;
        this.buttonTexture = GuiTextures.VANILLA_BUTTON.getSubArea(0.0, 0.0, 1.0, 0.5);
        this.buttonWidth = 6;
        this.buttonHeight = 8;
        this.lineColor = -16777216;
        this.title = "";
        this.titleColor = -1;
        this.onChanged = onChanged;
    }

    public WidgetScrollBar setInitValue(float value) {
        if (value >= this.min && value <= this.max) {
            this.xOffset = (int)((value - this.min) / (this.max - this.min) * (float)this.getSize().width);
        }
        return this;
    }

    public WidgetScrollBar setButtonTexture(TextureArea buttonTexture, int buttonWidth, int buttonHeight) {
        this.buttonTexture = buttonTexture;
        this.buttonWidth = buttonWidth;
        this.buttonHeight = buttonHeight;
        return this;
    }

    public WidgetScrollBar setLineColor(int lineColor) {
        this.lineColor = lineColor;
        return this;
    }

    public WidgetScrollBar setTitle(String title, int titleColor) {
        this.title = title;
        this.titleColor = titleColor;
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        Position position = this.getPosition();
        Size size = this.getSize();
        RenderUtil.renderRect(position.x, (float)(position.y + 15) - 0.5f, size.width, 1.0f, 0.0f, this.lineColor);
        if (this.buttonTexture instanceof SizedTextureArea) {
            ((SizedTextureArea)this.buttonTexture).drawHorizontalCutSubArea(position.x + this.xOffset - this.buttonWidth / 2, position.y + 15 - this.buttonHeight / 2, this.buttonWidth, this.buttonHeight, 0.0, 1.0);
        } else {
            this.buttonTexture.drawSubArea((float)(position.x + this.xOffset) - (float)this.buttonWidth * 0.5f, (float)(position.y + 15) - (float)this.buttonHeight * 0.5f, this.buttonWidth, this.buttonHeight, 0.0, 0.0, 1.0, 1.0);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String text = I18n.func_135052_a((String)this.title, (Object[])new Object[0]);
        text = text + ": " + new DecimalFormat("#.00").format(this.getValue());
        fontRenderer.func_78276_b(text, position.x + size.width / 2 - fontRenderer.func_78256_a(text) / 2, position.y - 3 + size.height / 2 - fontRenderer.field_78288_b / 2, this.titleColor);
    }

    private boolean isOnScrollPane(int mouseX, int mouseY) {
        Position position = this.getPosition();
        Size size = this.getSize();
        return WidgetScrollBar.isMouseOver(position.x - this.buttonWidth / 2, position.y + 15 - this.buttonHeight / 2, size.width + this.buttonWidth / 2, this.buttonHeight, mouseX, mouseY);
    }

    private float getValue() {
        return (float)((double)this.min + Math.floor((this.max - this.min) * (float)this.xOffset * 1.0f / (float)this.getSize().width / this.dur) * (double)this.dur);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isOnScrollPane(mouseX, mouseY)) {
            this.xOffset = mouseX - this.getPosition().x;
            this.draggedOnScrollBar = true;
        }
        return this.isMouseOverElement(mouseX, mouseY);
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        if (this.draggedOnScrollBar) {
            Position position = this.getPosition();
            Size size = this.getSize();
            this.xOffset = mouseX > position.x + size.width ? size.width : (mouseX < position.x ? 0 : mouseX - this.getPosition().x);
            if (this.onChanged != null) {
                this.onChanged.accept(Float.valueOf(this.getValue()));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.draggedOnScrollBar) {
            this.writeClientAction(2, packetBuffer -> packetBuffer.writeFloat(this.getValue()));
        }
        this.draggedOnScrollBar = false;
        return this.isMouseOverElement(mouseX, mouseY);
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 2) {
            float value = buffer.readFloat();
            if (this.onChanged != null) {
                this.onChanged.accept(Float.valueOf(value));
            }
        }
    }
}

