/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.craftingstation;

import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.ScrollableListWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.common.gui.widget.craftingstation.ItemListSlotWidget;
import gregtech.common.inventory.IItemInfo;
import gregtech.common.inventory.IItemList;
import gregtech.common.inventory.SimpleItemInfo;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class ItemListGridWidget
extends ScrollableListWidget {
    @Nullable
    private final IItemList itemList;
    private final int slotAmountX;
    private final int slotAmountY;
    private int slotRowsAmount = 0;
    private final Map<ItemStack, SimpleItemInfo> cachedItemList = new Object2ObjectOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
    private final List<SimpleItemInfo> itemsChanged = new ArrayList<SimpleItemInfo>();
    private final List<ItemStack> itemsRemoved = new ArrayList<ItemStack>();
    private final Comparator<IItemInfo> comparator = Comparator.comparing(IItemInfo::getItemStack, GTUtility.createItemStackComparator());
    private final List<SimpleItemInfo> displayItemList = new ArrayList<SimpleItemInfo>();

    public ItemListGridWidget(int x, int y, int slotsX, int slotsY, @Nullable IItemList itemList) {
        super(x, y, slotsX * 18 + 10, slotsY * 18);
        this.itemList = itemList;
        this.slotAmountX = slotsX;
        this.slotAmountY = slotsY;
    }

    @Nullable
    public IItemList getItemList() {
        return this.itemList;
    }

    @Nullable
    public IItemInfo getItemInfoAt(int index) {
        return this.displayItemList.size() > index ? (IItemInfo)this.displayItemList.get(index) : null;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        INativeWidget hoveredSlot;
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        if (!result && ItemListGridWidget.isShiftDown() && (hoveredSlot = this.findHoveredSlot(mouseX, mouseY)) != null) {
            this.dispatchOtherSlotShiftClick(hoveredSlot);
            return true;
        }
        return result;
    }

    private void dispatchOtherSlotShiftClick(INativeWidget clickedSlot) {
        ItemStack stackInSlot = clickedSlot.getHandle().func_75211_c();
        if (!stackInSlot.func_190926_b()) {
            this.writeClientAction(4, buf -> buf.func_150787_b(clickedSlot.getHandle().field_75222_d));
        }
    }

    private void handleSlotShiftClick(INativeWidget clickedSlot) {
        ItemStack itemStack = clickedSlot.getHandle().func_75211_c();
        if (clickedSlot.getHandle().func_82869_a(this.gui.entityPlayer) && !itemStack.func_190926_b()) {
            itemStack = clickedSlot.onItemTake(this.gui.entityPlayer, itemStack, true);
            int amountInserted = this.getItemList().insertItem(itemStack, itemStack.func_190916_E(), false, IItemList.InsertMode.LOWEST_PRIORITY);
            if (amountInserted > 0) {
                clickedSlot.onItemTake(this.gui.entityPlayer, itemStack, false);
                itemStack.func_190918_g(amountInserted);
                if (!clickedSlot.canMergeSlot(itemStack)) {
                    this.gui.entityPlayer.func_146097_a(itemStack.func_77946_l(), false, false);
                    itemStack.func_190920_e(0);
                }
                clickedSlot.getHandle().func_75218_e();
                this.uiAccess.sendSlotUpdate(clickedSlot);
                this.gui.entityPlayer.field_71070_bA.func_75142_b();
            }
        }
    }

    private void addSlotRows(int amount) {
        for (int i = 0; i < amount; ++i) {
            int widgetAmount = this.widgets.size();
            WidgetGroup widgetGroup = new WidgetGroup();
            for (int j = 0; j < this.slotAmountX; ++j) {
                ItemListSlotWidget widget = new ItemListSlotWidget(j * 18, 0, this, widgetAmount * this.slotAmountX + j);
                widgetGroup.addWidget(widget);
            }
            this.addWidget(widgetGroup);
        }
    }

    private void removeSlotRows(int amount) {
        for (int i = 0; i < amount; ++i) {
            Widget slotWidget = (Widget)this.widgets.remove(this.widgets.size() - 1);
            this.removeWidget(slotWidget);
        }
    }

    private void modifySlotRows(int delta) {
        if (delta > 0) {
            this.addSlotRows(delta);
        } else {
            this.removeSlotRows(delta);
        }
    }

    private void checkItemListForChanges() {
        Iterator<ItemStack> iterator = this.cachedItemList.keySet().iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = iterator.next();
            if (this.itemList.hasItemStored(itemStack)) continue;
            iterator.remove();
            this.itemsRemoved.add(itemStack);
        }
        for (ItemStack itemStack : this.itemList.getStoredItems()) {
            IItemInfo itemInfo = this.itemList.getItemInfo(itemStack);
            if (itemInfo == null) continue;
            if (!this.cachedItemList.containsKey(itemStack)) {
                SimpleItemInfo lookupInfo = new SimpleItemInfo(itemStack);
                int totalAmount = itemInfo.getTotalItemAmount();
                if (totalAmount == 0) {
                    this.itemsRemoved.add(itemStack);
                    continue;
                }
                lookupInfo.setTotalItemAmount(totalAmount);
                this.cachedItemList.put(itemStack, lookupInfo);
                this.itemsChanged.add(lookupInfo);
                continue;
            }
            SimpleItemInfo cachedItemInfo = this.cachedItemList.get(itemStack);
            if (cachedItemInfo.getTotalItemAmount() == itemInfo.getTotalItemAmount()) continue;
            cachedItemInfo.setTotalItemAmount(itemInfo.getTotalItemAmount());
            this.itemsChanged.add(cachedItemInfo);
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.itemList == null) {
            return;
        }
        int amountOfItemTypes = this.itemList.getStoredItems().size();
        int slotRowsRequired = Math.max(this.slotAmountY, (int)Math.ceil((double)amountOfItemTypes / ((double)this.slotAmountX * 1.0)));
        if (this.slotRowsAmount != slotRowsRequired) {
            int slotsToAdd = slotRowsRequired - this.slotRowsAmount;
            this.slotRowsAmount = slotRowsRequired;
            this.writeUpdateInfo(2, buf -> buf.func_150787_b(slotsToAdd));
            this.modifySlotRows(slotsToAdd);
        }
        this.itemsChanged.clear();
        this.itemsRemoved.clear();
        this.checkItemListForChanges();
        if (!this.itemsChanged.isEmpty() || !this.itemsRemoved.isEmpty()) {
            this.writeUpdateInfo(3, buf -> {
                buf.func_150787_b(this.itemsRemoved.size());
                for (ItemStack stack : this.itemsRemoved) {
                    buf.func_150788_a(stack);
                }
                buf.func_150787_b(this.itemsChanged.size());
                for (SimpleItemInfo itemInfo : this.itemsChanged) {
                    buf.func_150788_a(itemInfo.getItemStack());
                    buf.func_150787_b(itemInfo.getTotalItemAmount());
                }
            });
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 2) {
            int slotsToAdd = buffer.func_150792_a();
            this.modifySlotRows(slotsToAdd);
        }
        if (id == 3) {
            try {
                int itemsRemoved = buffer.func_150792_a();
                for (int i = 0; i < itemsRemoved; ++i) {
                    ItemStack itemStack = buffer.func_150791_c();
                    this.displayItemList.removeIf(it -> ItemStackHashStrategy.comparingAllButCount().equals(it.getItemStack(), itemStack));
                }
                int itemsChanged = buffer.func_150792_a();
                for (int i = 0; i < itemsChanged; ++i) {
                    ItemStack itemStack = buffer.func_150791_c();
                    int newTotalAmount = buffer.func_150792_a();
                    SimpleItemInfo itemInfo = this.displayItemList.stream().filter(it -> ItemStackHashStrategy.comparingAllButCount().equals(it.getItemStack(), itemStack)).findAny().orElse(null);
                    if (itemInfo == null) {
                        itemInfo = new SimpleItemInfo(itemStack);
                        this.displayItemList.add(itemInfo);
                    }
                    itemInfo.setTotalItemAmount(newTotalAmount);
                }
                this.displayItemList.sort(this.comparator);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        INativeWidget clickedSlot;
        super.handleClientAction(id, buffer);
        if (id == 4 && (clickedSlot = this.findSlotByNumber(buffer.func_150792_a())) != null) {
            this.handleSlotShiftClick(clickedSlot);
        }
    }

    @Nullable
    private INativeWidget findHoveredSlot(int mouseX, int mouseY) {
        return this.gui.guiWidgets.values().stream().flatMap(it -> it.getNativeWidgets().stream()).filter(it -> it.getHandle().func_111238_b()).filter(it -> it.getHandle().func_82869_a(this.gui.entityPlayer)).filter(it -> ((Widget)((Object)it)).isMouseOverElement(mouseX, mouseY)).findFirst().orElse(null);
    }

    @Nullable
    private INativeWidget findSlotByNumber(int slotNumber) {
        return this.gui.guiWidgets.values().stream().flatMap(it -> it.getNativeWidgets().stream()).filter(it -> it.getHandle().field_75222_d == slotNumber).findFirst().orElse(null);
    }
}

