/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.monitor;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.ScrollableListWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.api.util.GTLog;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.client.renderer.handler.BlockPosHighlightRenderer;
import gregtech.client.utils.RenderUtil;
import gregtech.common.covers.CoverDigitalInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class WidgetCoverList
extends ScrollableListWidget {
    private static final Pattern PARENTHESIS_PATTERN = Pattern.compile("[,() ]");
    private WidgetGroup selected;
    private final Map<WidgetGroup, CoverDigitalInterface> widgetMap = new HashMap<WidgetGroup, CoverDigitalInterface>();
    public Consumer<CoverDigitalInterface> onSelected;

    public WidgetCoverList(int xPosition, int yPosition, int width, int slotSize, List<CoverDigitalInterface> covers, CoverDigitalInterface bindCover, Consumer<CoverDigitalInterface> onSelected) {
        super(xPosition, yPosition, width, slotSize * 18);
        this.onSelected = onSelected;
        for (CoverDigitalInterface cover : covers) {
            ItemStack itemStack = cover.coverHolder.getStackForm();
            BlockPos pos = cover.coverHolder.getPos();
            if (cover.coverHolder instanceof PipeCoverableImplementation) {
                itemStack = null;
                pos = pos.func_177972_a(cover.attachedSide);
                TileEntity tileEntity = cover.coverHolder.getWorld().func_175625_s(pos);
                IBlockState state = cover.coverHolder.getWorld().func_180495_p(pos);
                if (tileEntity != null) {
                    itemStack = tileEntity.func_145838_q().func_185473_a(cover.coverHolder.getWorld(), pos, state);
                }
                if (itemStack == null) continue;
            }
            ItemStackHandler itemStackHandler = new ItemStackHandler(1);
            itemStackHandler.insertItem(0, itemStack, false);
            WidgetGroup widgetGroup = new WidgetGroup();
            widgetGroup.addWidget(new SlotWidget((IItemHandler)itemStackHandler, 0, 0, 0, false, false));
            widgetGroup.addWidget(new LabelWidget(20, 5, String.format("(%d, %d, %d)", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), -1));
            this.widgetMap.put(widgetGroup, cover);
            if (widgetGroup.getSize().width + 10 > this.getSize().width) {
                this.setSize(new Size(widgetGroup.getSize().width + 10, this.getSize().height));
            }
            this.addWidget(widgetGroup);
            if (cover != bindCover) continue;
            this.selected = widgetGroup;
        }
    }

    @Override
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        if (this.isMouseOverElement(mouseX - this.getPosition().x + this.gui.getGuiLeft(), mouseY)) {
            int direction = -MathHelper.func_76125_a((int)wheelDelta, (int)-2, (int)2);
            int moveDelta = direction * (this.slotHeight / 2);
            this.addScrollOffset(moveDelta);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        Widget widget;
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        if (!result && mouseY >= this.getPosition().y && mouseY <= this.getPosition().y + this.getSize().height && (widget = (Widget)this.widgets.stream().filter(it -> it.isMouseOverElement(mouseX, mouseY)).findFirst().orElse(null)) instanceof WidgetGroup) {
            List<Widget> children = ((WidgetGroup)widget).getContainedWidgets(true);
            if (children.get(0).isMouseOverElement(mouseX, mouseY)) {
                try {
                    String posString = (String)ObfuscationReflectionHelper.getPrivateValue(LabelWidget.class, (Object)((LabelWidget)children.get(1)), (String)"text");
                    String[] posSplit = PARENTHESIS_PATTERN.split(posString);
                    BlockPosHighlightRenderer.renderBlockBoxHighLight(new BlockPos(Integer.parseInt(posSplit[1]), Integer.parseInt(posSplit[3]), Integer.parseInt(posSplit[5])), 5000L);
                    Minecraft.func_71410_x().field_71439_g.func_71053_j();
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(((SlotWidget)children.get(0)).getHandle().func_75211_c().func_82833_r() + ": " + posString));
                    return false;
                }
                catch (Throwable e) {
                    GTLog.logger.error("Could not reflect GregTech WidgetLabel text", e);
                }
            }
            this.selected = widget == this.selected ? null : (WidgetGroup)widget;
            this.writeClientAction(2, buf -> {
                if (this.selected == null) {
                    buf.writeInt(-1);
                } else {
                    buf.writeInt(this.getContainedWidgets(true).indexOf(this.selected));
                }
            });
        }
        return result;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 2) {
            int index = buffer.readInt();
            this.selected = index == -1 ? null : (WidgetGroup)this.getContainedWidgets(true).get(index);
            if (this.onSelected != null) {
                this.onSelected.accept(this.widgetMap.getOrDefault(this.selected, null));
            }
        }
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        int mouseDelta = (mouseY - this.lastMouseY) * 5;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if (this.draggedOnScrollBar) {
            this.addScrollOffset(mouseDelta);
            return true;
        }
        if (this.isPositionInsideScissor(mouseX, mouseY)) {
            return super.mouseDragged(mouseX, mouseY, button, timeDragged);
        }
        return false;
    }

    private void addScrollOffset(int offset) {
        this.scrollOffset = MathHelper.func_76125_a((int)(this.scrollOffset + offset), (int)0, (int)(this.totalListHeight - this.getSize().height));
        this.onPositionUpdate();
    }

    private boolean isPositionInsideScissor(int mouseX, int mouseY) {
        return this.isMouseOverElement(mouseX, mouseY) && !this.isOnScrollPane(mouseX, mouseY);
    }

    private boolean isOnScrollPane(int mouseX, int mouseY) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        return WidgetCoverList.isMouseOver(pos.x + size.width - 10, pos.y, 10, size.height, mouseX, mouseY);
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        RenderUtil.useScissor(this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height, () -> {
            this.widgets.forEach(widget -> {
                if (widget instanceof WidgetGroup) {
                    Widget widget1 = ((WidgetGroup)widget).getContainedWidgets(true).get(0);
                    SlotWidget slotWidget = (SlotWidget)widget1;
                    slotWidget.setActive(widget.getPosition().y >= this.getPosition().y - 9 && widget.getPosition().y <= this.getPosition().y + this.getSize().height - 9);
                }
            });
            if (this.selected != null) {
                Gui.func_73734_a((int)this.selected.getPosition().x, (int)this.selected.getPosition().y, (int)(this.selected.getPosition().x + this.getSize().width - 10), (int)(this.selected.getPosition().y + this.selected.getSize().height), (int)0x4BFFFFFF);
            }
            super.drawInBackground(mouseX, mouseY, partialTicks, context);
        });
    }
}

