/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.armor.ArmorLogicSuite;
import gregtech.api.items.armor.ArmorUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.input.KeyBind;
import gregtech.common.items.MetaItems;
import gregtech.common.items.armor.IStepAssist;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuarkTechSuite
extends ArmorLogicSuite
implements IStepAssist {
    protected static final Map<Potion, Integer> potionRemovalCost = new IdentityHashMap<Potion, Integer>();
    private float charge = 0.0f;
    @SideOnly(value=Side.CLIENT)
    protected ArmorUtils.ModularHUD HUD;

    public QuarkTechSuite(EntityEquipmentSlot slot, int energyPerUse, long capacity, int tier) {
        super(energyPerUse, capacity, tier, slot);
        potionRemovalCost.put(MobEffects.field_76436_u, 10000);
        potionRemovalCost.put(MobEffects.field_82731_v, 25000);
        if (ArmorUtils.SIDE.isClient() && this.shouldDrawHUD()) {
            this.HUD = new ArmorUtils.ModularHUD();
        }
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        byte toggleTimer;
        IElectricItem item = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (item == null) {
            return;
        }
        NBTTagCompound data = GTUtility.getOrCreateNbtCompound(itemStack);
        byte by = toggleTimer = data.func_74764_b("toggleTimer") ? data.func_74771_c("toggleTimer") : (byte)0;
        if (!player.func_184582_a(EntityEquipmentSlot.HEAD).func_77969_a(MetaItems.QUANTUM_HELMET.getStackForm())) {
            QuarkTechSuite.disableNightVision(world, player, false);
        } else if (!(player.func_184582_a(EntityEquipmentSlot.CHEST).func_77969_a(MetaItems.QUANTUM_CHESTPLATE.getStackForm()) || player.func_184582_a(EntityEquipmentSlot.CHEST).func_77969_a(MetaItems.QUANTUM_CHESTPLATE_ADVANCED.getStackForm()) || world.field_72995_K)) {
            player.field_70178_ae = false;
        }
        boolean ret = false;
        if (this.SLOT == EntityEquipmentSlot.HEAD) {
            int air = player.func_70086_ai();
            if (item.canUse(this.energyPerUse / 100) && air < 100) {
                player.func_70050_g(air + 200);
                item.discharge(this.energyPerUse / 100, item.getTier(), true, false, false);
                ret = true;
            }
            if (item.canUse(this.energyPerUse / 10) && player.func_71024_bL().func_75121_c()) {
                int slotId = -1;
                for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    ItemStack current = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                    if (!(current.func_77973_b() instanceof ItemFood)) continue;
                    slotId = i;
                    break;
                }
                if (slotId > -1) {
                    ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(slotId);
                    ActionResult<ItemStack> result = ArmorUtils.canEat(player, stack);
                    if ((stack = (ItemStack)result.func_188398_b()).func_190926_b()) {
                        player.field_71071_by.field_70462_a.set(slotId, (Object)ItemStack.field_190927_a);
                    }
                    if (result.func_188397_a() == EnumActionResult.SUCCESS) {
                        item.discharge(this.energyPerUse / 10, item.getTier(), true, false, false);
                    }
                    ret = true;
                }
            }
            for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
                Potion potion = effect.func_188419_a();
                Integer cost = potionRemovalCost.get(potion);
                if (cost == null || !item.canUse((cost = Integer.valueOf(cost * (effect.func_76458_c() + 1))).intValue())) continue;
                item.discharge(cost.intValue(), item.getTier(), true, false, false);
                player.func_184589_d(potion);
            }
            boolean nightvision = data.func_74767_n("Nightvision");
            if (toggleTimer == 0 && KeyBind.ARMOR_MODE_SWITCH.isKeyDown(player)) {
                toggleTimer = 5;
                if (!nightvision && item.getCharge() >= 4L) {
                    nightvision = true;
                    if (!world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.qts.nightvision.enabled", new Object[0]), true);
                    }
                } else if (nightvision) {
                    nightvision = false;
                    QuarkTechSuite.disableNightVision(world, player, true);
                } else if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.qts.nightvision.error", new Object[0]), true);
                }
                if (!world.field_72995_K) {
                    data.func_74757_a("Nightvision", nightvision);
                }
            }
            if (nightvision && !world.field_72995_K && item.getCharge() >= (long)this.energyPerUse) {
                player.func_184589_d(MobEffects.field_76440_q);
                player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 999999, 0, true, false));
                item.discharge(4L, this.tier, true, false, false);
            }
            if (!world.field_72995_K && toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
                data.func_74774_a("toggleTimer", toggleTimer);
            }
        } else if (this.SLOT == EntityEquipmentSlot.CHEST && !player.field_70178_ae) {
            player.field_70178_ae = true;
            if (player.func_70027_ad()) {
                player.func_70066_B();
            }
        } else if (this.SLOT == EntityEquipmentSlot.LEGS) {
            if (item.canUse(this.energyPerUse / 100) && (player.field_70122_E || player.func_70090_H()) && KeyBind.VANILLA_FORWARD.isKeyDown(player) && player.func_70051_ag()) {
                byte consumerTicks = data.func_74771_c("consumerTicks");
                if ((consumerTicks = (byte)(consumerTicks + 1)) >= 10) {
                    consumerTicks = 0;
                    item.discharge(this.energyPerUse / 100, item.getTier(), true, false, false);
                    ret = true;
                }
                data.func_74774_a("consumerTicks", consumerTicks);
                float speed = 0.25f;
                if (player.func_70090_H()) {
                    speed = 0.1f;
                    if (KeyBind.VANILLA_JUMP.isKeyDown(player)) {
                        player.field_70181_x += 0.1;
                    }
                }
                player.func_191958_b(0.0f, 0.0f, 1.0f, speed);
            } else if (item.canUse(this.energyPerUse / 100) && player.func_70090_H() && KeyBind.VANILLA_SNEAK.isKeyDown(player) || KeyBind.VANILLA_JUMP.isKeyDown(player)) {
                byte consumerTicks = data.func_74771_c("consumerTicks");
                if ((consumerTicks = (byte)(consumerTicks + 1)) >= 10) {
                    consumerTicks = 0;
                    item.discharge(this.energyPerUse / 100, item.getTier(), true, false, false);
                    ret = true;
                }
                data.func_74774_a("consumerTicks", consumerTicks);
                double acceleration = 0.085;
                if (KeyBind.VANILLA_SNEAK.isKeyDown(player)) {
                    player.field_70181_x -= acceleration;
                }
                if (KeyBind.VANILLA_JUMP.isKeyDown(player)) {
                    player.field_70181_x += acceleration;
                }
            }
        } else if (this.SLOT == EntityEquipmentSlot.FEET) {
            if (!world.field_72995_K) {
                boolean onGround;
                boolean bl = onGround = !data.func_74764_b("onGround") || data.func_74767_n("onGround");
                if (onGround && !player.field_70122_E && KeyBind.VANILLA_JUMP.isKeyDown(player)) {
                    item.discharge(this.energyPerUse / 100, item.getTier(), true, false, false);
                    ret = true;
                }
                if (player.field_70122_E != onGround) {
                    data.func_74757_a("onGround", player.field_70122_E);
                }
            } else {
                if (item.canUse(this.energyPerUse / 100) && player.field_70122_E) {
                    this.charge = 1.0f;
                }
                if (player.field_70181_x >= 0.0 && this.charge > 0.0f && !player.func_70090_H()) {
                    if (KeyBind.VANILLA_JUMP.isKeyDown(player)) {
                        if (this.charge == 1.0f) {
                            player.field_70159_w *= 3.6;
                            player.field_70179_y *= 3.6;
                        }
                        player.field_70181_x += (double)(this.charge * 0.32f);
                        this.charge = (float)((double)this.charge * 0.7);
                    } else if (this.charge < 1.0f) {
                        this.charge = 0.0f;
                    }
                }
            }
            this.updateStepHeight(player);
        }
        if (ret) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public static void disableNightVision(@Nonnull World world, EntityPlayer player, boolean sendMsg) {
        if (!world.field_72995_K) {
            player.func_184589_d(MobEffects.field_76439_r);
            if (sendMsg) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.qts.nightvision.disabled", new Object[0]), true);
            }
        }
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, EntityEquipmentSlot equipmentSlot) {
        int damageLimit = Integer.MAX_VALUE;
        IElectricItem item = (IElectricItem)armor.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (item == null) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, damageLimit);
        }
        if (this.energyPerUse > 0) {
            damageLimit = (int)Math.min((double)damageLimit, 25.0 * (double)item.getCharge() / ((double)this.energyPerUse * 100.0));
        }
        if (source == DamageSource.field_76379_h) {
            if (this.SLOT == EntityEquipmentSlot.FEET) {
                return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
            }
            if (this.SLOT == EntityEquipmentSlot.LEGS) {
                return new ISpecialArmor.ArmorProperties(9, 0.8, damageLimit);
            }
        }
        return new ISpecialArmor.ArmorProperties(8, this.getDamageAbsorption() * (double)this.getAbsorption(armor), damageLimit);
    }

    @Override
    public boolean handleUnblockableDamage(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, double damage, EntityEquipmentSlot equipmentSlot) {
        return source != DamageSource.field_76379_h && source != DamageSource.field_76369_e && source != DamageSource.field_76366_f && source != DamageSource.field_76380_i;
    }

    @Override
    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack itemStack, DamageSource source, int damage, EntityEquipmentSlot equipmentSlot) {
        IElectricItem item = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (item == null) {
            return;
        }
        item.discharge((long)this.energyPerUse / 100L * (long)damage, item.getTier(), true, false, false);
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        ItemStack currentChest = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(EntityEquipmentSlot.CHEST.func_188454_b());
        ItemStack advancedChest = MetaItems.QUANTUM_CHESTPLATE_ADVANCED.getStackForm();
        String armorTexture = "quark_tech_suite";
        if (advancedChest.func_77969_a(currentChest)) {
            armorTexture = "advanced_quark_tech_suite";
        }
        return this.SLOT != EntityEquipmentSlot.LEGS ? String.format("gregtech:textures/armor/%s_1.png", armorTexture) : String.format("gregtech:textures/armor/%s_2.png", armorTexture);
    }

    @Override
    public double getDamageAbsorption() {
        return this.SLOT == EntityEquipmentSlot.CHEST ? 1.2 : 1.0;
    }

    @Override
    public float getHeatResistance() {
        return 0.5f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawHUD(ItemStack item) {
        QuarkTechSuite.addCapacityHUD(item, this.HUD);
        this.HUD.draw();
        this.HUD.reset();
    }

    @Override
    public void addInfo(ItemStack itemStack, List<String> lines) {
        super.addInfo(itemStack, lines);
        if (this.SLOT == EntityEquipmentSlot.HEAD) {
            NBTTagCompound nbtData = GTUtility.getOrCreateNbtCompound(itemStack);
            boolean nv = nbtData.func_74767_n("Nightvision");
            if (nv) {
                lines.add(I18n.func_135052_a((String)"metaarmor.message.nightvision.enabled", (Object[])new Object[0]));
            } else {
                lines.add(I18n.func_135052_a((String)"metaarmor.message.nightvision.disabled", (Object[])new Object[0]));
            }
            lines.add(I18n.func_135052_a((String)"metaarmor.tooltip.potions", (Object[])new Object[0]));
            lines.add(I18n.func_135052_a((String)"metaarmor.tooltip.breath", (Object[])new Object[0]));
            lines.add(I18n.func_135052_a((String)"metaarmor.tooltip.autoeat", (Object[])new Object[0]));
        } else if (this.SLOT == EntityEquipmentSlot.CHEST) {
            lines.add(I18n.func_135052_a((String)"metaarmor.tooltip.burning", (Object[])new Object[0]));
        } else if (this.SLOT == EntityEquipmentSlot.LEGS) {
            lines.add(I18n.func_135052_a((String)"metaarmor.tooltip.speed", (Object[])new Object[0]));
        } else if (this.SLOT == EntityEquipmentSlot.FEET) {
            lines.add(I18n.func_135052_a((String)"metaarmor.tooltip.stepassist", (Object[])new Object[0]));
            lines.add(I18n.func_135052_a((String)"metaarmor.tooltip.falldamage", (Object[])new Object[0]));
            lines.add(I18n.func_135052_a((String)"metaarmor.tooltip.jump", (Object[])new Object[0]));
        }
    }
}

