/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.cover.CoverDefinition;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.client.renderer.handler.BlockPosHighlightRenderer;
import gregtech.common.items.behaviors.CoverPlaceBehavior;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityCentralMonitor;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CoverDigitalInterfaceWirelessPlaceBehaviour
extends CoverPlaceBehavior {
    public CoverDigitalInterfaceWirelessPlaceBehaviour(CoverDefinition coverDefinition) {
        super(coverDefinition);
    }

    public static BlockPos getRemotePos(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag != null) {
            return NBTUtil.func_186861_c((NBTTagCompound)tag);
        }
        return null;
    }

    public static int getRemoteDim(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag != null) {
            return tag.func_74762_e("dimension");
        }
        return 0;
    }

    @Override
    public void onUpdate(ItemStack itemStack, Entity entity) {
        ItemStack held;
        if (entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer && (held = ((EntityPlayer)entity).func_184614_ca()) == itemStack) {
            BlockPos pos = CoverDigitalInterfaceWirelessPlaceBehaviour.getRemotePos(itemStack);
            int dim = CoverDigitalInterfaceWirelessPlaceBehaviour.getRemoteDim(itemStack);
            if (pos != null && entity.field_70170_p.field_73011_w.getDimension() == dim) {
                BlockPosHighlightRenderer.renderBlockBoxHighLight(pos, 1500L);
            }
        }
    }

    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof MetaTileEntityCentralMonitor) {
            ItemStack itemStack = player.func_184586_b(hand);
            itemStack.func_77982_d(NBTUtil.func_186859_a((BlockPos)pos));
            NBTTagCompound tag = itemStack.func_77978_p();
            if (tag != null && !tag.func_74764_b("dimension")) {
                tag.func_74768_a("dimension", world.field_73011_w.getDimension());
            }
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            player.func_184586_b(hand).func_77982_d(null);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        BlockPos pos = CoverDigitalInterfaceWirelessPlaceBehaviour.getRemotePos(itemStack);
        String binding = pos == null ? "---" : String.format("%d, %d, %d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        lines.add(I18n.func_135052_a((String)"metaitem.cover.digital.wireless.tooltip.1", (Object[])new Object[0]));
        lines.add(I18n.func_135052_a((String)"metaitem.cover.digital.wireless.tooltip.2", (Object[])new Object[0]));
        lines.add(I18n.func_135052_a((String)"metaitem.cover.digital.wireless.tooltip.3", (Object[])new Object[0]));
        lines.add(I18n.func_135052_a((String)"metaitem.cover.digital.wireless.tooltip.4", (Object[])new Object[]{binding}));
    }
}

