/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.util.GTTransferUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemMagnetBehavior
implements IItemBehaviour {
    private final int range;
    private final float speed;

    public ItemMagnetBehavior(int range, float speed) {
        this.range = range;
        this.speed = speed;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World world, @Nonnull EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && player.func_70093_af()) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation(ItemMagnetBehavior.toggleActive(player.func_184586_b(hand)) ? "behavior.item_magnet.enabled" : "behavior.item_magnet.disabled", new Object[0]), true);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    private static boolean isActive(ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return false;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return false;
        }
        if (tag.func_74764_b("IsActive")) {
            return tag.func_74767_n("IsActive");
        }
        return false;
    }

    private static boolean toggleActive(ItemStack stack) {
        boolean isActive = ItemMagnetBehavior.isActive(stack);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("IsActive", !isActive);
        return !isActive;
    }

    @Override
    public void onUpdate(ItemStack itemStack, Entity entity) {
        if (!ItemMagnetBehavior.isActive(itemStack) || !(entity instanceof EntityPlayer) || entity.func_130014_f_().field_72995_K) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)entity;
        if (entityPlayer.func_175149_v()) {
            return;
        }
        List itemsInRange = entityPlayer.func_130014_f_().func_72872_a(EntityItem.class, this.getAreaBoundingBox(entityPlayer));
        for (EntityItem entityItem : itemsInRange) {
            if (entityItem.field_70128_L) continue;
            double distanceX = (double)entityPlayer.func_180425_c().func_177958_n() + 0.5 - entityItem.field_70165_t;
            double distanceY = (double)entityPlayer.func_180425_c().func_177956_o() + 0.5 - entityItem.field_70163_u;
            double distanceZ = (double)entityPlayer.func_180425_c().func_177952_p() + 0.5 - entityItem.field_70161_v;
            double distance = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
            if (distance >= 0.7) {
                if (entityItem.func_174874_s()) continue;
                if (!ItemMagnetBehavior.drainEnergy(true, itemStack, (long)distance)) {
                    return;
                }
                ItemMagnetBehavior.drainEnergy(false, itemStack, (long)distance);
                double directionX = distanceX / distance;
                double directionY = distanceY / distance;
                double directionZ = distanceZ / distance;
                entityItem.field_70159_w = directionX * (double)this.speed * 8.0;
                entityItem.field_70181_x = directionY * (double)this.speed * 8.0;
                entityItem.field_70179_y = directionZ * (double)this.speed * 8.0;
                entityItem.field_70133_I = true;
                entityItem.func_174868_q();
                continue;
            }
            if (entityItem.func_174874_s()) continue;
            ItemStack stack = entityItem.func_92059_d();
            ItemStack remainder = GTTransferUtils.insertItem((IItemHandler)new ItemStackHandler(entityPlayer.field_71071_by.field_70462_a), stack, false);
            if (remainder.func_190926_b()) {
                entityItem.func_70106_y();
                continue;
            }
            if (stack.func_190916_E() <= remainder.func_190916_E()) continue;
            entityItem.func_92058_a(remainder);
        }
    }

    @SubscribeEvent
    public void onItemToss(@Nonnull ItemTossEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack stack = event.getEntityItem().func_92059_d();
        if (this.isMagnet(stack)) {
            return;
        }
        for (ItemStack itemStack : event.getPlayer().field_71071_by.field_70462_a) {
            if (!this.isMagnet(itemStack) || !ItemMagnetBehavior.isActive(itemStack)) continue;
            event.getEntityItem().func_174867_a(60);
            return;
        }
        if (this.isMagnet((ItemStack)event.getPlayer().field_71071_by.field_184439_c.get(0)) && ItemMagnetBehavior.isActive((ItemStack)event.getPlayer().field_71071_by.field_184439_c.get(0))) {
            event.getEntityItem().func_174867_a(60);
        }
    }

    private boolean isMagnet(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof MetaItem && ((MetaItem)stack.func_77973_b()).getBehaviours(stack).contains(this);
    }

    @Nonnull
    private AxisAlignedBB getAreaBoundingBox(@Nonnull EntityPlayer player) {
        return new AxisAlignedBB(player.func_180425_c()).func_72314_b((double)this.range, (double)this.range, (double)this.range);
    }

    private static boolean drainEnergy(boolean simulate, @Nonnull ItemStack stack, long amount) {
        IElectricItem electricItem = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem == null) {
            return false;
        }
        return electricItem.discharge(amount, Integer.MAX_VALUE, true, false, simulate) >= amount;
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        IItemBehaviour.super.addInformation(itemStack, lines);
        lines.add(I18n.func_135052_a((String)(ItemMagnetBehavior.isActive(itemStack) ? "behavior.item_magnet.enabled" : "behavior.item_magnet.disabled"), (Object[])new Object[0]));
    }
}

