/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors.monitorplugin;

import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.resources.picturetexture.PictureTexture;
import gregtech.api.gui.resources.utils.DownloadThread;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.DynamicLabelWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TextFieldWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.items.behavior.MonitorPluginBaseBehavior;
import gregtech.common.gui.widget.WidgetScrollBar;
import gregtech.common.gui.widget.monitor.WidgetPluginConfig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OnlinePicPluginBehavior
extends MonitorPluginBaseBehavior {
    public String url;
    public float scaleX;
    public float scaleY;
    public float rotation;
    public boolean flippedX;
    public boolean flippedY;
    private String tmpUrl;
    @SideOnly(value=Side.CLIENT)
    private DownloadThread downloader;
    @SideOnly(value=Side.CLIENT)
    public PictureTexture texture;
    @SideOnly(value=Side.CLIENT)
    public boolean failed;
    @SideOnly(value=Side.CLIENT)
    public String error;

    public void setConfig(String url, float rotation, float scaleX, float scaleY, boolean flippedX, boolean flippedY) {
        if (url.length() > 200 || this.url.equals(url) && this.rotation == rotation && this.scaleX == scaleX && this.scaleY == scaleY && this.flippedX == flippedX && this.flippedY == flippedY) {
            return;
        }
        this.url = url;
        this.rotation = rotation;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.flippedX = flippedX;
        this.flippedY = flippedY;
        this.writePluginData(0, packetBuffer -> {
            packetBuffer.func_180714_a(url);
            packetBuffer.writeFloat(rotation);
            packetBuffer.writeFloat(scaleX);
            packetBuffer.writeFloat(scaleY);
            packetBuffer.writeBoolean(flippedX);
            packetBuffer.writeBoolean(flippedY);
        });
        this.markAsDirty();
    }

    @Override
    public void readPluginData(int id, PacketBuffer buf) {
        if (id == 0) {
            String _url = buf.func_150789_c(200);
            if (!this.url.equals(_url)) {
                this.url = _url;
                this.texture = null;
                this.failed = false;
                this.error = null;
            }
            this.rotation = buf.readFloat();
            this.scaleX = buf.readFloat();
            this.scaleY = buf.readFloat();
            this.flippedX = buf.readBoolean();
            this.flippedY = buf.readBoolean();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74778_a("url", this.url);
        data.func_74776_a("rotation", this.rotation);
        data.func_74776_a("scaleX", this.scaleX);
        data.func_74776_a("scaleY", this.scaleY);
        data.func_74757_a("flippedX", this.flippedX);
        data.func_74757_a("flippedY", this.flippedY);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.url = data.func_74764_b("url") ? data.func_74779_i("url") : "";
        this.rotation = data.func_74764_b("rotation") ? data.func_74760_g("rotation") : 0.0f;
        this.scaleX = data.func_74764_b("scaleX") ? data.func_74760_g("scaleX") : 1.0f;
        this.scaleY = data.func_74764_b("scaleY") ? data.func_74760_g("scaleY") : 1.0f;
        this.flippedX = data.func_74764_b("flippedX") && data.func_74767_n("flippedX");
        this.flippedY = data.func_74764_b("flippedY") && data.func_74767_n("flippedY");
    }

    @Override
    public MonitorPluginBaseBehavior createPlugin() {
        return new OnlinePicPluginBehavior();
    }

    @Override
    public WidgetPluginConfig customUI(WidgetPluginConfig widgetGroup, IUIHolder holder, EntityPlayer entityPlayer) {
        this.tmpUrl = this.url;
        return widgetGroup.setSize(260, 150).widget(new DynamicLabelWidget(20, 20, () -> this.url.length() > 40 ? this.url.substring(0, 39) + "..." : this.url, -1)).widget(new TextFieldWidget(20, 30, 175, 10, true, () -> this.tmpUrl, text -> {
            this.tmpUrl = text;
        }).setValidator(data -> true).setMaxStringLength(200)).widget(new ClickButtonWidget(200, 30, 45, 10, "confirm", pressed -> this.setConfig(this.tmpUrl, this.rotation, this.scaleX, this.scaleY, this.flippedX, this.flippedY))).widget(new WidgetScrollBar(25, 40, 210, -180.0f, 180.0f, 1.0f, value -> this.setConfig(this.url, value.floatValue(), this.scaleX, this.scaleY, this.flippedX, this.flippedY)).setTitle("rotation", -1).setInitValue(this.rotation)).widget(new WidgetScrollBar(25, 60, 210, 0.0f, 1.0f, 0.05f, value -> this.setConfig(this.url, this.rotation, value.floatValue(), this.scaleY, this.flippedX, this.flippedY)).setTitle("scaleX", -1).setInitValue(this.scaleX)).widget(new WidgetScrollBar(25, 80, 210, 0.0f, 1.0f, 0.05f, value -> this.setConfig(this.url, this.rotation, this.scaleX, value.floatValue(), this.flippedX, this.flippedY)).setTitle("scaleY", -1).setInitValue(this.scaleY)).widget(new LabelWidget(40, 115, "flippedX:", -1)).widget(new ToggleButtonWidget(90, 110, 20, 20, () -> this.flippedX, state -> this.setConfig(this.url, this.rotation, this.scaleX, this.scaleY, state, this.flippedY))).widget(new LabelWidget(140, 115, "flippedY:", -1)).widget(new ToggleButtonWidget(190, 110, 20, 20, () -> this.flippedY, state -> this.setConfig(this.url, this.rotation, this.scaleX, this.scaleY, this.flippedX, state)));
    }

    @Override
    public void update() {
        if (this.screen != null && this.screen.getWorld().field_72995_K && this.texture != null) {
            this.texture.tick();
        }
    }

    @Override
    public void renderPlugin(float partialTicks, RayTraceResult rayTraceResult) {
        if (!this.url.isEmpty()) {
            if (this.texture != null && this.texture.hasTexture()) {
                this.texture.render(-0.5f, -0.5f, 1.0f, 1.0f, this.rotation, this.scaleX, this.scaleY, this.flippedX, this.flippedY);
            } else {
                this.loadTexture();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void loadTexture() {
        if (this.texture == null && !this.failed) {
            if (this.downloader == null && DownloadThread.activeDownloads < 5) {
                PictureTexture loadedTexture = DownloadThread.loadedImages.get(this.url);
                if (loadedTexture == null) {
                    Object object = DownloadThread.LOCK;
                    synchronized (object) {
                        if (!DownloadThread.loadingImages.contains(this.url)) {
                            this.downloader = new DownloadThread(this.url);
                            return;
                        }
                    }
                } else {
                    this.texture = loadedTexture;
                }
            }
            if (this.downloader != null && this.downloader.hasFinished()) {
                if (this.downloader.hasFailed()) {
                    this.failed = true;
                    this.error = this.downloader.getError();
                    DownloadThread.LOGGER.error("Could not load image of " + (this.screen != null ? this.screen.getPos().toString() : "") + " " + this.error);
                } else {
                    this.texture = DownloadThread.loadImage(this.downloader);
                }
                this.downloader = null;
            }
        }
    }
}

