/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.tool;

import com.google.common.collect.ImmutableSet;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.items.toolitem.aoe.AoESymmetrical;
import gregtech.api.items.toolitem.behavior.IToolBehavior;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class GrassPathBehavior
implements IToolBehavior {
    public static final GrassPathBehavior INSTANCE = new GrassPathBehavior();

    protected GrassPathBehavior() {
    }

    @Override
    @Nonnull
    public EnumActionResult onItemUse(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        Object blocks;
        if (facing == EnumFacing.DOWN) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (world.func_175623_d(pos.func_177984_a()) && GrassPathBehavior.isBlockPathConvertible(stack, world, player, pos, null)) {
            if (aoeDefinition == AoESymmetrical.none()) {
                blocks = ImmutableSet.of((Object)pos);
            } else {
                RayTraceResult rayTraceResult = ToolHelper.getPlayerDefaultRaytrace(player);
                if (rayTraceResult == null) {
                    return EnumActionResult.PASS;
                }
                if (rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                    return EnumActionResult.PASS;
                }
                if (rayTraceResult.field_178784_b == null) {
                    return EnumActionResult.PASS;
                }
                blocks = GrassPathBehavior.getPathConvertibleBlocks(stack, aoeDefinition, world, player, rayTraceResult);
                blocks.add(rayTraceResult.func_178782_a());
            }
        } else {
            return EnumActionResult.PASS;
        }
        boolean pathed = false;
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = (BlockPos)iterator.next();
            pathed |= world.func_175656_a(blockPos, Blocks.field_185774_da.func_176223_P());
            ToolHelper.damageItem(stack, (EntityLivingBase)player);
            if (!stack.func_190926_b()) continue;
            break;
        }
        if (pathed) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187771_eN, SoundCategory.PLAYERS, 1.0f, 1.0f);
            player.func_184609_a(hand);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static Set<BlockPos> getPathConvertibleBlocks(ItemStack stack, AoESymmetrical aoeDefinition, World world, EntityPlayer player, RayTraceResult rayTraceResult) {
        return ToolHelper.iterateAoE(stack, aoeDefinition, world, player, rayTraceResult, GrassPathBehavior::isBlockPathConvertible);
    }

    private static boolean isBlockPathConvertible(ItemStack stack, World world, EntityPlayer player, BlockPos pos, @Nullable BlockPos hitBlockPos) {
        if (world.func_175623_d(pos.func_177984_a())) {
            Block block = world.func_180495_p(pos).func_177230_c();
            return block == Blocks.field_150349_c || block == Blocks.field_150346_d;
        }
        return false;
    }

    @Override
    public void addInformation(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"item.gt.tool.behavior.grass_path", (Object[])new Object[0]));
    }
}

