/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import gregtech.api.GregTechAPI;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.impl.FakeModularGui;
import gregtech.api.items.gui.PlayerInventoryHolder;
import gregtech.api.items.itemhandlers.InaccessibleItemStackHandler;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityUIFactory;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GregFakePlayer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.custom.ClipboardRenderer;
import gregtech.common.gui.impl.FakeModularUIContainerClipboard;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.ClipboardBehavior;
import gregtech.core.network.packets.PacketClipboardNBTUpdate;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityClipboard
extends MetaTileEntity
implements IFastRenderMetaTileEntity {
    private static final AxisAlignedBB CLIPBOARD_AABB = new AxisAlignedBB(0.171875, 0.0, 0.0, 0.828125, 1.0, 0.025);
    public static final float scale = 1.0f;
    public FakeModularGui guiCache;
    public FakeModularUIContainerClipboard guiContainerCache;
    private static final Cuboid6 pageBox = new Cuboid6(0.1875, 0.015625, 0.015625, 0.8125, 0.890625, 0.01875);
    private static final NBTBase NO_CLIPBOARD_SIG = new NBTTagInt(0);
    private boolean didSetFacing = false;

    public MetaTileEntityClipboard(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    public void update() {
        super.update();
        if (this.guiContainerCache == null) {
            this.createFakeGui();
            this.scheduleRenderUpdate();
        }
        if (this.getWorld().field_72995_K && this.guiCache != null) {
            this.guiCache.updateScreen();
        }
        if (this.guiContainerCache != null) {
            this.guiContainerCache.detectAndSendChanges();
        }
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public void renderMetaTileEntityFast(CCRenderState renderState, Matrix4 translation, float partialTicks) {
        ClipboardRenderer.renderBoard(renderState, translation.copy(), new IVertexOperation[0], this.getFrontFacing(), this, partialTicks);
    }

    @Override
    public void renderMetaTileEntity(double x, double y, double z, float partialTicks) {
        if (this.getClipboard() != null) {
            ClipboardRenderer.renderGUI(x, y, z, this.getFrontFacing(), this, partialTicks);
        }
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.getPos().func_177982_a(-1, 0, -1), this.getPos().func_177982_a(2, 2, 2));
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityClipboard(this.metaTileEntityId);
    }

    @Override
    public ModularUI createUI(EntityPlayer entityPlayer) {
        if (this.getClipboard().func_77969_a(MetaItems.CLIPBOARD.getStackForm())) {
            List<IItemBehaviour> behaviours = ((MetaItem)this.getClipboard().func_77973_b()).getBehaviours(this.getClipboard());
            Optional<IItemBehaviour> clipboardBehaviour = behaviours.stream().filter(x -> x instanceof ClipboardBehavior).findFirst();
            if (!clipboardBehaviour.isPresent()) {
                return null;
            }
            if (clipboardBehaviour.get() instanceof ClipboardBehavior) {
                PlayerInventoryHolder holder = new PlayerInventoryHolder(new GregFakePlayer(entityPlayer.field_70170_p), EnumHand.MAIN_HAND);
                holder.setCustomValidityCheck(this::isValid).setCurrentItem(this.getClipboard());
                if (entityPlayer instanceof GregFakePlayer) {
                    return ClipboardBehavior.createMTEUI(holder, entityPlayer);
                }
                return ((ClipboardBehavior)clipboardBehaviour.get()).createUI(holder, entityPlayer);
            }
        }
        return null;
    }

    public void createFakeGui() {
        try {
            FakeModularUIContainerClipboard fakeModularUIContainer;
            GregFakePlayer fakePlayer = new GregFakePlayer(this.getWorld());
            fakePlayer.func_184611_a(EnumHand.MAIN_HAND, this.getClipboard());
            ModularUI ui = this.createUI(fakePlayer);
            ModularUI.Builder builder = new ModularUI.Builder(ui.backgroundPath, ui.getWidth(), ui.getHeight());
            builder.shouldColor(false);
            ArrayList widgets = new ArrayList(ui.guiWidgets.values());
            for (Widget widget : widgets) {
                builder.widget(widget);
            }
            ui = builder.build(ui.holder, ui.entityPlayer);
            this.guiContainerCache = fakeModularUIContainer = new FakeModularUIContainerClipboard(ui, this);
            if (this.getWorld().field_72995_K) {
                this.guiCache = new FakeModularGui(ui, fakeModularUIContainer);
            }
            this.writeCustomData(1, buffer -> {});
        }
        catch (Exception e) {
            GTLog.logger.error((Object)e);
        }
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.itemInventory = new InaccessibleItemStackHandler();
    }

    public ItemStack getClipboard() {
        if (this.itemInventory.getStackInSlot(0) == ItemStack.field_190927_a) {
            ((InaccessibleItemStackHandler)this.itemInventory).setStackInSlot(0, MetaItems.CLIPBOARD.getStackForm());
        }
        return this.itemInventory.getStackInSlot(0);
    }

    public void initializeClipboard(ItemStack stack) {
        ((InaccessibleItemStackHandler)this.itemInventory).setStackInSlot(0, stack.func_77946_l());
        this.writeCustomData(3, buf -> buf.func_150786_a(stack.func_77978_p()));
    }

    public void setClipboard(ItemStack stack) {
        ((InaccessibleItemStackHandler)this.itemInventory).setStackInSlot(0, stack.func_77946_l());
    }

    @Override
    public void getDrops(NonNullList<ItemStack> dropsList, @Nullable EntityPlayer harvester) {
        dropsList.clear();
        dropsList.add((Object)this.getClipboard());
    }

    @Override
    public float getBlockHardness() {
        return 100.0f;
    }

    @Override
    public int getHarvestLevel() {
        return 4;
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                MetaTileEntityUIFactory.INSTANCE.openUI(this.getHolder(), (EntityPlayerMP)playerIn);
            }
        } else {
            this.breakClipboard(playerIn);
        }
        return true;
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing wrenchSide, CuboidRayTraceResult hitResult) {
        return false;
    }

    private void breakClipboard(@Nullable EntityPlayer player) {
        if (!this.getWorld().field_72995_K) {
            BlockPos pos = this.getPos();
            World world = this.getWorld();
            NonNullList drops = NonNullList.func_191196_a();
            this.getDrops((NonNullList<ItemStack>)drops, player);
            Block.func_180635_a((World)this.getWorld(), (BlockPos)pos, (ItemStack)((ItemStack)drops.get(0)));
            this.dropAllCovers();
            this.onRemoval();
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    @Override
    public void onNeighborChanged() {
        if (!this.getWorld().field_72995_K && this.didSetFacing) {
            BlockPos pos = this.getPos().func_177972_a(this.getFrontFacing());
            IBlockState state = this.getWorld().func_180495_p(pos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.getWorld(), pos) || !state.isSideSolid((IBlockAccess)this.getWorld(), pos, this.getFrontFacing())) {
                this.breakClipboard(null);
            }
        }
    }

    @Override
    public void setFrontFacing(EnumFacing frontFacing) {
        super.setFrontFacing(frontFacing);
        this.didSetFacing = true;
    }

    @Override
    public String getHarvestTool() {
        return "axe";
    }

    @Override
    public void addCollisionBoundingBox(List<IndexedCuboid6> collisionList) {
        collisionList.add(new IndexedCuboid6(null, GTUtility.rotateAroundYAxis(CLIPBOARD_AABB, EnumFacing.NORTH, this.getFrontFacing())));
    }

    public IndexedCuboid6 getPageCuboid() {
        return new IndexedCuboid6(null, GTUtility.rotateAroundYAxis(pageBox.aabb(), EnumFacing.NORTH, this.getFrontFacing()));
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.CLIPBOARD_RENDERER.getParticleTexture(), (Object)0xFFFFFF);
    }

    public Pair<Double, Double> checkLookingAt(EntityPlayer player) {
        if (this.getWorld() != null && player != null) {
            double[] pos;
            TileEntity tileEntity;
            Vec3d startVec = RayTracer.getStartVec((EntityPlayer)player);
            Vec3d endVec = RayTracer.getEndVec((EntityPlayer)player);
            CuboidRayTraceResult rayTraceResult = RayTracer.rayTrace((BlockPos)this.getPos(), (Vector3)new Vector3(startVec), (Vector3)new Vector3(endVec), (IndexedCuboid6)this.getPageCuboid());
            if (rayTraceResult != null && rayTraceResult.field_178784_b == this.getFrontFacing().func_176734_d() && (tileEntity = this.getWorld().func_175625_s(rayTraceResult.func_178782_a())) instanceof IGregTechTileEntity && ((IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof MetaTileEntityClipboard && (pos = MetaTileEntityClipboard.handleRayTraceResult(rayTraceResult, this.getFrontFacing().func_176734_d()))[0] >= 0.0 && pos[0] <= 1.0 && pos[1] >= 0.0 && pos[1] <= 1.0) {
                return Pair.of((Object)pos[0], (Object)pos[1]);
            }
        }
        return null;
    }

    private static double[] handleRayTraceResult(CuboidRayTraceResult rayTraceResult, EnumFacing spin) {
        double x;
        double dY;
        double dX = rayTraceResult.field_178784_b.func_176740_k() == EnumFacing.Axis.X ? rayTraceResult.field_72307_f.field_72449_c - (double)rayTraceResult.func_178782_a().func_177952_p() : rayTraceResult.field_72307_f.field_72450_a - (double)rayTraceResult.func_178782_a().func_177958_n();
        double d = dY = rayTraceResult.field_178784_b.func_176740_k() == EnumFacing.Axis.Y ? rayTraceResult.field_72307_f.field_72449_c - (double)rayTraceResult.func_178782_a().func_177952_p() : rayTraceResult.field_72307_f.field_72448_b - (double)rayTraceResult.func_178782_a().func_177956_o();
        if (spin == EnumFacing.NORTH) {
            x = 1.0 - dX;
        } else if (spin == EnumFacing.SOUTH) {
            x = dX;
        } else if (spin == EnumFacing.EAST) {
            x = 1.0 - dX;
            if (rayTraceResult.field_178784_b.func_82601_c() < 0 || rayTraceResult.field_178784_b.func_82599_e() > 0) {
                x = 1.0 - x;
            }
        } else {
            x = 1.0 - dX;
            if (rayTraceResult.field_178784_b.func_82601_c() < 0 || rayTraceResult.field_178784_b.func_82599_e() > 0) {
                x = 1.0 - x;
            }
        }
        double y = 1.0 - dY;
        x -= 0.1875;
        y -= 0.109375;
        return new double[]{x /= 0.875, y /= 0.875};
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.getClipboard() != null && this.getClipboard().func_77978_p() != null) {
            data.func_74782_a("clipboardNBT", (NBTBase)this.getClipboard().func_77978_p());
        } else {
            data.func_74782_a("clipboardNBT", NO_CLIPBOARD_SIG);
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        NBTBase clipboardNBT = data.func_74781_a("clipboardNBT");
        if (clipboardNBT != NO_CLIPBOARD_SIG && clipboardNBT instanceof NBTTagCompound) {
            ItemStack clipboard = this.getClipboard();
            clipboard.func_77982_d((NBTTagCompound)clipboardNBT);
            this.setClipboard(clipboard);
        }
    }

    public void setClipboardNBT(NBTTagCompound data) {
        ItemStack clipboard = this.getClipboard();
        clipboard.func_77982_d(data);
        this.setClipboard(clipboard);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        if (this.getClipboard() != null && this.getClipboard().func_77978_p() != null) {
            buf.func_150786_a(this.getClipboard().func_77978_p());
        } else {
            buf.func_150786_a(new NBTTagCompound());
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        try {
            NBTTagCompound clipboardNBT = buf.func_150793_b();
            if (clipboardNBT != null && !clipboardNBT.equals((Object)new NBTTagCompound())) {
                ItemStack clipboard = this.getClipboard();
                clipboard.func_77982_d(clipboardNBT);
                this.setClipboard(clipboard);
            }
        }
        catch (Exception e) {
            GTLog.logger.error("Could not initialize Clipboard from InitialSyncData buffer", (Throwable)e);
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId >= 10) {
            int windowID = buf.func_150792_a();
            int widgetID = buf.func_150792_a();
            if (this.guiCache != null) {
                this.guiCache.handleWidgetUpdate(windowID, widgetID, buf);
            }
            this.scheduleRenderUpdate();
            this.sendNBTToServer();
        } else if (dataId == 1) {
            this.createFakeGui();
            this.scheduleRenderUpdate();
        } else if (dataId == 2) {
            int mouseX = buf.func_150792_a();
            int mouseY = buf.func_150792_a();
            if (this.guiCache != null && this.guiContainerCache != null) {
                this.guiCache.mouseClicked(mouseX, mouseY, 0);
            }
            this.scheduleRenderUpdate();
            this.sendNBTToServer();
        } else if (dataId == 3) {
            try {
                NBTTagCompound clipboardNBT = buf.func_150793_b();
                if (clipboardNBT != NO_CLIPBOARD_SIG) {
                    ItemStack clipboard = this.getClipboard();
                    clipboard.func_77982_d(clipboardNBT);
                    this.setClipboard(clipboard);
                }
            }
            catch (Exception e) {
                GTLog.logger.error("Could not read Clipboard Init NBT from CustomData buffer", (Throwable)e);
            }
        }
    }

    private void sendNBTToServer() {
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.func_150786_a(this.getClipboard().func_77978_p());
        GregTechAPI.networkHandler.sendToServer(new PacketClipboardNBTUpdate(this.getWorld().field_73011_w.getDimension(), this.getPos(), 1, packetBuffer));
    }

    @Override
    public void getSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
    }

    public void readUIAction(EntityPlayerMP player, int id, PacketBuffer buf) {
        if (id == 1 && this.guiContainerCache != null) {
            this.guiContainerCache.handleClientAction(buf);
        }
    }

    @Override
    public void onLeftClick(EntityPlayer player, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (this.getWorld().field_72995_K) {
            return;
        }
        Pair<Double, Double> clickCoords = this.checkLookingAt(player);
        int width = 178;
        int height = 230;
        double scale = 1.0 / (double)Math.max(width, height);
        int mouseX = (int)((Double)clickCoords.getLeft() / scale);
        int mouseY = (int)((Double)clickCoords.getRight() / scale);
        if (0 <= mouseX && mouseX <= width && 0 <= mouseY && mouseY <= height) {
            this.writeCustomData(2, buf -> {
                buf.func_150787_b(mouseX);
                buf.func_150787_b(mouseY);
            });
        }
    }

    @Override
    public boolean canPlaceCoverOnSide(EnumFacing side) {
        return false;
    }

    @Override
    public boolean canRenderMachineGrid(@Nonnull ItemStack mainHandStack, @Nonnull ItemStack offHandStack) {
        return false;
    }

    @Override
    public boolean showToolUsages() {
        return false;
    }

    @Override
    public ItemStack getPickItem(CuboidRayTraceResult result, EntityPlayer player) {
        return this.getClipboard();
    }
}

