/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi;

import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockFireboxCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import net.minecraft.block.state.IBlockState;

public enum BoilerType {
    BRONZE(800, 1200, MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.BRONZE_BRICKS), MetaBlocks.BOILER_FIREBOX_CASING.getState(BlockFireboxCasing.FireboxCasingType.BRONZE_FIREBOX), MetaBlocks.BOILER_CASING.getState(BlockBoilerCasing.BoilerCasingType.BRONZE_PIPE), Textures.BRONZE_PLATED_BRICKS, Textures.BRONZE_FIREBOX, Textures.BRONZE_FIREBOX_ACTIVE, Textures.LARGE_BRONZE_BOILER),
    STEEL(1800, 1800, MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STEEL_SOLID), MetaBlocks.BOILER_FIREBOX_CASING.getState(BlockFireboxCasing.FireboxCasingType.STEEL_FIREBOX), MetaBlocks.BOILER_CASING.getState(BlockBoilerCasing.BoilerCasingType.STEEL_PIPE), Textures.SOLID_STEEL_CASING, Textures.STEEL_FIREBOX, Textures.STEEL_FIREBOX_ACTIVE, Textures.LARGE_STEEL_BOILER),
    TITANIUM(3200, 2400, MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TITANIUM_STABLE), MetaBlocks.BOILER_FIREBOX_CASING.getState(BlockFireboxCasing.FireboxCasingType.TITANIUM_FIREBOX), MetaBlocks.BOILER_CASING.getState(BlockBoilerCasing.BoilerCasingType.TITANIUM_PIPE), Textures.STABLE_TITANIUM_CASING, Textures.TITANIUM_FIREBOX, Textures.TITANIUM_FIREBOX_ACTIVE, Textures.LARGE_TITANIUM_BOILER),
    TUNGSTENSTEEL(6400, 3000, MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST), MetaBlocks.BOILER_FIREBOX_CASING.getState(BlockFireboxCasing.FireboxCasingType.TUNGSTENSTEEL_FIREBOX), MetaBlocks.BOILER_CASING.getState(BlockBoilerCasing.BoilerCasingType.TUNGSTENSTEEL_PIPE), Textures.ROBUST_TUNGSTENSTEEL_CASING, Textures.TUNGSTENSTEEL_FIREBOX, Textures.TUNGSTENSTEEL_FIREBOX_ACTIVE, Textures.LARGE_TUNGSTENSTEEL_BOILER);

    private final int steamPerTick;
    private final int ticksToBoiling;
    public final IBlockState casingState;
    public final IBlockState fireboxState;
    public final IBlockState pipeState;
    public final ICubeRenderer casingRenderer;
    public final ICubeRenderer fireboxIdleRenderer;
    public final ICubeRenderer fireboxActiveRenderer;
    public final ICubeRenderer frontOverlay;

    private BoilerType(int steamPerTick, int ticksToBoiling, IBlockState casingState, IBlockState fireboxState, IBlockState pipeState, ICubeRenderer casingRenderer, ICubeRenderer fireboxIdleRenderer, ICubeRenderer fireboxActiveRenderer, ICubeRenderer frontOverlay) {
        this.steamPerTick = steamPerTick;
        this.ticksToBoiling = ticksToBoiling;
        this.casingState = casingState;
        this.fireboxState = fireboxState;
        this.pipeState = pipeState;
        this.casingRenderer = casingRenderer;
        this.fireboxIdleRenderer = fireboxIdleRenderer;
        this.fireboxActiveRenderer = fireboxActiveRenderer;
        this.frontOverlay = frontOverlay;
    }

    public int steamPerTick() {
        return this.steamPerTick;
    }

    public int getTicksToBoiling() {
        return this.ticksToBoiling;
    }

    public int runtimeBoost(int ticks) {
        switch (this) {
            case BRONZE: {
                return ticks * 2;
            }
            case STEEL: {
                return ticks * 150 / 100;
            }
            case TITANIUM: {
                return ticks * 120 / 100;
            }
            case TUNGSTENSTEEL: {
                return ticks;
            }
        }
        return 0;
    }
}

