/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.RecipeProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapPrimitiveMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

public class MetaTileEntityCokeOven
extends RecipeMapPrimitiveMultiblockController {
    public MetaTileEntityCokeOven(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.COKE_OVEN_RECIPES);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityCokeOven(this.metaTileEntityId);
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "X#X", "XXX").aisle("XXX", "XYX", "XXX").where('X', MetaTileEntityCokeOven.states(this.getCasingState()).or(MetaTileEntityCokeOven.metaTileEntities(MetaTileEntities.COKE_OVEN_HATCH).setMaxGlobalLimited(5))).where('#', MetaTileEntityCokeOven.air()).where('Y', this.selfPredicate()).build();
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.COKE_BRICKS);
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.COKE_BRICKS;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.recipeMapWorkable.isActive(), this.recipeMapWorkable.isWorkingEnabled());
    }

    @Override
    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.COKE_OVEN_OVERLAY;
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return false;
    }

    @Override
    protected ModularUI.Builder createUITemplate(EntityPlayer entityPlayer) {
        return ModularUI.builder(GuiTextures.PRIMITIVE_BACKGROUND, 176, 166).shouldColor(false).widget(new LabelWidget(5, 5, this.getMetaFullName(), new Object[0])).widget(new SlotWidget((IItemHandler)this.importItems, 0, 52, 30, true, true).setBackgroundTexture(GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_FURNACE_OVERLAY)).widget(new RecipeProgressWidget(this.recipeMapWorkable::getProgressPercent, 76, 32, 20, 15, GuiTextures.PRIMITIVE_BLAST_FURNACE_PROGRESS_BAR, ProgressWidget.MoveType.HORIZONTAL, RecipeMaps.COKE_OVEN_RECIPES)).widget(new SlotWidget((IItemHandler)this.exportItems, 0, 103, 30, true, false).setBackgroundTexture(GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_FURNACE_OVERLAY)).widget(new TankWidget(this.exportFluids.getTankAt(0), 134, 13, 20, 58).setBackgroundTexture(GuiTextures.PRIMITIVE_LARGE_FLUID_TANK).setOverlayTexture(GuiTextures.PRIMITIVE_LARGE_FLUID_TANK_OVERLAY).setContainerClicking(true, false)).bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.PRIMITIVE_SLOT, 0);
    }

    @Override
    public void randomDisplayTick() {
        if (this.isActive()) {
            BlockPos pos = this.getPos();
            float x = (float)pos.func_177958_n() + 0.5f;
            float z = (float)pos.func_177952_p() + 0.5f;
            EnumFacing facing = this.getFrontFacing();
            float horizontalOffset = GTValues.RNG.nextFloat() * 0.6f - 0.3f;
            float y = (float)pos.func_177956_o() + GTValues.RNG.nextFloat() * 0.375f + 0.3f;
            if (facing.func_176740_k() == EnumFacing.Axis.X) {
                x = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? (x += 0.52f) : (x -= 0.52f);
                z += horizontalOffset;
            } else if (facing.func_176740_k() == EnumFacing.Axis.Z) {
                z = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? (z += 0.52f) : (z -= 0.52f);
                x += horizontalOffset;
            }
            if (ConfigHolder.machines.machineSounds && GTValues.RNG.nextDouble() < 0.1) {
                this.getWorld().func_184134_a((double)x, (double)y, (double)z, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            this.getWorld().func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
            this.getWorld().func_175688_a(EnumParticleTypes.FLAME, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

