/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.BoilerRecipeLogic;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.metatileentities.multi.BoilerType;
import gregtech.core.sound.GTSoundEvents;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MetaTileEntityLargeBoiler
extends MultiblockWithDisplayBase {
    public final BoilerType boilerType;
    protected BoilerRecipeLogic recipeLogic;
    private FluidTankList fluidImportInventory;
    private ItemHandlerList itemImportInventory;
    private FluidTankList steamOutputTank;
    private int throttlePercentage = 100;

    public MetaTileEntityLargeBoiler(ResourceLocation metaTileEntityId, BoilerType boilerType) {
        super(metaTileEntityId);
        this.boilerType = boilerType;
        this.recipeLogic = new BoilerRecipeLogic(this);
        this.resetTileAbilities();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeBoiler(this.metaTileEntityId, this.boilerType);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
        this.throttlePercentage = 100;
        this.recipeLogic.invalidate();
    }

    private void initializeAbilities() {
        this.fluidImportInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.itemImportInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        this.steamOutputTank = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
    }

    private void resetTileAbilities() {
        this.fluidImportInventory = new FluidTankList(true, new IFluidTank[0]);
        this.itemImportInventory = new ItemHandlerList(Collections.emptyList());
        this.steamOutputTank = new FluidTankList(true, new IFluidTank[0]);
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        super.addDisplayText(textList);
        if (this.isStructureFormed()) {
            int efficiency = this.recipeLogic.getHeatScaled();
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.large_boiler.efficiency", new Object[]{(efficiency == 0 ? TextFormatting.DARK_RED : (efficiency <= 40 ? TextFormatting.RED : (efficiency == 100 ? TextFormatting.GREEN : TextFormatting.YELLOW))).toString() + efficiency + "%"}));
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.large_boiler.steam_output", new Object[]{this.recipeLogic.getLastTickSteam()}));
            TextComponentTranslation throttleText = new TextComponentTranslation("gregtech.multiblock.large_boiler.throttle", new Object[]{TextFormatting.AQUA.toString() + this.getThrottle() + "%"});
            AdvancedTextWidget.withHoverTextTranslate((ITextComponent)throttleText, "gregtech.multiblock.large_boiler.throttle.tooltip");
            textList.add((ITextComponent)throttleText);
            TextComponentTranslation buttonText = new TextComponentTranslation("gregtech.multiblock.large_boiler.throttle_modify", new Object[0]);
            buttonText.func_150258_a(" ");
            buttonText.func_150257_a(AdvancedTextWidget.withButton((ITextComponent)new TextComponentString("[-]"), "sub"));
            buttonText.func_150258_a(" ");
            buttonText.func_150257_a(AdvancedTextWidget.withButton((ITextComponent)new TextComponentString("[+]"), "add"));
            textList.add((ITextComponent)buttonText);
        }
    }

    @Override
    protected void handleDisplayClick(String componentData, Widget.ClickData clickData) {
        super.handleDisplayClick(componentData, clickData);
        int result = componentData.equals("add") ? 5 : -5;
        this.throttlePercentage = MathHelper.func_76125_a((int)(this.throttlePercentage + result), (int)25, (int)100);
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.recipeLogic.isActive() && this.recipeLogic.isWorkingEnabled();
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return this.boilerType == null ? null : FactoryBlockPattern.start().aisle("XXX", "CCC", "CCC", "CCC").aisle("XXX", "CPC", "CPC", "CCC").aisle("XXX", "CSC", "CCC", "CCC").where('S', this.selfPredicate()).where('P', MetaTileEntityLargeBoiler.states(this.boilerType.pipeState)).where('X', MetaTileEntityLargeBoiler.states(this.boilerType.fireboxState).setMinGlobalLimited(4).or(MetaTileEntityLargeBoiler.abilities(MultiblockAbility.IMPORT_FLUIDS).setMinGlobalLimited(1)).or(MetaTileEntityLargeBoiler.abilities(MultiblockAbility.IMPORT_ITEMS).setMaxGlobalLimited(1)).or(this.autoAbilities())).where('C', MetaTileEntityLargeBoiler.states(this.boilerType.casingState).setMinGlobalLimited(20).or(MetaTileEntityLargeBoiler.abilities(MultiblockAbility.EXPORT_FLUIDS).setMinGlobalLimited(1))).build();
    }

    @Override
    public String[] getDescription() {
        return new String[]{I18n.func_135052_a((String)"gregtech.multiblock.large_boiler.description", (Object[])new Object[0])};
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.large_boiler.rate_tooltip", (Object[])new Object[]{(int)((double)(this.boilerType.steamPerTick() * 20 * this.boilerType.runtimeBoost(20)) / 20.0)}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.large_boiler.heat_time_tooltip", (Object[])new Object[]{this.boilerType.getTicksToBoiling() / 20}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.base_production_fluid", (Object[])new Object[]{this.boilerType.steamPerTick()}));
        tooltip.add(TooltipHelper.BLINKING_RED + I18n.func_135052_a((String)"gregtech.multiblock.large_boiler.explosion_tooltip", (Object[])new Object[0]));
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), this.recipeLogic.isWorkingEnabled());
    }

    @Override
    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return this.boilerType.frontOverlay;
    }

    private boolean isFireboxPart(IMultiblockPart sourcePart) {
        return this.isStructureFormed() && ((MetaTileEntity)((Object)sourcePart)).getPos().func_177956_o() < this.getPos().func_177956_o();
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (sourcePart != null && this.isFireboxPart(sourcePart)) {
            return this.isActive() ? this.boilerType.fireboxActiveRenderer : this.boilerType.fireboxIdleRenderer;
        }
        return this.boilerType.casingRenderer;
    }

    @Override
    public boolean hasMufflerMechanics() {
        return true;
    }

    @Override
    public SoundEvent getSound() {
        return GTSoundEvents.BOILER;
    }

    @Override
    protected void updateFormedValid() {
        this.recipeLogic.update();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74768_a("ThrottlePercentage", this.throttlePercentage);
        return super.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.throttlePercentage = data.func_74762_e("ThrottlePercentage");
        super.readFromNBT(data);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.func_150787_b(this.throttlePercentage);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.throttlePercentage = buf.func_150792_a();
    }

    public int getThrottle() {
        return this.throttlePercentage;
    }

    @Override
    public IItemHandlerModifiable getImportItems() {
        return this.itemImportInventory;
    }

    @Override
    public FluidTankList getImportFluids() {
        return this.fluidImportInventory;
    }

    @Override
    public FluidTankList getExportFluids() {
        return this.steamOutputTank;
    }

    @Override
    protected boolean shouldUpdate(MTETrait trait) {
        return !(trait instanceof BoilerRecipeLogic);
    }

    @Override
    protected boolean shouldShowVoidingModeButton() {
        return false;
    }
}

