/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockSteamCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;

public class MetaTileEntityMultiblockTank
extends MultiblockWithDisplayBase {
    private final boolean isMetal;
    private final int capacity;

    public MetaTileEntityMultiblockTank(ResourceLocation metaTileEntityId, boolean isMetal, int capacity) {
        super(metaTileEntityId);
        this.isMetal = isMetal;
        this.capacity = capacity;
        this.initializeInventory();
    }

    @Override
    protected void initializeInventory() {
        FluidTankList tankList;
        super.initializeInventory();
        FilteredFluidHandler tank = new FilteredFluidHandler(this.capacity).setFillPredicate(fluidStack -> this.isMetal || !fluidStack.getFluid().isGaseous() && fluidStack.getFluid().getTemperature() <= 325);
        this.importFluids = tankList = new FluidTankList(true, new IFluidTank[]{tank});
        this.exportFluids = tankList;
        this.fluidInventory = tank;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityMultiblockTank(this.metaTileEntityId, this.isMetal, this.capacity);
    }

    @Override
    protected void updateFormedValid() {
    }

    @Override
    @Nonnull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "X X", "XXX").aisle("XXX", "XSX", "XXX").where('S', this.selfPredicate()).where('X', MetaTileEntityMultiblockTank.states(this.getCasingState()).setMinGlobalLimited(23).or(MetaTileEntityMultiblockTank.metaTileEntities(this.getValve()).setMaxGlobalLimited(2))).where(' ', MetaTileEntityMultiblockTank.air()).build();
    }

    private IBlockState getCasingState() {
        if (this.isMetal) {
            return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STEEL_SOLID);
        }
        return MetaBlocks.STEAM_CASING.getState(BlockSteamCasing.SteamCasingType.WOOD_WALL);
    }

    private MetaTileEntity getValve() {
        if (this.isMetal) {
            return MetaTileEntities.STEEL_TANK_VALVE;
        }
        return MetaTileEntities.WOODEN_TANK_VALVE;
    }

    @Override
    @Nonnull
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (this.isMetal) {
            return Textures.SOLID_STEEL_CASING;
        }
        return Textures.WOOD_WALL;
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return false;
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!this.isStructureFormed()) {
            return false;
        }
        return super.onRightClick(playerIn, hand, facing, hitResult);
    }

    @Override
    protected ModularUI.Builder createUITemplate(@Nonnull EntityPlayer entityPlayer) {
        return ModularUI.defaultBuilder().widget(new LabelWidget(6, 6, this.getMetaFullName(), new Object[0])).widget(new TankWidget(this.importFluids.getTankAt(0), 52, 18, 72, 61).setBackgroundTexture(GuiTextures.SLOT).setContainerClicking(true, true)).bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 0);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderSided(this.getFrontFacing(), renderState, translation, pipeline);
    }

    @Override
    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.MULTIBLOCK_TANK_OVERLAY;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @Nonnull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.tank.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.capacity}));
    }
}

