/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import codechicken.lib.vec.Vector3;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RelativeDirection;
import gregtech.client.particle.GTLaserBeamParticle;
import gregtech.client.particle.GTParticleManager;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import net.minecraft.block.state.IBlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MetaTileEntityAssemblyLine
extends RecipeMapMultiblockController {
    private static final ResourceLocation LASER_LOCATION = new ResourceLocation("gregtech", "textures/fx/laser/laser.png");
    private static final ResourceLocation LASER_HEAD_LOCATION = new ResourceLocation("gregtech", "textures/fx/laser/laser_start.png");
    private int beamCount;
    @SideOnly(value=Side.CLIENT)
    private GTLaserBeamParticle[][] beamParticles;

    public MetaTileEntityAssemblyLine(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.ASSEMBLY_LINE_RECIPES);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityAssemblyLine(this.metaTileEntityId);
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start(RelativeDirection.FRONT, RelativeDirection.UP, RelativeDirection.RIGHT).aisle("FIF", "RTR", "SAG", "#Y#").aisle("FIF", "RTR", "GAG", "#Y#").setRepeatable(3, 15).aisle("FOF", "RTR", "GAG", "#Y#").where('S', this.selfPredicate()).where('F', MetaTileEntityAssemblyLine.states(this.getCasingState()).or(this.autoAbilities(false, true, false, false, false, false, false)).or(MetaTileEntityAssemblyLine.abilities(MultiblockAbility.IMPORT_FLUIDS).setMaxGlobalLimited(4))).where('O', MetaTileEntityAssemblyLine.abilities(MultiblockAbility.EXPORT_ITEMS).addTooltips("gregtech.multiblock.pattern.location_end")).where('Y', MetaTileEntityAssemblyLine.states(this.getCasingState()).or(MetaTileEntityAssemblyLine.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3))).where('I', MetaTileEntityAssemblyLine.metaTileEntities(MetaTileEntities.ITEM_IMPORT_BUS[0])).where('G', MetaTileEntityAssemblyLine.states(MetaBlocks.MULTIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.GRATE_CASING))).where('A', MetaTileEntityAssemblyLine.states(MetaBlocks.MULTIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.ASSEMBLY_CONTROL))).where('R', MetaTileEntityAssemblyLine.states(MetaBlocks.TRANSPARENT_CASING.getState(BlockGlassCasing.CasingType.LAMINATED_GLASS))).where('T', MetaTileEntityAssemblyLine.states(MetaBlocks.MULTIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.ASSEMBLY_LINE_CASING))).where('#', MetaTileEntityAssemblyLine.any()).build();
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.SOLID_STEEL_CASING;
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STEEL_SOLID);
    }

    @Override
    public void update() {
        super.update();
        if (ConfigHolder.client.shader.assemblyLineParticles) {
            if (this.getRecipeMapWorkable().isWorking()) {
                int maxBeams = this.getAbilities(MultiblockAbility.IMPORT_ITEMS).size() + 1;
                int maxProgress = this.getRecipeMapWorkable().getMaxProgress();
                int beamTime = Math.max(1, maxProgress / maxBeams);
                int currentBeamCount = Math.min(maxBeams, this.getRecipeMapWorkable().getProgress() / beamTime);
                if (currentBeamCount != this.beamCount) {
                    this.beamCount = currentBeamCount;
                    this.writeCustomData(371, this::writeParticles);
                }
            } else if (this.beamCount != 0) {
                this.beamCount = 0;
                this.writeCustomData(371, this::writeParticles);
            }
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.writeParticles(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.readParticles(buf);
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == 371) {
            this.readParticles(buf);
        } else {
            super.receiveCustomData(dataId, buf);
        }
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (this.getWorld().field_72995_K && this.beamParticles != null) {
            for (GTLaserBeamParticle[] particle : this.beamParticles) {
                if (particle[0] == null) continue;
                particle[0].func_187112_i();
                particle[1].func_187112_i();
            }
            this.beamParticles = null;
        }
    }

    private void writeParticles(PacketBuffer buf) {
        buf.func_150787_b(this.beamCount);
    }

    private void readParticles(PacketBuffer buf) {
        this.beamCount = buf.func_150792_a();
        if (this.beamParticles == null) {
            this.beamParticles = new GTLaserBeamParticle[17][2];
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.getPos());
        for (int i = 0; i < this.beamParticles.length; ++i) {
            GTLaserBeamParticle particle = this.beamParticles[i][0];
            if (i < this.beamCount && particle == null) {
                pos.func_189533_g((Vec3i)this.getPos());
                Vector3 startPos = new Vector3().add((BlockPos)pos.func_189534_c(this.getFrontFacing().func_176746_e().func_176734_d(), i)).add(0.5, 0.0, 0.5);
                Vector3 endPos = startPos.copy().subtract(0.0, 1.0, 0.0);
                this.beamParticles[i][0] = this.createALParticles(this.getWorld(), startPos, endPos);
                pos.func_189533_g((Vec3i)this.getPos());
                startPos = new Vector3().add((BlockPos)pos.func_189534_c(this.getFrontFacing().func_176746_e().func_176734_d(), i).func_189534_c(this.getFrontFacing().func_176734_d(), 2)).add(0.5, 0.0, 0.5);
                endPos = startPos.copy().subtract(0.0, 1.0, 0.0);
                this.beamParticles[i][1] = this.createALParticles(this.getWorld(), startPos, endPos);
                GTParticleManager.INSTANCE.addEffect(this.beamParticles[i][0], this.beamParticles[i][1]);
                continue;
            }
            if (i < this.beamCount || particle == null) continue;
            particle.func_187112_i();
            this.beamParticles[i][0] = null;
            this.beamParticles[i][1].func_187112_i();
            this.beamParticles[i][1] = null;
        }
    }

    private GTLaserBeamParticle createALParticles(World world, Vector3 startPos, Vector3 endPos) {
        GTLaserBeamParticle particle = new GTLaserBeamParticle(world, startPos, endPos).setBody(LASER_LOCATION).setBeamHeight(0.125f).setDoubleVertical(true).setHead(LASER_HEAD_LOCATION).setHeadWidth(0.1f).setEmit(0.2f);
        particle.setOnUpdate(p -> {
            if (!this.isValid() || !GTUtility.isPosChunkLoaded(this.getWorld(), this.getPos()) || this.getWorld().func_175625_s(this.getPos()) != this.getHolder()) {
                p.func_187112_i();
            }
        });
        return particle;
    }
}

