/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam;

import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.capability.impl.RecipeLogicSteam;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SteamMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.renderer.texture.Textures;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SteamRockBreaker
extends SteamMetaTileEntity {
    private boolean hasValidFluids;

    public SteamRockBreaker(ResourceLocation metaTileEntityId, boolean isHighPressure) {
        super(metaTileEntityId, RecipeMaps.ROCK_BREAKER_RECIPES, Textures.ROCK_BREAKER_OVERLAY, isHighPressure);
        this.workableHandler = new SteamRockBreakerRecipeLogic(this, this.workableHandler.getRecipeMap(), isHighPressure, (IFluidTank)this.steamFluidTank, 1.0);
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.checkAdjacentFluids();
        }
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new SteamRockBreaker(this.metaTileEntityId, this.isHighPressure);
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.checkAdjacentFluids();
    }

    private void checkAdjacentFluids() {
        boolean hasLava = false;
        boolean hasWater = false;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (hasLava && hasWater) break;
            if (side == this.frontFacing || side.func_176740_k().func_176720_b()) continue;
            Block block = this.getWorld().func_180495_p(this.getPos().func_177972_a(side)).func_177230_c();
            if (block == Blocks.field_150356_k || block == Blocks.field_150353_l) {
                hasLava = true;
                continue;
            }
            if (block != Blocks.field_150358_i && block != Blocks.field_150355_j) continue;
            hasWater = true;
        }
        this.hasValidFluids = hasLava && hasWater;
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new NotifiableItemStackHandler(1, this, false);
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new NotifiableItemStackHandler(4, this, true);
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        return this.createUITemplate(player).slot(this.importItems, 0, 53, 34, GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.DUST_OVERLAY_STEAM.get(this.isHighPressure)).progressBar(this.workableHandler::getProgressPercent, 79, 35, 21, 18, GuiTextures.PROGRESS_BAR_MACERATE_STEAM.get(this.isHighPressure), ProgressWidget.MoveType.HORIZONTAL, this.workableHandler.getRecipeMap()).slot(this.exportItems, 0, 107, 25, true, false, GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.CRUSHED_ORE_OVERLAY_STEAM.get(this.isHighPressure)).slot(this.exportItems, 1, 125, 25, true, false, GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.CRUSHED_ORE_OVERLAY_STEAM.get(this.isHighPressure)).slot(this.exportItems, 2, 107, 43, true, false, GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.CRUSHED_ORE_OVERLAY_STEAM.get(this.isHighPressure)).slot(this.exportItems, 3, 125, 43, true, false, GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.CRUSHED_ORE_OVERLAY_STEAM.get(this.isHighPressure)).build(this.getHolder(), player);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("hasValidFluids", this.hasValidFluids);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("hasValidFluids")) {
            this.hasValidFluids = data.func_74767_n("hasValidFluids");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void randomDisplayTick(float x, float y, float z, EnumParticleTypes flame, EnumParticleTypes smoke) {
        this.getWorld().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)x, (double)(y + 0.4f), (double)z, 0.0, 0.0, 0.0, new int[0]);
    }

    protected class SteamRockBreakerRecipeLogic
    extends RecipeLogicSteam {
        public SteamRockBreakerRecipeLogic(MetaTileEntity tileEntity, RecipeMap<?> recipeMap, boolean isHighPressure, IFluidTank steamFluidTank, double conversionRate) {
            super(tileEntity, recipeMap, isHighPressure, steamFluidTank, conversionRate);
        }

        @Override
        protected boolean shouldSearchForRecipes() {
            return SteamRockBreaker.this.hasValidFluids && super.shouldSearchForRecipes();
        }
    }
}

