/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam.boiler;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IFuelInfo;
import gregtech.api.capability.IFuelable;
import gregtech.api.capability.impl.ItemFuelInfo;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.ModHandler;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.steam.boiler.SteamBoiler;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class SteamCoalBoiler
extends SteamBoiler
implements IFuelable {
    public SteamCoalBoiler(ResourceLocation metaTileEntityId, boolean isHighPressure) {
        super(metaTileEntityId, isHighPressure, Textures.COAL_BOILER_OVERLAY);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new SteamCoalBoiler(this.metaTileEntityId, this.isHighPressure);
    }

    @Override
    protected int getBaseSteamOutput() {
        return this.isHighPressure ? 300 : 120;
    }

    @Override
    protected void tryConsumeNewFuel() {
        ItemStack fuelInSlot = this.importItems.extractItem(0, 1, true);
        if (fuelInSlot.func_190926_b()) {
            return;
        }
        if (FluidUtil.getFluidHandler((ItemStack)fuelInSlot) != null) {
            return;
        }
        int burnTime = TileEntityFurnace.func_145952_a((ItemStack)fuelInSlot);
        if (burnTime <= 0) {
            return;
        }
        this.importItems.extractItem(0, 1, false);
        ItemStack remainderAsh = ModHandler.getBurningFuelRemainder(fuelInSlot);
        if (!remainderAsh.func_190926_b()) {
            this.exportItems.insertItem(0, remainderAsh, false);
        }
        this.setFuelMaxBurnTime(burnTime);
    }

    @Override
    protected int getCooldownInterval() {
        return this.isHighPressure ? 40 : 45;
    }

    @Override
    protected int getCoolDownRate() {
        return 1;
    }

    @Override
    public IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    public IItemHandlerModifiable createImportItemHandler() {
        return new ItemStackHandler(1){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (TileEntityFurnace.func_145952_a((ItemStack)stack) <= 0) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechCapabilities.CAPABILITY_FUELABLE) {
            return (T)GregtechCapabilities.CAPABILITY_FUELABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public Collection<IFuelInfo> getFuels() {
        ItemStack fuelInSlot = this.importItems.extractItem(0, Integer.MAX_VALUE, true);
        if (fuelInSlot == ItemStack.field_190927_a) {
            return Collections.emptySet();
        }
        int fuelRemaining = fuelInSlot.func_190916_E();
        int fuelCapacity = this.importItems.getSlotLimit(0);
        long burnTime = (long)fuelRemaining * (long)TileEntityFurnace.func_145952_a((ItemStack)fuelInSlot) * (long)(this.isHighPressure ? 6 : 12);
        return Collections.singleton(new ItemFuelInfo(fuelInSlot, fuelRemaining, fuelCapacity, 1, burnTime));
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        return this.createUITemplate(player).slot(this.importItems, 0, 115, 62, GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.COAL_OVERLAY_STEAM.get(this.isHighPressure)).slot(this.exportItems, 0, 115, 26, true, false, GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.DUST_OVERLAY_STEAM.get(this.isHighPressure)).progressBar(this::getFuelLeftPercent, 115, 44, 18, 18, GuiTextures.PROGRESS_BAR_BOILER_FUEL.get(this.isHighPressure), ProgressWidget.MoveType.VERTICAL).build(this.getHolder(), player);
    }
}

