/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam.boiler;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IFuelInfo;
import gregtech.api.capability.IFuelable;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidFuelInfo;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.unification.material.Materials;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.steam.boiler.SteamBoiler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SteamLavaBoiler
extends SteamBoiler
implements IFuelable {
    private FluidTank fuelFluidTank;
    private final Map<Fluid, Integer> boilerFuels = this.getBoilerFuels();

    public SteamLavaBoiler(ResourceLocation metaTileEntityId, boolean isHighPressure) {
        super(metaTileEntityId, isHighPressure, Textures.LAVA_BOILER_OVERLAY);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new SteamLavaBoiler(this.metaTileEntityId, this.isHighPressure);
    }

    @Override
    protected int getBaseSteamOutput() {
        return this.isHighPressure ? 600 : 240;
    }

    private Map<Fluid, Integer> getBoilerFuels() {
        HashMap<Fluid, Integer> fuels = new HashMap<Fluid, Integer>();
        fuels.put(Materials.Lava.getFluid(), 100);
        fuels.put(Materials.Creosote.getFluid(), 250);
        return fuels;
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        FluidTankList superHandler = super.createImportFluidHandler();
        this.fuelFluidTank = new FilteredFluidHandler(16000).setFillPredicate(fs -> this.boilerFuels.containsKey(fs.getFluid()));
        return new FluidTankList(false, superHandler, new IFluidTank[]{this.fuelFluidTank});
    }

    @Override
    protected void tryConsumeNewFuel() {
        for (Map.Entry<Fluid, Integer> fuels : this.boilerFuels.entrySet()) {
            if (this.fuelFluidTank.getFluid() == null || !this.fuelFluidTank.getFluid().isFluidEqual(new FluidStack(fuels.getKey(), fuels.getValue().intValue())) || this.fuelFluidTank.getFluidAmount() < fuels.getValue()) continue;
            this.fuelFluidTank.drain(fuels.getValue().intValue(), true);
            this.setFuelMaxBurnTime(100);
        }
    }

    @Override
    protected int getCooldownInterval() {
        return this.isHighPressure ? 40 : 45;
    }

    @Override
    protected int getCoolDownRate() {
        return 1;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        T result = super.getCapability(capability, side);
        if (result != null) {
            return result;
        }
        if (capability == GregtechCapabilities.CAPABILITY_FUELABLE) {
            return (T)GregtechCapabilities.CAPABILITY_FUELABLE.cast((Object)this);
        }
        return null;
    }

    @Override
    public Collection<IFuelInfo> getFuels() {
        FluidStack fuel = this.fuelFluidTank.drain(Integer.MAX_VALUE, false);
        if (fuel == null || fuel.amount == 0) {
            return Collections.emptySet();
        }
        int fuelRemaining = fuel.amount;
        int fuelCapacity = this.fuelFluidTank.getCapacity();
        long burnTime = (long)fuelRemaining * (long)(this.isHighPressure ? 6 : 12);
        return Collections.singleton(new FluidFuelInfo(fuel, fuelRemaining, fuelCapacity, this.boilerFuels.get(fuel.getFluid()), burnTime));
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createUITemplate(entityPlayer).widget(new TankWidget((IFluidTank)this.fuelFluidTank, 119, 26, 10, 54).setBackgroundTexture(GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure))).build(this.getHolder(), entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(float x, float y, float z) {
        super.randomDisplayTick(x, y, z);
        if (GTValues.RNG.nextFloat() < 0.3f) {
            this.getWorld().func_175688_a(EnumParticleTypes.LAVA, (double)(x + GTValues.RNG.nextFloat()), (double)y, (double)(z + GTValues.RNG.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

