/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IActiveOutputSide;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.ItemHandlerProxy;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.custom.QuantumStorageRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityQuantumChest
extends MetaTileEntity
implements ITieredMetaTileEntity,
IActiveOutputSide,
IFastRenderMetaTileEntity {
    private final int tier;
    private final long maxStoredItems;
    protected ItemStack itemStack = ItemStack.field_190927_a;
    private long itemsStoredInside = 0L;
    private boolean autoOutputItems;
    private EnumFacing outputFacing;
    private boolean allowInputFromOutputSide = false;
    private static final String NBT_ITEMSTACK = "ItemStack";
    private static final String NBT_PARTIALSTACK = "PartialStack";
    private static final String NBT_ITEMCOUNT = "ItemAmount";
    protected IItemHandler outputItemInventory;
    private ItemHandlerList combinedInventory;
    private ItemStack previousStack;
    private long previousStackSize;

    public MetaTileEntityQuantumChest(ResourceLocation metaTileEntityId, int tier, long maxStoredItems) {
        super(metaTileEntityId);
        this.tier = tier;
        this.maxStoredItems = maxStoredItems;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityQuantumChest(this.metaTileEntityId, this.tier, this.maxStoredItems);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        Textures.QUANTUM_STORAGE_RENDERER.renderMachine(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))), this.getFrontFacing(), this.tier);
        Textures.QUANTUM_CHEST_OVERLAY.renderSided(EnumFacing.UP, renderState, translation, pipeline);
        if (this.outputFacing != null) {
            Textures.PIPE_OUT_OVERLAY.renderSided(this.outputFacing, renderState, translation, pipeline);
            if (this.isAutoOutputItems()) {
                Textures.ITEM_OUTPUT_OVERLAY.renderSided(this.outputFacing, renderState, translation, pipeline);
            }
        }
    }

    @Override
    public void renderMetaTileEntity(double x, double y, double z, float partialTicks) {
        QuantumStorageRenderer.renderChestStack(x, y, z, this, this.itemStack, this.itemsStoredInside, partialTicks);
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.VOLTAGE_CASINGS[this.tier].getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    public int getActualComparatorValue() {
        float f = (float)this.itemsStoredInside / ((float)this.maxStoredItems * 1.0f);
        return MathHelper.func_76141_d((float)(f * 14.0f)) + (this.itemsStoredInside > 0L ? 1 : 0);
    }

    @Override
    public void update() {
        super.update();
        EnumFacing currentOutputFacing = this.getOutputFacing();
        if (!this.getWorld().field_72995_K) {
            if (this.itemsStoredInside < this.maxStoredItems) {
                ItemStack inputStack = this.importItems.getStackInSlot(0);
                ItemStack outputStack = this.exportItems.getStackInSlot(0);
                if ((outputStack.func_190926_b() || outputStack.func_77969_a(inputStack) && ItemStack.func_77970_a((ItemStack)inputStack, (ItemStack)outputStack)) && !inputStack.func_190926_b() && (this.itemStack.func_190926_b() || MetaTileEntityQuantumChest.areItemStackIdentical(this.itemStack, inputStack))) {
                    int amountOfItemsToInsert = (int)Math.min((long)inputStack.func_190916_E(), this.maxStoredItems - this.itemsStoredInside);
                    if (this.itemsStoredInside == 0L || this.itemStack.func_190926_b()) {
                        this.itemStack = GTUtility.copyAmount(1, inputStack);
                    }
                    inputStack.func_190918_g(amountOfItemsToInsert);
                    this.importItems.setStackInSlot(0, inputStack);
                    this.itemsStoredInside += (long)amountOfItemsToInsert;
                    this.markDirty();
                }
            }
            if (this.itemsStoredInside > 0L && !this.itemStack.func_190926_b()) {
                ItemStack outputStack = this.exportItems.getStackInSlot(0);
                int maxStackSize = this.itemStack.func_77976_d();
                if (outputStack.func_190926_b() || MetaTileEntityQuantumChest.areItemStackIdentical(this.itemStack, outputStack) && outputStack.func_190916_E() < maxStackSize) {
                    int amountOfItemsToRemove = (int)Math.min((long)(maxStackSize - outputStack.func_190916_E()), this.itemsStoredInside);
                    if (outputStack.func_190926_b()) {
                        outputStack = GTUtility.copyAmount(amountOfItemsToRemove, this.itemStack);
                    } else {
                        outputStack.func_190917_f(amountOfItemsToRemove);
                    }
                    this.exportItems.setStackInSlot(0, outputStack);
                    this.itemsStoredInside -= (long)amountOfItemsToRemove;
                    if (this.itemsStoredInside == 0L) {
                        this.itemStack = ItemStack.field_190927_a;
                    }
                    this.markDirty();
                }
            }
            if (this.isAutoOutputItems()) {
                this.pushItemsIntoNearbyHandlers(currentOutputFacing);
            }
            if (this.previousStack == null || !MetaTileEntityQuantumChest.areItemStackIdentical(this.previousStack, this.itemStack)) {
                this.writeCustomData(3, buf -> buf.func_150788_a(this.itemStack));
                this.previousStack = this.itemStack;
            }
            if (this.previousStackSize != this.itemsStoredInside) {
                this.writeCustomData(14, buf -> buf.writeLong(this.itemsStoredInside));
                this.previousStackSize = this.itemsStoredInside;
            }
        }
    }

    private static boolean areItemStackIdentical(ItemStack first, ItemStack second) {
        return ItemStack.func_179545_c((ItemStack)first, (ItemStack)second) && ItemStack.func_77970_a((ItemStack)first, (ItemStack)second);
    }

    protected void addDisplayInformation(List<ITextComponent> textList) {
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.quantum_chest.items_stored", new Object[0]));
        textList.add((ITextComponent)new TextComponentString(String.format("%,d", this.itemsStoredInside)));
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.quantum_chest.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_total", (Object[])new Object[]{this.maxStoredItems}));
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            String translationKey = null;
            long count = 0L;
            if (compound.func_74764_b(NBT_ITEMSTACK)) {
                translationKey = new ItemStack(compound.func_74775_l(NBT_ITEMSTACK)).func_82833_r();
                count = compound.func_74763_f(NBT_ITEMCOUNT);
            } else if (compound.func_74764_b(NBT_PARTIALSTACK)) {
                ItemStack tempStack = new ItemStack(compound.func_74775_l(NBT_PARTIALSTACK));
                translationKey = tempStack.func_82833_r();
                count = tempStack.func_190916_E();
            }
            if (translationKey != null) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_stored", (Object[])new Object[]{I18n.func_135052_a((String)translationKey, (Object[])new Object[0]), count}));
            }
        }
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.auto_output_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.itemInventory = new QuantumChestItemHandler();
        this.outputItemInventory = new ItemHandlerProxy((IItemHandler)new ItemStackHandler(0), (IItemHandler)this.exportItems);
        ArrayList<IItemHandler> temp = new ArrayList<IItemHandler>();
        temp.add(this.outputItemInventory);
        temp.add(this.itemInventory);
        this.combinedInventory = new ItemHandlerList(temp);
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                NBTTagCompound compound = stack.func_77978_p();
                if (compound == null) {
                    return true;
                }
                return !compound.func_150297_b(MetaTileEntityQuantumChest.NBT_ITEMSTACK, 10) && !compound.func_150297_b("Fluid", 10);
            }
        };
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        NBTTagCompound tagCompound = super.writeToNBT(data);
        data.func_74768_a("OutputFacing", this.getOutputFacing().func_176745_a());
        data.func_74757_a("AutoOutputItems", this.autoOutputItems);
        data.func_74757_a("AllowInputFromOutputSide", this.allowInputFromOutputSide);
        if (!this.itemStack.func_190926_b() && this.itemsStoredInside > 0L) {
            tagCompound.func_74782_a(NBT_ITEMSTACK, (NBTBase)this.itemStack.func_77955_b(new NBTTagCompound()));
            tagCompound.func_74772_a(NBT_ITEMCOUNT, this.itemsStoredInside);
        }
        return tagCompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.outputFacing = EnumFacing.field_82609_l[data.func_74762_e("OutputFacing")];
        this.autoOutputItems = data.func_74767_n("AutoOutputItems");
        this.allowInputFromOutputSide = data.func_74767_n("AllowInputFromOutputSide");
        if (data.func_150297_b(NBT_ITEMSTACK, 10)) {
            this.itemStack = new ItemStack(data.func_74775_l(NBT_ITEMSTACK));
            if (!this.itemStack.func_190926_b()) {
                this.itemsStoredInside = data.func_74763_f(NBT_ITEMCOUNT);
            }
        }
    }

    @Override
    public void initFromItemStackData(NBTTagCompound itemStack) {
        super.initFromItemStackData(itemStack);
        if (itemStack.func_150297_b(NBT_ITEMSTACK, 10)) {
            this.itemStack = new ItemStack(itemStack.func_74775_l(NBT_ITEMSTACK));
            if (!this.itemStack.func_190926_b()) {
                this.itemsStoredInside = itemStack.func_74763_f(NBT_ITEMCOUNT);
            }
        } else if (itemStack.func_150297_b(NBT_PARTIALSTACK, 10)) {
            this.exportItems.setStackInSlot(0, new ItemStack(itemStack.func_74775_l(NBT_PARTIALSTACK)));
        }
    }

    @Override
    public void writeItemStackData(NBTTagCompound itemStack) {
        super.writeItemStackData(itemStack);
        if (!this.itemStack.func_190926_b()) {
            itemStack.func_74782_a(NBT_ITEMSTACK, (NBTBase)this.itemStack.func_77955_b(new NBTTagCompound()));
            itemStack.func_74772_a(NBT_ITEMCOUNT, this.itemsStoredInside + (long)this.exportItems.getStackInSlot(0).func_190916_E());
        } else {
            ItemStack partialStack = this.exportItems.extractItem(0, 64, false);
            if (!partialStack.func_190926_b()) {
                itemStack.func_74782_a(NBT_PARTIALSTACK, (NBTBase)partialStack.func_77955_b(new NBTTagCompound()));
            }
        }
        this.itemStack = ItemStack.field_190927_a;
        this.itemsStoredInside = 0L;
        this.exportItems.setStackInSlot(0, ItemStack.field_190927_a);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.defaultBuilder();
        int leftButtonStartX = 7;
        builder.image(7, 16, 81, 55, GuiTextures.DISPLAY);
        builder.widget(new AdvancedTextWidget(11, 20, this::addDisplayInformation, 0xFFFFFF));
        return builder.label(6, 6, this.getMetaFullName()).widget(new SlotWidget((IItemHandler)this.importItems, 0, 90, 17, true, true).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY)).widget(new SlotWidget((IItemHandler)this.exportItems, 0, 90, 54, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.OUT_SLOT_OVERLAY)).widget(new ToggleButtonWidget(leftButtonStartX, 53, 18, 18, GuiTextures.BUTTON_ITEM_OUTPUT, this::isAutoOutputItems, this::setAutoOutputItems).shouldUseBaseBackground().setTooltipText("gregtech.gui.item_auto_output.tooltip", new Object[0])).bindPlayerInventory(entityPlayer.field_71071_by).build(this.getHolder(), entityPlayer);
    }

    public EnumFacing getOutputFacing() {
        return this.outputFacing == null ? this.frontFacing.func_176734_d() : this.outputFacing;
    }

    public void setOutputFacing(EnumFacing outputFacing) {
        this.outputFacing = outputFacing;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(100, buf -> buf.writeByte(outputFacing.func_176745_a()));
            this.markDirty();
        }
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            if (this.getOutputFacing() == facing || this.getFrontFacing() == facing) {
                return false;
            }
            if (!this.getWorld().field_72995_K) {
                this.setOutputFacing(facing);
            }
            return true;
        }
        return super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeByte(this.getOutputFacing().func_176745_a());
        buf.writeBoolean(this.autoOutputItems);
        buf.func_150788_a(this.itemStack);
        buf.writeLong(this.itemsStoredInside);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
        this.autoOutputItems = buf.readBoolean();
        try {
            this.itemStack = buf.func_150791_c();
        }
        catch (IOException ignored) {
            GTLog.logger.warn("Failed to load item from NBT in a quantum chest at " + this.getPos() + " on initial server/client sync");
        }
        this.itemsStoredInside = buf.readLong();
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return super.isValidFrontFacing(facing) && facing != this.outputFacing;
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 100) {
            this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
            this.scheduleRenderUpdate();
        } else if (dataId == 101) {
            this.autoOutputItems = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == 3) {
            try {
                this.itemStack = buf.func_150791_c();
            }
            catch (IOException e) {
                GTLog.logger.error("Failed to read item stack in a quantum chest!");
            }
        } else if (dataId == 14) {
            this.itemsStoredInside = buf.readLong();
        }
    }

    public void setAutoOutputItems(boolean autoOutputItems) {
        this.autoOutputItems = autoOutputItems;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(101, buf -> buf.writeBoolean(autoOutputItems));
            this.markDirty();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_ACTIVE_OUTPUT_SIDE) {
            if (side == this.getOutputFacing()) {
                return (T)GregtechTileCapabilities.CAPABILITY_ACTIVE_OUTPUT_SIDE.cast((Object)this);
            }
            return null;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.combinedInventory);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void setFrontFacing(EnumFacing frontFacing) {
        super.setFrontFacing(frontFacing);
        if (this.outputFacing == null) {
            this.setOutputFacing(frontFacing.func_176734_d());
        }
    }

    @Override
    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    @Override
    public boolean isAutoOutputFluids() {
        return false;
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return this.allowInputFromOutputSide;
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return false;
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        MetaTileEntityQuantumChest.clearInventory(itemBuffer, this.importItems);
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        EnumFacing hitFacing = ICoverable.determineGridSideHit((RayTraceResult)hitResult);
        if (facing == this.getOutputFacing() || hitFacing == this.getOutputFacing() && playerIn.func_70093_af()) {
            if (!this.getWorld().field_72995_K) {
                if (this.isAllowInputFromOutputSideItems()) {
                    this.setAllowInputFromOutputSide(false);
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.input_from_output_side.disallow", new Object[0]));
                } else {
                    this.setAllowInputFromOutputSide(true);
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.input_from_output_side.allow", new Object[0]));
                }
            }
            return true;
        }
        return super.onScrewdriverClick(playerIn, hand, facing, hitResult);
    }

    public void setAllowInputFromOutputSide(boolean allowInputFromOutputSide) {
        this.allowInputFromOutputSide = allowInputFromOutputSide;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.getPos());
    }

    @Override
    public boolean needsSneakToRotate() {
        return true;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    private class QuantumChestItemHandler
    implements IItemHandler {
        private QuantumChestItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            ItemStack itemStack = MetaTileEntityQuantumChest.this.itemStack;
            long itemsStored = MetaTileEntityQuantumChest.this.itemsStoredInside;
            if (itemStack.func_190926_b() || itemsStored == 0L) {
                return ItemStack.field_190927_a;
            }
            ItemStack resultStack = itemStack.func_77946_l();
            resultStack.func_190920_e((int)itemsStored);
            return resultStack;
        }

        public int getSlotLimit(int slot) {
            return (int)MetaTileEntityQuantumChest.this.maxStoredItems;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            int extractedAmount = (int)Math.min((long)amount, MetaTileEntityQuantumChest.this.itemsStoredInside);
            if (MetaTileEntityQuantumChest.this.itemStack.func_190926_b() || extractedAmount == 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack extractedStack = MetaTileEntityQuantumChest.this.itemStack.func_77946_l();
            extractedStack.func_190920_e(extractedAmount);
            if (!simulate) {
                MetaTileEntityQuantumChest metaTileEntityQuantumChest = MetaTileEntityQuantumChest.this;
                metaTileEntityQuantumChest.itemsStoredInside = metaTileEntityQuantumChest.itemsStoredInside - (long)extractedAmount;
                if (MetaTileEntityQuantumChest.this.itemsStoredInside == 0L) {
                    MetaTileEntityQuantumChest.this.itemStack = ItemStack.field_190927_a;
                }
            }
            return extractedStack;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (MetaTileEntityQuantumChest.this.itemsStoredInside > 0L && !MetaTileEntityQuantumChest.this.itemStack.func_190926_b() && !MetaTileEntityQuantumChest.areItemStackIdentical(MetaTileEntityQuantumChest.this.itemStack, stack)) {
                return stack;
            }
            ItemStack exportItems = MetaTileEntityQuantumChest.this.getExportItems().getStackInSlot(0);
            boolean insertMatching = MetaTileEntityQuantumChest.areItemStackIdentical(stack, exportItems);
            if (!insertMatching) {
                return MetaTileEntityQuantumChest.this.importItems.insertItem(0, stack, simulate);
            }
            int spaceInExport = Math.abs(exportItems.func_190916_E() - exportItems.func_77976_d());
            int amountInsertedIntoExport = Math.min(spaceInExport, stack.func_190916_E());
            if (amountInsertedIntoExport >= stack.func_190916_E()) {
                return MetaTileEntityQuantumChest.this.exportItems.insertItem(0, stack, simulate);
            }
            long amountLeftInChest = MetaTileEntityQuantumChest.this.itemStack.func_190926_b() ? MetaTileEntityQuantumChest.this.maxStoredItems : MetaTileEntityQuantumChest.this.maxStoredItems - MetaTileEntityQuantumChest.this.itemsStoredInside;
            int insertedAmount = (int)Math.min((long)(stack.func_190916_E() - amountInsertedIntoExport), amountLeftInChest);
            ItemStack remainingStack = ItemStack.field_190927_a;
            if (stack.func_190916_E() - amountInsertedIntoExport > insertedAmount) {
                remainingStack = stack.func_77946_l();
                remainingStack.func_190920_e(stack.func_190916_E() - insertedAmount);
            }
            if (!simulate) {
                if (MetaTileEntityQuantumChest.this.itemStack.func_190926_b()) {
                    MetaTileEntityQuantumChest.this.itemStack = stack.func_77946_l();
                    MetaTileEntityQuantumChest.this.itemsStoredInside = insertedAmount;
                } else {
                    MetaTileEntityQuantumChest metaTileEntityQuantumChest = MetaTileEntityQuantumChest.this;
                    metaTileEntityQuantumChest.itemsStoredInside = metaTileEntityQuantumChest.itemsStoredInside + (long)insertedAmount;
                }
            }
            return remainingStack;
        }
    }
}

