/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.cable;

import gregtech.api.GTValues;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.pipenet.block.material.ItemBlockMaterialPipe;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.cable.Insulation;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockCable
extends ItemBlockMaterialPipe<Insulation, WireProperties> {
    public ItemBlockCable(BlockCable block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        WireProperties wireProperties = (WireProperties)this.blockPipe.createItemProperties(stack);
        byte tier = GTUtility.getTierByVoltage(wireProperties.getVoltage());
        if (wireProperties.isSuperconductor()) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.cable.superconductor", (Object[])new Object[]{GTValues.VN[tier]}));
        }
        tooltip.add(I18n.func_135052_a((String)"gregtech.cable.voltage", (Object[])new Object[]{wireProperties.getVoltage(), GTValues.VNF[tier]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.cable.amperage", (Object[])new Object[]{wireProperties.getAmperage()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.cable.loss_per_block", (Object[])new Object[]{wireProperties.getLossPerBlock()}));
        if (ConfigHolder.misc.debug) {
            tooltip.add("MetaItem Id: " + ((BlockMaterialPipe)this.blockPipe).getPrefix().name + BlockMaterialPipe.getItemMaterial(stack).toCamelCaseString());
        }
    }
}

