/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.cable.net;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.common.pipelike.cable.net.EnergyNet;
import gregtech.common.pipelike.cable.net.RoutePath;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import java.util.Objects;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EnergyNetHandler
implements IEnergyContainer {
    private EnergyNet net;
    private boolean transfer;
    private final TileEntityCable cable;
    private final EnumFacing facing;

    public EnergyNetHandler(EnergyNet net, TileEntityCable cable, EnumFacing facing) {
        this.net = Objects.requireNonNull(net);
        this.cable = Objects.requireNonNull(cable);
        this.facing = facing;
    }

    public void updateNetwork(EnergyNet net) {
        this.net = net;
    }

    public EnergyNet getNet() {
        return this.net;
    }

    @Override
    public long getInputPerSec() {
        return this.net.getEnergyFluxPerSec();
    }

    @Override
    public long getOutputPerSec() {
        return this.net.getEnergyFluxPerSec();
    }

    @Override
    public long getEnergyCanBeInserted() {
        return this.transfer ? 0L : this.getEnergyCapacity();
    }

    @Override
    public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
        if (this.transfer) {
            return 0L;
        }
        if (side == null) {
            if (this.facing == null) {
                return 0L;
            }
            side = this.facing;
        }
        long amperesUsed = 0L;
        for (RoutePath path : this.net.getNetData(this.cable.func_174877_v())) {
            EnumFacing facing;
            IEnergyContainer dest;
            if (path.getMaxLoss() >= voltage || GTUtility.arePosEqual(this.cable.func_174877_v(), path.getPipePos()) && side == path.getFaceToHandler() || (dest = path.getHandler(this.cable.func_145831_w())) == null || !dest.inputsEnergy(facing = path.getFaceToHandler().func_176734_d()) || dest.getEnergyCanBeInserted() <= 0L) continue;
            long pathVoltage = voltage - path.getMaxLoss();
            boolean cableBroken = false;
            for (TileEntityCable cable : path.getPath()) {
                if (cable.getMaxVoltage() >= voltage) continue;
                int heat = (int)(Math.log(GTUtility.getTierByVoltage(voltage) - GTUtility.getTierByVoltage(cable.getMaxVoltage())) * 45.0 + 36.5);
                cable.applyHeat(heat);
                cableBroken = cable.func_145837_r();
                if (cableBroken) break;
                pathVoltage = Math.min(cable.getMaxVoltage(), pathVoltage);
            }
            if (cableBroken) continue;
            this.transfer = true;
            long amps = dest.acceptEnergyFromNetwork(facing, pathVoltage, amperage - amperesUsed);
            this.transfer = false;
            if (amps == 0L) continue;
            amperesUsed += amps;
            long voltageTraveled = voltage;
            for (TileEntityCable cable : path.getPath()) {
                if ((voltageTraveled -= (long)((WireProperties)cable.getNodeData()).getLossPerBlock()) <= 0L) break;
                if (cable.func_145837_r()) continue;
                cable.incrementAmperage(amps, voltageTraveled);
            }
            if (amperage != amperesUsed) continue;
            break;
        }
        this.net.addEnergyFluxPerSec(amperesUsed * voltage);
        return amperesUsed;
    }

    private void burnCable(World world, BlockPos pos) {
        world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        if (!world.field_72995_K) {
            ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5 + world.field_73012_v.nextInt(3), 0.0, 0.0, 0.0, 0.1, new int[0]);
        }
    }

    @Override
    public long getInputAmperage() {
        return ((WireProperties)this.cable.getNodeData()).getAmperage();
    }

    @Override
    public long getInputVoltage() {
        return ((WireProperties)this.cable.getNodeData()).getVoltage();
    }

    @Override
    public long getEnergyCapacity() {
        return this.getInputVoltage() * this.getInputAmperage();
    }

    @Override
    public long changeEnergy(long energyToAdd) {
        GTLog.logger.fatal("Do not use changeEnergy() for cables! Use acceptEnergyFromNetwork()");
        return this.acceptEnergyFromNetwork(this.facing == null ? EnumFacing.UP : this.facing, energyToAdd / this.getInputAmperage(), energyToAdd / this.getInputVoltage()) * this.getInputVoltage();
    }

    @Override
    public boolean outputsEnergy(EnumFacing side) {
        return true;
    }

    @Override
    public boolean inputsEnergy(EnumFacing side) {
        return true;
    }

    @Override
    public long getEnergyStored() {
        return 0L;
    }

    @Override
    public boolean isOneProbeHidden() {
        return true;
    }
}

