/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe;

import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.pipenet.block.material.ItemBlockMaterialPipe;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.ConfigHolder;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockFluidPipe
extends ItemBlockMaterialPipe<FluidPipeType, FluidPipeProperties> {
    public ItemBlockFluidPipe(BlockFluidPipe block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        FluidPipeProperties pipeProperties = (FluidPipeProperties)this.blockPipe.createItemProperties(stack);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{pipeProperties.getThroughput()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.capacity", (Object[])new Object[]{pipeProperties.getThroughput() * 20}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.max_temperature", (Object[])new Object[]{pipeProperties.getMaxFluidTemperature()}));
        if (pipeProperties.getTanks() > 1) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.channels", (Object[])new Object[]{pipeProperties.getTanks()}));
        }
        if (TooltipHelper.isShiftDown()) {
            if (pipeProperties.isGasProof()) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.gas_proof", (Object[])new Object[0]));
            } else if (ModHandler.isMaterialWood(BlockMaterialPipe.getItemMaterial(stack))) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.not_gas_proof", (Object[])new Object[0]));
            }
            if (pipeProperties.isAcidProof()) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.acid_proof", (Object[])new Object[0]));
            }
            if (pipeProperties.isCryoProof()) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.cryo_proof", (Object[])new Object[0]));
            }
            if (pipeProperties.isPlasmaProof()) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.plasma_proof", (Object[])new Object[0]));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tooltip.fluid_pipe_hold_shift", (Object[])new Object[0]));
        }
        if (ConfigHolder.misc.debug) {
            tooltip.add("MetaItem Id: " + ((BlockMaterialPipe)this.blockPipe).getPrefix().name + BlockMaterialPipe.getItemMaterial(stack).toCamelCaseString());
        }
    }
}

