/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe.net;

import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipe;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipeTickable;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class PipeTankList
implements IFluidHandler,
Iterable<FluidTank> {
    private final TileEntityFluidPipeTickable pipe;
    private final FluidTank[] tanks;
    private IFluidTankProperties[] properties;
    private final EnumFacing facing;

    public PipeTankList(TileEntityFluidPipe pipe, EnumFacing facing, FluidTank ... fluidTanks) {
        this.tanks = fluidTanks;
        this.pipe = (TileEntityFluidPipeTickable)pipe;
        this.facing = facing;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.properties == null) {
            this.properties = new IFluidTankProperties[this.tanks.length];
            for (int i = 0; i < this.tanks.length; ++i) {
                this.properties[i] = new FluidTankPropertiesWrapper(this.tanks[i]);
            }
        }
        return this.properties;
    }

    private int findChannel(FluidStack stack) {
        if (stack == null || this.tanks == null) {
            return -1;
        }
        int empty = -1;
        for (int i = this.tanks.length - 1; i >= 0; --i) {
            FluidStack f = this.tanks[i].getFluid();
            if (f == null) {
                empty = i;
                continue;
            }
            if (!f.isFluidEqual(stack)) continue;
            return i;
        }
        return empty;
    }

    public int fill(FluidStack resource, boolean doFill) {
        int channel;
        if (this.pipe.isFaceBlocked(this.facing) || resource == null || resource.amount <= 0 || (channel = this.findChannel(resource)) < 0) {
            return 0;
        }
        return this.fill(resource, doFill, channel);
    }

    private int fullCapacity() {
        return this.tanks.length * this.pipe.getCapacityPerTank();
    }

    private int fill(FluidStack resource, boolean doFill, int channel) {
        int toAdd;
        if (channel >= this.tanks.length) {
            return 0;
        }
        FluidTank tank = this.tanks[channel];
        FluidStack currentFluid = tank.getFluid();
        if (currentFluid == null || currentFluid.amount <= 0) {
            FluidStack newFluid = resource.copy();
            newFluid.amount = Math.min(this.pipe.getCapacityPerTank(), newFluid.amount);
            if (doFill) {
                tank.setFluid(newFluid);
                this.pipe.receivedFrom(this.facing);
                this.pipe.checkAndDestroy(newFluid);
            }
            return newFluid.amount;
        }
        if (currentFluid.isFluidEqual(resource) && (toAdd = Math.min(tank.getCapacity() - currentFluid.amount, resource.amount)) > 0) {
            if (doFill) {
                currentFluid.amount += toAdd;
                this.pipe.receivedFrom(this.facing);
                this.pipe.checkAndDestroy(currentFluid);
            }
            return toAdd;
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        for (FluidTank tank : this.tanks) {
            FluidStack drained = tank.drain(maxDrain, doDrain);
            if (drained == null) continue;
            return drained;
        }
        return null;
    }

    @Nullable
    public FluidStack drain(FluidStack fluidStack, boolean doDrain) {
        if (fluidStack == null || fluidStack.amount <= 0) {
            return null;
        }
        fluidStack = fluidStack.copy();
        for (FluidTank tank : this.tanks) {
            FluidStack drained = tank.drain(fluidStack, doDrain);
            if (drained == null) continue;
            return drained;
        }
        return null;
    }

    @Override
    @Nonnull
    public Iterator<FluidTank> iterator() {
        return Arrays.stream(this.tanks).iterator();
    }
}

