/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.itempipe.net;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.ICoverable;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.api.util.FacingPos;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.CoverItemFilter;
import gregtech.common.covers.CoverRoboticArm;
import gregtech.common.covers.DistributionMode;
import gregtech.common.covers.ItemFilterMode;
import gregtech.common.pipelike.itempipe.net.ItemPipeNet;
import gregtech.common.pipelike.itempipe.tile.TileEntityItemPipe;
import gregtech.common.pipelike.itempipe.tile.TileEntityItemPipeTickable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemNetHandler
implements IItemHandler {
    private ItemPipeNet net;
    private TileEntityItemPipe pipe;
    private TileEntityItemPipeTickable tickingPipe;
    private final World world;
    private final EnumFacing facing;
    private final Map<FacingPos, Integer> simulatedTransfersGlobalRoundRobin = new HashMap<FacingPos, Integer>();
    private int simulatedTransfers = 0;
    private final ItemStackHandler testHandler = new ItemStackHandler(1);

    public ItemNetHandler(ItemPipeNet net, TileEntityItemPipe pipe, EnumFacing facing) {
        this.net = net;
        this.pipe = pipe;
        this.facing = facing;
        this.world = pipe.func_145831_w();
    }

    public void updateNetwork(ItemPipeNet net) {
        this.net = net;
    }

    public ItemPipeNet getNet() {
        return this.net;
    }

    private void copyTransferred() {
        this.simulatedTransfers = this.tickingPipe.getTransferredItems();
        this.simulatedTransfersGlobalRoundRobin.clear();
        this.simulatedTransfersGlobalRoundRobin.putAll(this.pipe.getTransferred());
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return stack;
        }
        if (this.tickingPipe == null) {
            this.tickingPipe = (TileEntityItemPipeTickable)this.pipe.setSupportsTicking();
            this.pipe = this.tickingPipe;
        }
        if (this.net == null || this.pipe == null || this.pipe.func_145837_r() || this.pipe.isFaceBlocked(this.facing)) {
            return stack;
        }
        this.copyTransferred();
        CoverBehavior pipeCover = this.getCoverOnPipe(this.pipe.getPipePos(), this.facing);
        CoverBehavior tileCover = this.getCoverOnNeighbour(this.pipe.getPipePos(), this.facing);
        boolean pipeConveyor = pipeCover instanceof CoverConveyor;
        boolean tileConveyor = tileCover instanceof CoverConveyor;
        if (pipeConveyor && tileConveyor) {
            return stack;
        }
        if (tileCover != null && !ItemNetHandler.checkImportCover(tileCover, false, stack)) {
            return stack;
        }
        if (!pipeConveyor && !tileConveyor) {
            return this.insertFirst(stack, simulate);
        }
        CoverConveyor conveyor = (CoverConveyor)(pipeConveyor ? pipeCover : tileCover);
        if (conveyor.getConveyorMode() == (pipeConveyor ? CoverConveyor.ConveyorMode.IMPORT : CoverConveyor.ConveyorMode.EXPORT)) {
            boolean roundRobinGlobal;
            boolean bl = roundRobinGlobal = conveyor.getDistributionMode() == DistributionMode.ROUND_ROBIN_GLOBAL;
            if (roundRobinGlobal || conveyor.getDistributionMode() == DistributionMode.ROUND_ROBIN_PRIO) {
                return this.insertRoundRobin(stack, simulate, roundRobinGlobal);
            }
        }
        return this.insertFirst(stack, simulate);
    }

    public static boolean checkImportCover(CoverBehavior cover, boolean onPipe, ItemStack stack) {
        if (cover == null) {
            return true;
        }
        if (cover instanceof CoverItemFilter) {
            CoverItemFilter filter = (CoverItemFilter)cover;
            return filter.getFilterMode() != ItemFilterMode.FILTER_BOTH && (filter.getFilterMode() != ItemFilterMode.FILTER_INSERT || !onPipe) && (filter.getFilterMode() != ItemFilterMode.FILTER_EXTRACT || onPipe) || filter.testItemStack(stack);
        }
        return true;
    }

    public ItemStack insertFirst(ItemStack stack, boolean simulate) {
        for (ItemPipeNet.Inventory inv : this.net.getNetData(this.pipe.getPipePos(), this.facing)) {
            stack = this.insert(inv, stack, simulate);
            if (!stack.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public ItemStack insertRoundRobin(ItemStack stack, boolean simulate, boolean global) {
        List<ItemPipeNet.Inventory> handlers = this.net.getNetData(this.pipe.getPipePos(), this.facing);
        if (handlers.size() == 0) {
            return stack;
        }
        if (handlers.size() == 1) {
            return this.insert(handlers.get(0), stack, simulate);
        }
        ArrayList<ItemPipeNet.Inventory> handlersCopy = new ArrayList<ItemPipeNet.Inventory>(handlers);
        int original = stack.func_190916_E();
        if (global) {
            stack = this.insertToHandlersEnhanced(handlersCopy, stack, handlers.size(), simulate);
        } else if (!(stack = this.insertToHandlers(handlersCopy, stack, simulate)).func_190926_b() && handlersCopy.size() > 0) {
            stack = this.insertToHandlers(handlersCopy, stack, simulate);
        }
        return stack;
    }

    private ItemStack insertToHandlers(List<ItemPipeNet.Inventory> copy, ItemStack stack, boolean simulate) {
        int m;
        ListIterator<ItemPipeNet.Inventory> handlerIterator = copy.listIterator();
        int inserted = 0;
        int count = stack.func_190916_E();
        int c = count / copy.size();
        int n = m = c == 0 ? count % copy.size() : 0;
        while (handlerIterator.hasNext()) {
            ItemPipeNet.Inventory handler = (ItemPipeNet.Inventory)handlerIterator.next();
            int amount = c;
            if (m > 0) {
                ++amount;
                --m;
            }
            if ((amount = Math.min(amount, stack.func_190916_E() - inserted)) == 0) break;
            ItemStack toInsert = stack.func_77946_l();
            toInsert.func_190920_e(amount);
            int r = this.insert(handler, toInsert, simulate).func_190916_E();
            if (r < amount) {
                inserted += amount - r;
            }
            if (r == 1 && c == 0 && amount == 1) {
                ++m;
            }
            if (r <= 0) continue;
            handlerIterator.remove();
        }
        ItemStack remainder = stack.func_77946_l();
        remainder.func_190920_e(count - inserted);
        return remainder;
    }

    private ItemStack insertToHandlersEnhanced(List<ItemPipeNet.Inventory> copy, ItemStack stack, int dest, boolean simulate) {
        int nextStep;
        LinkedList<EnhancedRoundRobinData> transferred = new LinkedList<EnhancedRoundRobinData>();
        LinkedList<Integer> steps = new LinkedList<Integer>();
        int min = Integer.MAX_VALUE;
        for (ItemPipeNet.Inventory inv : copy) {
            ItemStack simStack = stack.func_77946_l();
            int ins = stack.func_190916_E() - this.insert(inv, simStack, true, true).func_190916_E();
            if (ins <= 0) continue;
            int didTransfer = this.didTransferTo(inv, simulate);
            EnhancedRoundRobinData data2 = new EnhancedRoundRobinData(inv, ins, didTransfer);
            transferred.addLast(data2);
            min = Math.min(min, didTransfer);
            if (steps.contains(didTransfer)) continue;
            steps.add(didTransfer);
        }
        if (transferred.isEmpty() || steps.isEmpty()) {
            return stack;
        }
        if (!simulate && min < Integer.MAX_VALUE) {
            this.decrementBy(min);
        }
        transferred.sort(Comparator.comparingInt(data -> ((EnhancedRoundRobinData)data).transferred));
        steps.sort(Integer::compare);
        if (((EnhancedRoundRobinData)transferred.get(0)).transferred != (Integer)steps.get(0)) {
            return stack;
        }
        int amount = stack.func_190916_E();
        int c = amount / transferred.size();
        int m = amount % transferred.size();
        ArrayList transferredCopy = new ArrayList(transferred);
        int n = nextStep = steps.isEmpty() ? -1 : (Integer)steps.pollFirst();
        block1: while (amount > 0 && !transferredCopy.isEmpty()) {
            Iterator iterator = transferredCopy.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                EnhancedRoundRobinData enhancedRoundRobinData;
                EnhancedRoundRobinData enhancedRoundRobinData2 = (EnhancedRoundRobinData)iterator.next();
                if (nextStep >= 0 && enhancedRoundRobinData2.transferred >= nextStep) break;
                int toInsert = nextStep <= 0 ? (amount <= m ? 1 : Math.min(c, amount)) : Math.min(amount, nextStep - enhancedRoundRobinData2.transferred);
                if (enhancedRoundRobinData2.toTransfer + toInsert >= enhancedRoundRobinData2.maxInsertable) {
                    enhancedRoundRobinData2.toTransfer = enhancedRoundRobinData2.maxInsertable;
                    iterator.remove();
                } else {
                    enhancedRoundRobinData = enhancedRoundRobinData2;
                    enhancedRoundRobinData.toTransfer = enhancedRoundRobinData.toTransfer + toInsert;
                }
                enhancedRoundRobinData = enhancedRoundRobinData2;
                enhancedRoundRobinData.transferred = enhancedRoundRobinData.transferred + toInsert;
                if ((amount -= toInsert) == 0) break block1;
                ++i;
            }
            for (EnhancedRoundRobinData data4 : transferredCopy) {
                if (data4.transferred >= nextStep) continue;
                continue block1;
            }
            if (steps.isEmpty()) {
                if (nextStep < 0) continue;
                c = amount / transferredCopy.size();
                m = amount % transferredCopy.size();
                nextStep = -1;
                continue;
            }
            nextStep = (Integer)steps.pollFirst();
        }
        int inserted = 0;
        for (EnhancedRoundRobinData enhancedRoundRobinData : transferred) {
            ItemStack toInsert = stack.func_77946_l();
            toInsert.func_190920_e(enhancedRoundRobinData.toTransfer);
            int ins = enhancedRoundRobinData.toTransfer - this.insert(enhancedRoundRobinData.inventory, toInsert, simulate).func_190916_E();
            inserted += ins;
            this.transferTo(enhancedRoundRobinData.inventory, simulate, ins);
        }
        ItemStack remainder = stack.func_77946_l();
        remainder.func_190918_g(inserted);
        return remainder;
    }

    public ItemStack insert(ItemPipeNet.Inventory handler, ItemStack stack, boolean simulate) {
        return this.insert(handler, stack, simulate, false);
    }

    public ItemStack insert(ItemPipeNet.Inventory handler, ItemStack stack, boolean simulate, boolean ignoreLimit) {
        int allowed;
        int n = allowed = ignoreLimit ? stack.func_190916_E() : this.checkTransferable(handler.getProperties().getTransferRate(), stack.func_190916_E(), simulate);
        if (allowed == 0 || !handler.matchesFilters(stack)) {
            return stack;
        }
        CoverBehavior pipeCover = this.getCoverOnPipe(handler.getPipePos(), handler.getFaceToHandler());
        CoverBehavior tileCover = this.getCoverOnNeighbour(handler.getPipePos(), handler.getFaceToHandler());
        if (pipeCover != null) {
            this.testHandler.setStackInSlot(0, stack.func_77946_l());
            IItemHandler itemHandler = (IItemHandler)pipeCover.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.testHandler);
            if (itemHandler == null || itemHandler != this.testHandler && (allowed = itemHandler.extractItem(0, allowed, true).func_190916_E()) <= 0) {
                this.testHandler.setStackInSlot(0, ItemStack.field_190927_a);
                return stack;
            }
            this.testHandler.setStackInSlot(0, ItemStack.field_190927_a);
        }
        IItemHandler neighbourHandler = handler.getHandler(this.world);
        if (pipeCover instanceof CoverRoboticArm && ((CoverRoboticArm)pipeCover).getConveyorMode() == CoverConveyor.ConveyorMode.EXPORT) {
            return this.insertOverRobotArm(neighbourHandler, (CoverRoboticArm)pipeCover, stack, simulate, allowed, ignoreLimit);
        }
        if (tileCover instanceof CoverRoboticArm && ((CoverRoboticArm)tileCover).getConveyorMode() == CoverConveyor.ConveyorMode.IMPORT) {
            return this.insertOverRobotArm(neighbourHandler, (CoverRoboticArm)tileCover, stack, simulate, allowed, ignoreLimit);
        }
        return this.insert(neighbourHandler, stack, simulate, allowed, ignoreLimit);
    }

    private ItemStack insert(IItemHandler handler, ItemStack stack, boolean simulate, int allowed, boolean ignoreLimit) {
        if (stack.func_190916_E() == allowed) {
            ItemStack re = GTTransferUtils.insertItem(handler, stack, simulate);
            if (!ignoreLimit) {
                this.transfer(simulate, stack.func_190916_E() - re.func_190916_E());
            }
            return re;
        }
        ItemStack toInsert = stack.func_77946_l();
        toInsert.func_190920_e(Math.min(allowed, stack.func_190916_E()));
        int r = GTTransferUtils.insertItem(handler, toInsert, simulate).func_190916_E();
        if (!ignoreLimit) {
            this.transfer(simulate, toInsert.func_190916_E() - r);
        }
        ItemStack remainder = stack.func_77946_l();
        remainder.func_190920_e(r + (stack.func_190916_E() - toInsert.func_190916_E()));
        return remainder;
    }

    public CoverBehavior getCoverOnPipe(BlockPos pos, EnumFacing handlerFacing) {
        TileEntity tile = this.pipe.func_145831_w().func_175625_s(pos);
        if (tile instanceof TileEntityItemPipe) {
            PipeCoverableImplementation coverable = ((TileEntityItemPipe)tile).getCoverableImplementation();
            return coverable.getCoverAtSide(handlerFacing);
        }
        return null;
    }

    public CoverBehavior getCoverOnNeighbour(BlockPos pos, EnumFacing handlerFacing) {
        TileEntity tile = this.pipe.func_145831_w().func_175625_s(pos.func_177972_a(handlerFacing));
        if (tile != null) {
            ICoverable coverable = (ICoverable)tile.getCapability(GregtechTileCapabilities.CAPABILITY_COVERABLE, handlerFacing.func_176734_d());
            if (coverable == null) {
                return null;
            }
            return coverable.getCoverAtSide(handlerFacing.func_176734_d());
        }
        return null;
    }

    public ItemStack insertOverRobotArm(IItemHandler handler, CoverRoboticArm arm, ItemStack stack, boolean simulate, int allowed, boolean ignoreLimit) {
        int rate;
        boolean isStackSpecific = false;
        Object index = arm.getItemFilterContainer().matchItemStack(stack);
        if (index instanceof Integer) {
            rate = arm.getItemFilterContainer().getSlotTransferLimit(index);
            isStackSpecific = true;
        } else {
            rate = arm.getItemFilterContainer().getTransferStackSize();
        }
        switch (arm.getTransferMode()) {
            case TRANSFER_ANY: {
                return this.insert(handler, stack, simulate, allowed, ignoreLimit);
            }
            case KEEP_EXACT: {
                int count = rate - ItemNetHandler.countStack(handler, stack, arm, isStackSpecific);
                if (count <= 0) {
                    return stack;
                }
                count = Math.min(allowed, Math.min(stack.func_190916_E(), count));
                return this.insert(handler, stack, simulate, count, ignoreLimit);
            }
            case TRANSFER_EXACT: {
                int max = allowed + arm.getBuffer();
                int count = Math.min(max, Math.min(rate, stack.func_190916_E()));
                if (count < rate) {
                    arm.buffer(allowed);
                    return stack;
                }
                arm.clearBuffer();
                if (this.insert(handler, stack, true, count, ignoreLimit).func_190916_E() != stack.func_190916_E() - count) {
                    return stack;
                }
                return this.insert(handler, stack, simulate, count, ignoreLimit);
            }
        }
        return stack;
    }

    public static int countStack(IItemHandler handler, ItemStack stack, CoverRoboticArm arm, boolean isStackSpecific) {
        if (arm == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack slot = handler.getStackInSlot(i);
            if (slot.func_190926_b() || !(isStackSpecific ? ItemStackHashStrategy.comparingAllButCount().equals(stack, slot) : arm.getItemFilterContainer().testItemStack(slot))) continue;
            count += slot.func_190916_E();
        }
        return count;
    }

    private int checkTransferable(float rate, int amount, boolean simulate) {
        int max = (int)((double)(rate * 64.0f) + 0.5);
        if (simulate) {
            return Math.max(0, Math.min(max - this.simulatedTransfers, amount));
        }
        return Math.max(0, Math.min(max - this.tickingPipe.getTransferredItems(), amount));
    }

    private void transfer(boolean simulate, int amount) {
        if (simulate) {
            this.simulatedTransfers += amount;
        } else {
            this.tickingPipe.transferItems(amount);
        }
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int i) {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int i) {
        return 64;
    }

    private void transferTo(ItemPipeNet.Inventory handler, boolean simulate, int amount) {
        if (simulate) {
            this.simulatedTransfersGlobalRoundRobin.merge(handler.toFacingPos(), amount, Integer::sum);
        } else {
            this.pipe.getTransferred().merge(handler.toFacingPos(), amount, Integer::sum);
        }
    }

    private boolean contains(ItemPipeNet.Inventory handler, boolean simulate) {
        return simulate ? this.simulatedTransfersGlobalRoundRobin.containsKey(handler.toFacingPos()) : this.pipe.getTransferred().containsKey(handler.toFacingPos());
    }

    private int didTransferTo(ItemPipeNet.Inventory handler, boolean simulate) {
        if (simulate) {
            return this.simulatedTransfersGlobalRoundRobin.getOrDefault(handler.toFacingPos(), 0);
        }
        return this.pipe.getTransferred().getOrDefault(handler.toFacingPos(), 0);
    }

    private void resetTransferred(boolean simulated) {
        if (simulated) {
            this.simulatedTransfersGlobalRoundRobin.clear();
        } else {
            this.pipe.resetTransferred();
        }
    }

    private void decrementBy(int amount) {
        for (Map.Entry<FacingPos, Integer> entry : this.pipe.getTransferred().entrySet()) {
            entry.setValue(entry.getValue() - amount);
        }
    }

    private static class EnhancedRoundRobinData {
        private final ItemPipeNet.Inventory inventory;
        private final int maxInsertable;
        private int transferred;
        private int toTransfer = 0;

        private EnhancedRoundRobinData(ItemPipeNet.Inventory inventory, int maxInsertable, int transferred) {
            this.maxInsertable = maxInsertable;
            this.transferred = transferred;
            this.inventory = inventory;
        }
    }
}

