/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.appstore;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.interpolate.Eases;
import gregtech.api.util.interpolate.Interpolator;
import gregtech.common.inventory.handlers.SingleItemStackHandler;
import gregtech.common.items.behaviors.TerminalBehaviour;
import gregtech.common.terminal.app.appstore.AppCardWidget;
import gregtech.common.terminal.app.appstore.AppStoreApp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.items.IItemHandler;

public class AppPageWidget
extends TerminalDialogWidget {
    private final AbstractApplication application;
    private final AppCardWidget appCardWidget;
    private final AppStoreApp store;
    private final CircleButtonWidget[] buttons;
    private int lineWidth;
    private boolean back;

    public AppPageWidget(AbstractApplication application, AppStoreApp store, AppCardWidget appCardWidget) {
        super(store.getOs(), 5, 5, 323, 222);
        this.appCardWidget = appCardWidget;
        this.application = application;
        this.store = store;
        String name = this.application.getRegistryName();
        int stage = application.getMaxTier() + 1;
        int dur = 323 / (stage + 1);
        this.buttons = new CircleButtonWidget[stage];
        for (int i = 0; i < stage; ++i) {
            int tier = i;
            this.buttons[i] = new CircleButtonWidget(dur + dur * i, 110, 6, 2, 0).setClickListener(cd -> this.buttonClicked(tier));
            this.addWidget(this.buttons[i]);
        }
        this.addWidget(new CircleButtonWidget(310, 10, 6, 1, 8).setColors(0, TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_3.getColor()).setIcon(GuiTextures.ICON_REMOVE).setHoverText("terminal.guide_editor.remove").setClickListener(cd -> this.close()));
        if (store.getOs().isRemote()) {
            int color = application.getThemeColor();
            int lightColor = color & 0xFFFFFF | 0x6F000000;
            IGuiTexture profile = application.getProfile();
            this.addWidget(new ImageWidget(10, 15, 80, 80, profile));
            for (int i = 0; i < stage; ++i) {
                List<String> demand = TerminalRegistry.getAppHardwareDemand(name, i).stream().map(hw -> hw.getLocalizedName() + "(" + hw.addInformation() + ")").collect(Collectors.toList());
                demand.add(0, application.getTierInformation(i));
                this.buttons[i].setColors(0, lightColor, color).setHoverText(demand.toArray(new String[0]));
                List<ItemStack> conditions = TerminalRegistry.getAppHardwareUpgradeConditions(name, i);
                if (conditions.size() > 0) {
                    this.addWidget(new ImageWidget(dur + dur * i, 115, 1, -18 + (conditions.size() >= 4 ? 100 : conditions.size() * 25), new ColorRectTexture(-1342177281)));
                }
                for (int j = 0; j < conditions.size(); ++j) {
                    this.addWidget(new SlotWidget((IItemHandler)new SingleItemStackHandler(conditions.get(j)), 0, dur + dur * i + 25 * (j / 4) - 9, 120 + 25 * (j % 4), false, false));
                }
            }
        }
    }

    private void buttonClicked(int tier) {
        TerminalOSWidget os = this.store.getOs();
        int lastTier = !os.installedApps.contains(this.application) ? -1 : (TerminalBehaviour.isCreative(os.itemStack) ? this.application.getMaxTier() : Math.min(os.tabletNBT.func_74775_l(this.application.getRegistryName()).func_74762_e("_tier"), this.application.getMaxTier()));
        String name = this.application.getRegistryName();
        if (tier > lastTier) {
            boolean match = true;
            ArrayList<ItemStack> requirements = new ArrayList<ItemStack>();
            ItemStack missStack = null;
            if (!this.gui.entityPlayer.func_184812_l_()) {
                for (int i = lastTier + 1; i <= tier; ++i) {
                    for (ItemStack condition : TerminalRegistry.getAppHardwareUpgradeConditions(name, i)) {
                        boolean miss = true;
                        for (ItemStack requirement : requirements) {
                            if (!requirement.func_77969_a(condition)) continue;
                            requirement.func_190920_e(requirement.func_190916_E() + condition.func_190916_E());
                            miss = false;
                            break;
                        }
                        if (!miss) continue;
                        requirements.add(condition.func_77946_l());
                    }
                }
                for (ItemStack requirement : requirements) {
                    int left = requirement.func_190916_E();
                    for (ItemStack hold : this.gui.entityPlayer.field_71071_by.field_70462_a) {
                        if (!requirement.func_77969_a(hold)) continue;
                        left = hold.func_190916_E() < left ? (left -= hold.func_190916_E()) : 0;
                        if (left != 0) continue;
                        break;
                    }
                    if (left <= 0) continue;
                    missStack = requirement.func_77946_l();
                    missStack.func_190920_e(left);
                    match = false;
                    break;
                }
            }
            if (match) {
                if (os.isRemote()) {
                    this.appCardWidget.updateState(tier == this.application.getMaxTier() ? 0 : 1);
                }
                if (!this.gui.entityPlayer.func_184812_l_()) {
                    TerminalDialogWidget.showConfirmDialog(this.store.getOs(), "terminal.dialog.notice", "terminal.store.match", res -> {
                        if (res.booleanValue()) {
                            block0: for (ItemStack requirement : requirements) {
                                int left = requirement.func_190916_E();
                                for (ItemStack hold : this.gui.entityPlayer.field_71071_by.field_70462_a) {
                                    if (!requirement.func_77969_a(hold)) continue;
                                    if (hold.func_190916_E() <= left) {
                                        hold.func_190920_e(0);
                                        left -= hold.func_190916_E();
                                    } else {
                                        hold.func_190920_e(hold.func_190916_E() - left);
                                        left = 0;
                                    }
                                    if (left != 0) continue;
                                    continue block0;
                                }
                            }
                            this.updateTerminalAppTier(tier, lastTier);
                        }
                    }).open();
                } else {
                    this.updateTerminalAppTier(tier, lastTier);
                }
            } else if (this.isRemote()) {
                TerminalDialogWidget.showInfoDialog(this.store.getOs(), "terminal.dialog.notice", I18n.func_135052_a((String)"terminal.store.miss", (Object[])new Object[]{missStack.func_82833_r(), missStack.func_190916_E()})).setClientSide().open();
            }
        }
    }

    private void updateTerminalAppTier(int tier, int lastTier) {
        TerminalOSWidget os = this.store.getOs();
        os.openedApps.stream().filter(app -> app.getRegistryName().equals(this.application.getRegistryName())).findFirst().ifPresent(app -> os.closeApplication((AbstractApplication)app, os.isRemote()));
        if (lastTier == -1) {
            NBTTagList installed = os.tabletNBT.func_150295_c("_installed", 8);
            installed.func_74742_a((NBTBase)new NBTTagString(this.application.getRegistryName()));
            os.tabletNBT.func_74782_a("_installed", (NBTBase)installed);
            os.installApplication(this.application);
        }
        NBTTagCompound tag = os.tabletNBT.func_74775_l(this.application.getRegistryName());
        tag.func_74768_a("_tier", tier);
        os.tabletNBT.func_74782_a(this.application.getRegistryName(), (NBTBase)tag);
        this.lineWidth = 0;
    }

    @Override
    public void hookDrawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        GlStateManager.func_179097_i();
        AppPageWidget.drawSolidRect(x, y, width, height, this.store.darkMode ? -822083584 : -539107875);
        super.hookDrawInBackground(mouseX, mouseY, partialTicks, context);
        TerminalOSWidget os = this.store.getOs();
        int stage = !os.installedApps.contains(this.application) ? 0 : (TerminalBehaviour.isCreative(os.itemStack) ? this.application.getMaxTier() + 1 : Math.min(os.tabletNBT.func_74775_l(this.application.getRegistryName()).func_74762_e("_tier"), this.application.getMaxTier()) + 1);
        int maxStage = this.application.getMaxTier() + 1;
        int color = this.application.getThemeColor();
        int lightColor = color & 0xFFFFFF | 0x6F000000;
        int dur = 323 / (maxStage + 1);
        int hover = -1;
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].isMouseOverElement(mouseX, mouseY)) continue;
            hover = i;
        }
        AppPageWidget.drawSolidRect(x, y + 110 - 2, dur * stage, 4, color);
        if (stage == maxStage) {
            AppPageWidget.drawSolidRect(x + stage * dur, y + 110 - 2, dur, 4, color);
        } else {
            AppPageWidget.drawSolidRect(x + stage * dur, y + 110 - 2, dur, 4, lightColor);
        }
        int end = dur * (hover + 1 - stage);
        if (hover + 1 > stage) {
            if (this.lineWidth != end && (this.interpolator == null || this.back)) {
                this.back = false;
                this.interpolator = new Interpolator(this.lineWidth, end, (end - this.lineWidth) / 15, Eases.EaseLinear, value -> {
                    this.lineWidth = value.intValue();
                }, value -> {
                    this.interpolator = null;
                });
                this.interpolator.start();
            }
        } else if (!(this.lineWidth == 0 || this.interpolator != null && this.back)) {
            this.back = true;
            this.interpolator = new Interpolator(this.lineWidth, 0.0f, this.lineWidth / 15, Eases.EaseLinear, value -> {
                this.lineWidth = value.intValue();
            }, value -> {
                this.interpolator = null;
            });
            this.interpolator.start();
        }
        if (this.lineWidth != 0) {
            int smoothWidth = this.lineWidth;
            if (hover + 1 > stage) {
                if (this.lineWidth != end) {
                    smoothWidth = (int)((float)smoothWidth + partialTicks * (float)end / 10.0f);
                }
            } else {
                smoothWidth = (int)((float)smoothWidth - partialTicks * (float)end / 10.0f);
            }
            AppPageWidget.drawSolidRect(x + stage * dur, y + 110 - 2, smoothWidth, 4, color);
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        List description = fr.func_78271_c(this.application.getDescription(), 210);
        int fColor = this.store.darkMode ? -1 : -13421773;
        String localizedName = I18n.func_135052_a((String)this.application.getUnlocalizedName(), (Object[])new Object[0]);
        AppPageWidget.drawStringSized(localizedName, x + 100, y + 14, fColor, this.store.darkMode, 2.0f, false);
        if (AppPageWidget.isMouseOver(x + 100, y + 14, fr.func_78256_a(localizedName) * 2, fr.field_78288_b * 2, mouseX, mouseY)) {
            this.drawHoveringText(ItemStack.field_190927_a, Collections.singletonList("(" + this.application.getRegistryName() + ")"), 200, mouseX, mouseY);
        }
        for (int i = 0; i < description.size(); ++i) {
            fr.func_175065_a((String)description.get(i), (float)(x + 100), (float)(y + 35 + i * fr.field_78288_b), fColor, this.store.darkMode);
        }
        AppPageWidget.drawBorder(x + 10, y + 15, 80, 80, this.store.darkMode ? -1 : -13421773, 2);
        GlStateManager.func_179126_j();
    }
}

