/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.game.maze.widget;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.terminal.app.game.maze.MazeApp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.util.math.Vec2f;

public class MazeWidget
extends Widget {
    boolean[][] topWalls = new boolean[MazeApp.MAZE_SIZE][MazeApp.MAZE_SIZE];
    boolean[][] leftWalls = new boolean[MazeApp.MAZE_SIZE][MazeApp.MAZE_SIZE];
    boolean[][] includedSpots;
    private int squaresChecked;

    public MazeWidget() {
        super(166 - MazeApp.MAZE_SIZE * 5, 116 - MazeApp.MAZE_SIZE * 5, MazeApp.MAZE_SIZE * 10, MazeApp.MAZE_SIZE * 10);
        this.initMaze();
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        this.createBorder();
        this.createInternalLines();
    }

    public void recalculateSize() {
        this.setSelfPosition(new Position(166 - MazeApp.MAZE_SIZE * 5, 116 - MazeApp.MAZE_SIZE * 5));
        this.setSize(new Size(MazeApp.MAZE_SIZE * 10, MazeApp.MAZE_SIZE * 10));
        this.topWalls = new boolean[MazeApp.MAZE_SIZE][MazeApp.MAZE_SIZE];
        this.leftWalls = new boolean[MazeApp.MAZE_SIZE][MazeApp.MAZE_SIZE];
    }

    public void createBorder() {
        ArrayList<Vec2f> lineBuffer = new ArrayList<Vec2f>();
        lineBuffer.add(new Vec2f((float)(this.getPosition().x + 10), (float)this.getPosition().y));
        lineBuffer.add(new Vec2f((float)(this.getSize().width + this.getPosition().x), (float)this.getPosition().y));
        lineBuffer.add(new Vec2f((float)(this.getSize().width + this.getPosition().x), (float)(this.getSize().height + this.getPosition().y + 2)));
        MazeWidget.drawLines(lineBuffer, -1, -1, 4.0f);
        lineBuffer.clear();
        lineBuffer.add(new Vec2f((float)(this.getSize().width + this.getPosition().x - 10), (float)(this.getSize().height + this.getPosition().y)));
        lineBuffer.add(new Vec2f((float)this.getPosition().x, (float)(this.getSize().height + this.getPosition().y)));
        lineBuffer.add(new Vec2f((float)this.getPosition().x, (float)(this.getPosition().y - 2)));
        MazeWidget.drawLines(lineBuffer, -1, -1, 4.0f);
    }

    public boolean isThereWallAt(int x, int y, boolean onTops) {
        if (x >= MazeApp.MAZE_SIZE || y >= MazeApp.MAZE_SIZE) {
            return true;
        }
        if (x < 0 || y < 0) {
            return true;
        }
        if (x == 0 && !onTops || y == 0 && onTops) {
            return true;
        }
        if (onTops) {
            return this.topWalls[x][y];
        }
        return this.leftWalls[x][y];
    }

    public void createInternalLines() {
        for (int i = 0; i < MazeApp.MAZE_SIZE; ++i) {
            for (int j = 0; j < MazeApp.MAZE_SIZE; ++j) {
                ArrayList<Vec2f> list = new ArrayList<Vec2f>();
                if (j != 0 && this.isThereWallAt(i, j, true)) {
                    list.add(new Vec2f((float)(this.getPosition().x + 10 * i), (float)(this.getPosition().y + 10 * j)));
                    list.add(new Vec2f((float)(this.getPosition().x + 10 * (i + 1)), (float)(this.getPosition().y + 10 * j)));
                    MazeWidget.drawLines(list, -1, -1, 2.0f);
                    list.clear();
                }
                if (i == 0 || !this.isThereWallAt(i, j, false)) continue;
                list.add(new Vec2f((float)(this.getPosition().x + 10 * i), (float)(this.getPosition().y + 10 * j)));
                list.add(new Vec2f((float)(this.getPosition().x + 10 * i), (float)(this.getPosition().y + 10 * (j + 1))));
                MazeWidget.drawLines(list, -1, -1, 2.0f);
            }
        }
    }

    public void initMaze() {
        this.includedSpots = new boolean[MazeApp.MAZE_SIZE][MazeApp.MAZE_SIZE];
        for (int i = 0; i < MazeApp.MAZE_SIZE; ++i) {
            for (int j = 0; j < MazeApp.MAZE_SIZE; ++j) {
                this.leftWalls[i][j] = true;
                this.topWalls[i][j] = true;
            }
        }
        this.includedSpots[(int)(Math.random() * (double)MazeApp.MAZE_SIZE)][(int)(Math.random() * (double)MazeApp.MAZE_SIZE)] = true;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int i = 0; i < MazeApp.MAZE_SIZE * MazeApp.MAZE_SIZE; ++i) {
            positions.add(i);
        }
        Collections.shuffle(positions);
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            int position = (Integer)iterator.next();
            if (this.includedSpots[position / MazeApp.MAZE_SIZE][position % MazeApp.MAZE_SIZE]) continue;
            do {
                this.resetStuckCounter();
            } while (!this.createPath(position / MazeApp.MAZE_SIZE, position % MazeApp.MAZE_SIZE, new boolean[MazeApp.MAZE_SIZE][MazeApp.MAZE_SIZE]));
        }
    }

    public boolean createPath(int x, int y, boolean[][] walkedPaths) {
        ++this.squaresChecked;
        if (this.squaresChecked > 20000) {
            return false;
        }
        if (walkedPaths[x][y]) {
            return false;
        }
        if (this.includedSpots[x][y]) {
            return true;
        }
        this.includedSpots[x][y] = true;
        walkedPaths[x][y] = true;
        ArrayList<Integer> directions = new ArrayList<Integer>();
        if (x != 0 && !walkedPaths[x - 1][y]) {
            directions.add(0);
        }
        if (x != MazeApp.MAZE_SIZE - 1 && !walkedPaths[x + 1][y]) {
            directions.add(1);
        }
        if (y != 0 && !walkedPaths[x][y - 1]) {
            directions.add(2);
        }
        if (y != MazeApp.MAZE_SIZE - 1 && !walkedPaths[x][y + 1]) {
            directions.add(3);
        }
        Collections.shuffle(directions);
        while (directions.size() > 0) {
            int direction = (Integer)directions.get(directions.size() - 1);
            int newX = x;
            int newY = y;
            if (direction == 0) {
                --newX;
            } else if (direction == 1) {
                ++newX;
            } else if (direction == 2) {
                --newY;
            } else if (direction == 3) {
                ++newY;
            }
            if (this.createPath(newX, newY, walkedPaths)) {
                if (direction == 0) {
                    this.leftWalls[x][y] = false;
                } else if (direction == 1) {
                    this.leftWalls[x + 1][y] = false;
                } else if (direction == 2) {
                    this.topWalls[x][y] = false;
                } else if (direction == 3) {
                    this.topWalls[x][y + 1] = false;
                }
                return true;
            }
            directions.remove(directions.size() - 1);
        }
        this.includedSpots[x][y] = false;
        walkedPaths[x][y] = false;
        return false;
    }

    public void resetStuckCounter() {
        this.squaresChecked = 0;
    }
}

