/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guide.widget;

import com.google.gson.JsonObject;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.ItemStackTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.resources.URLTexture;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.terminal.app.guide.widget.GuideWidget;
import gregtech.common.terminal.app.guideeditor.widget.configurator.NumberConfigurator;
import gregtech.common.terminal.app.guideeditor.widget.configurator.SelectorConfigurator;
import gregtech.common.terminal.app.guideeditor.widget.configurator.StringConfigurator;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class ImageWidget
extends GuideWidget {
    public static final String NAME = "image";
    public String form;
    public String source;
    public int width;
    public int height;
    public transient IGuiTexture image;

    @Override
    public String getRegistryName() {
        return NAME;
    }

    @Override
    public JsonObject getTemplate(boolean isFixed) {
        JsonObject template = super.getTemplate(isFixed);
        template.addProperty("form", "resource");
        template.addProperty("source", "gregtech:textures/gui/icon/gregtech_logo.png");
        template.addProperty("width", (Number)50);
        template.addProperty("height", (Number)50);
        return template;
    }

    @Override
    public void loadConfigurator(DraggableScrollableWidgetGroup group, JsonObject config, boolean isFixed, Consumer<String> needUpdate) {
        if (!isFixed) {
            group.addWidget(new NumberConfigurator(group, config, "width").setOnUpdated(needUpdate));
            group.addWidget(new NumberConfigurator(group, config, "height").setOnUpdated(needUpdate));
        }
        group.addWidget(new SelectorConfigurator(group, config, "form", Arrays.asList("url", "item", "resource")).setOnUpdated(needUpdate));
        group.addWidget(new StringConfigurator(group, config, "source").setOnUpdated(needUpdate));
        super.loadConfigurator(group, config, isFixed, needUpdate);
    }

    @Override
    public void updateScreen() {
        if (this.image != null) {
            this.image.updateTick();
        }
    }

    @Override
    protected Widget initStream() {
        int pageWidth = this.getSize().width;
        int x = this.getSelfPosition().x;
        int y = this.getSelfPosition().y;
        if (this.page != null) {
            x = this.page.getMargin();
            pageWidth = this.page.getPageWidth() - 2 * x;
        }
        this.setSelfPosition(new Position(x + (pageWidth - Math.max(0, this.width)) / 2, y));
        return this.initFixed();
    }

    @Override
    protected Widget initFixed() {
        this.width = Math.max(0, this.width);
        this.height = Math.max(0, this.height);
        this.setSize(new Size(this.width, this.height));
        switch (this.form) {
            case "url": {
                this.image = new URLTexture(this.source);
                break;
            }
            case "item": {
                this.image = new ItemStackTexture(Item.func_111206_d((String)this.source), new Item[0]);
                break;
            }
            case "resource": {
                this.image = new TextureArea(new ResourceLocation(this.source), 0.0, 0.0, 1.0, 1.0);
            }
        }
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (this.image != null) {
            super.drawInBackground(mouseX, mouseY, partialTicks, context);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Position position = this.getPosition();
            this.image.draw(position.x, position.y, this.getSize().width, this.getSize().height);
        }
    }
}

