/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guide.widget;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.util.Size;
import gregtech.common.terminal.app.guide.widget.GuideWidgetGroup;
import gregtech.common.terminal.app.guideeditor.widget.configurator.FluidStackConfigurator;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class TankListWidget
extends GuideWidgetGroup {
    public static final String NAME = "tanks";
    public List<FluidStackInfo> fluid_list;
    protected transient Rectangle scissor;

    @Override
    public Widget initFixed() {
        int xPos;
        this.clearAllWidgets();
        ColorRectTexture background = new ColorRectTexture(0x4F000000);
        int size = this.fluid_list.size();
        int maxXSize = this.getSize().width / 18;
        if (maxXSize < 1) {
            maxXSize = 1;
            xPos = 0;
        } else {
            xPos = (this.getSize().width - Math.min(size, maxXSize) * 18) / 2;
        }
        int maxYSize = size / maxXSize + (size % maxXSize == 0 ? 0 : 1);
        for (int y = 0; y <= size / maxXSize; ++y) {
            for (int x = 0; x < maxXSize; ++x) {
                int i = x + y * maxXSize;
                if (i >= size) continue;
                FluidStack fluidStack = this.fluid_list.get(i).getInstance();
                TankWidget widget = new TankWidget((IFluidTank)new FluidTank(fluidStack, this.fluid_list.get((int)i).amount), xPos + x * 18, y * 18, 18, 18);
                widget.setBackgroundTexture(background).setAlwaysShowFull(true).setClient();
                this.addWidget(widget);
            }
        }
        this.setSize(new Size(this.getSize().width / 18 > 0 ? this.getSize().width : 18, maxYSize * 18));
        return this;
    }

    @Override
    public String getRegistryName() {
        return NAME;
    }

    @Override
    public JsonObject getTemplate(boolean isFixed) {
        JsonObject template = super.getTemplate(isFixed);
        template.add("fluid_list", new Gson().toJsonTree(Collections.singletonList(new FluidStackInfo("distilled_water", 1))));
        return template;
    }

    @Override
    public void loadConfigurator(DraggableScrollableWidgetGroup group, JsonObject config, boolean isFixed, Consumer<String> needUpdate) {
        super.loadConfigurator(group, config, isFixed, needUpdate);
        group.addWidget(new FluidStackConfigurator(group, config, "fluid_list").setOnUpdated(needUpdate));
    }

    public static class FluidStackInfo {
        public String id;
        public int amount = 1;
        private transient FluidStack fluidStack;

        public FluidStackInfo() {
        }

        public void update(FluidStack itemStack) {
            if (itemStack != null) {
                this.id = FluidRegistry.getFluidName((Fluid)itemStack.getFluid());
                this.amount = itemStack.amount;
            } else {
                this.id = null;
                this.fluidStack = null;
                this.amount = 0;
            }
        }

        public FluidStackInfo(String id, int amount) {
            this.id = id;
            this.amount = amount;
        }

        public FluidStack getInstance() {
            if (this.fluidStack == null && this.id != null) {
                Fluid fluid = FluidRegistry.getFluid((String)this.id);
                if (fluid != null) {
                    this.fluidStack = new FluidStack(fluid, this.amount);
                } else {
                    this.id = null;
                }
            }
            return this.fluidStack;
        }
    }
}

