/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guideeditor.widget;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gregtech.api.GregTechAPI;
import gregtech.api.block.machines.MachineItemBlock;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.resources.TextTexture;
import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.PhantomSlotWidget;
import gregtech.api.gui.widgets.TabGroup;
import gregtech.api.gui.widgets.TextFieldWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.gui.widgets.tab.IGuiTextureTabInfo;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.gui.CustomTabListRenderer;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.terminal.gui.widgets.SelectorWidget;
import gregtech.api.terminal.gui.widgets.TextEditorWidget;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.FileUtility;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.inventory.handlers.SingleItemStackHandler;
import gregtech.common.terminal.app.guide.GuideApp;
import gregtech.common.terminal.app.guide.ItemGuideApp;
import gregtech.common.terminal.app.guide.MultiBlockGuideApp;
import gregtech.common.terminal.app.guide.SimpleMachineGuideApp;
import gregtech.common.terminal.app.guide.widget.GuidePageWidget;
import gregtech.common.terminal.app.guide.widget.IGuideWidget;
import gregtech.common.terminal.app.guideeditor.GuideEditorApp;
import gregtech.common.terminal.app.guideeditor.widget.GuidePageEditorWidget;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GuideConfigEditor
extends TabGroup<AbstractWidgetGroup> {
    public String json;
    private IGuideWidget selected;
    private GuidePageEditorWidget pageEditor;
    private TextEditorWidget titleEditor;
    private final DraggableScrollableWidgetGroup widgetSelector;
    private final DraggableScrollableWidgetGroup widgetConfigurator;
    private final CircleButtonWidget[] addButton;
    private final GuideEditorApp app;
    private final IItemHandlerModifiable handler;
    private final List<String> candidates;
    private String type;

    public GuideConfigEditor(int x, int y, int width, int height, GuideEditorApp app) {
        super(x, y + 10, new CustomTabListRenderer(TerminalTheme.COLOR_F_2, TerminalTheme.COLOR_B_3, 30, 10));
        this.setSize(new Size(width, height));
        this.candidates = TerminalRegistry.getAllApps().stream().filter(GuideApp.class::isInstance).map(AbstractApplication::getUnlocalizedName).collect(Collectors.toList());
        this.type = this.candidates.get(this.candidates.size() - 1);
        this.handler = new SingleItemStackHandler(1);
        this.addButton = new CircleButtonWidget[2];
        this.widgetSelector = this.createWidgetSelector();
        this.widgetConfigurator = this.createConfigurator();
        this.addTab(new IGuiTextureTabInfo(new TextTexture("P", -1), "terminal.guide_editor.page_config"), this.createPageConfig());
        this.addTab(new IGuiTextureTabInfo(new TextTexture("W", -1), "terminal.guide_editor.widgets_box"), this.widgetSelector);
        this.addTab(new IGuiTextureTabInfo(new TextTexture("C", -1), "terminal.guide_editor.widget_config"), this.widgetConfigurator);
        this.setOnTabChanged((oldIndex, newIndex) -> {
            if (newIndex == 1) {
                this.addButton[0].setVisible(true);
                this.addButton[1].setVisible(true);
            } else {
                this.addButton[0].setVisible(false);
                this.addButton[1].setVisible(false);
            }
        });
        this.addButton[0] = new CircleButtonWidget(115, 15, 8, 1, 8).setColors(new Color(255, 255, 255, 0).getRGB(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_4.getColor()).setIcon(GuiTextures.ICON_ADD).setHoverText("terminal.guide_editor.add_stream").setClickListener(this::addStream);
        this.addButton[1] = new CircleButtonWidget(115, 35, 8, 1, 8).setColors(new Color(255, 255, 255, 0).getRGB(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_5.getColor()).setIcon(GuiTextures.ICON_ADD).setHoverText("terminal.guide_editor.add_fixed").setClickListener(this::addFixed);
        this.addButton[0].setVisible(false);
        this.addButton[1].setVisible(false);
        this.app = app;
        this.addWidget(this.addButton[0]);
        this.addWidget(this.addButton[1]);
    }

    public void setGuidePageEditorWidget(GuidePageEditorWidget pageEditor) {
        this.pageEditor = pageEditor;
    }

    public GuidePageEditorWidget getPageEditor() {
        return this.pageEditor;
    }

    private DraggableScrollableWidgetGroup createPageConfig() {
        DraggableScrollableWidgetGroup group = new DraggableScrollableWidgetGroup(0, 0, this.getSize().width, this.getSize().height - 10).setBackground(TerminalTheme.COLOR_B_3).setYScrollBarWidth(4).setYBarStyle(null, TerminalTheme.COLOR_F_1);
        group.addWidget(new LabelWidget(5, 5, "section", -1).setShadow(true));
        group.addWidget(new TextFieldWidget(5, 15, 116, 20, new ColorRectTexture(-1627389952), null, null).setTextResponder(s -> {
            if (this.pageEditor != null) {
                this.pageEditor.setSection((String)s);
            }
        }, true).setTextSupplier(() -> this.getPageEditor().getSection(), true).setMaxStringLength(Integer.MAX_VALUE).setValidator(s -> true));
        group.addWidget(new ImageWidget(5, 40, 116, 1, new ColorRectTexture(-1)));
        group.addWidget(new LabelWidget(5, 45, "type", -1).setShadow(true));
        group.addWidget(new SelectorWidget(30, 55, 91, 20, this.candidates, -1, () -> this.type, true).setIsUp(true).setOnChanged(type -> {
            this.type = type;
        }).setColors(TerminalTheme.COLOR_B_2.getColor(), TerminalTheme.COLOR_F_1.getColor(), TerminalTheme.COLOR_B_2.getColor()).setBackground(TerminalTheme.COLOR_6));
        group.addWidget(new PhantomSlotWidget(this.handler, 0, 6, 56).setBackgroundTexture(TerminalTheme.COLOR_B_2));
        group.addWidget(new ImageWidget(5, 80, 116, 1, new ColorRectTexture(-1)));
        group.addWidget(new LabelWidget(5, 85, "title", -1).setShadow(true));
        this.titleEditor = new TextEditorWidget(5, 95, 116, 70, s -> {
            if (this.pageEditor != null) {
                this.pageEditor.setTitle((String)s);
            }
        }, true).setContent("Template").setBackground(new ColorRectTexture(-1543503873));
        group.addWidget(this.titleEditor);
        return group;
    }

    public void updateTitle(String title) {
        this.titleEditor.setContent(title);
    }

    private DraggableScrollableWidgetGroup createWidgetSelector() {
        DraggableScrollableWidgetGroup group = new DraggableScrollableWidgetGroup(0, 0, this.getSize().width, this.getSize().height - 10).setBackground(TerminalTheme.COLOR_B_3).setYScrollBarWidth(4).setYBarStyle(null, TerminalTheme.COLOR_F_1);
        int y = 10;
        for (Map.Entry<String, IGuideWidget> entry : GuidePageWidget.REGISTER_WIDGETS.entrySet()) {
            IGuideWidget widgetTemplate = entry.getValue();
            JsonObject template = widgetTemplate.getTemplate(false);
            Widget guideWidget = widgetTemplate.updateOrCreateStreamWidget(5, y + 10, this.getSize().width - 14, template);
            group.addWidget(new LabelWidget(this.getSize().width / 2 - 1, y - 3, entry.getKey(), -1).setXCentered(true).setShadow(true));
            y += guideWidget.getSize().height + 25;
            group.addWidget(guideWidget);
        }
        group.addWidget(new WidgetGroup(new Position(5, group.getWidgetBottomHeight() + 5), Size.ZERO));
        return group;
    }

    private DraggableScrollableWidgetGroup createConfigurator() {
        return new DraggableScrollableWidgetGroup(0, 0, this.getSize().width, this.getSize().height - 10).setBackground(TerminalTheme.COLOR_B_3).setYScrollBarWidth(4).setYBarStyle(null, TerminalTheme.COLOR_F_1);
    }

    public void loadConfigurator(IGuideWidget widget) {
        this.widgetConfigurator.clearAllWidgets();
        if (widget != null) {
            widget.loadConfigurator(this.widgetConfigurator, widget.getConfig(), widget.isFixed(), type -> {
                widget.updateValue((String)type);
                if (this.pageEditor != null) {
                    this.pageEditor.computeMax();
                }
            });
            this.widgetConfigurator.addWidget(new WidgetGroup(new Position(5, this.widgetConfigurator.getWidgetBottomHeight() + 5), Size.ZERO));
        }
    }

    public void newPage() {
        TerminalDialogWidget.showConfirmDialog(this.app.getOs(), "terminal.component.new_page", "terminal.component.confirm", res -> {
            if (res.booleanValue()) {
                this.pageEditor.loadJsonConfig("{\"section\":\"default\",\"title\":\"Template\",\"stream\":[],\"fixed\":[]}");
                this.getPageEditor().setSection("default");
                this.updateTitle("Template");
                this.type = this.candidates.get(this.candidates.size() - 1);
                this.handler.setStackInSlot(0, ItemStack.field_190927_a);
            }
        }).setClientSide().open();
    }

    public void loadJson() {
        if (this.pageEditor != null) {
            File file = new File(TerminalRegistry.TERMINAL_PATH, "guide");
            TerminalDialogWidget.showFileDialog(this.app.getOs(), "terminal.component.load_file", file, true, result -> {
                if (result != null && result.isFile()) {
                    try {
                        JsonObject config = Objects.requireNonNull(FileUtility.loadJson(result)).getAsJsonObject();
                        this.pageEditor.loadJsonConfig(config);
                        this.getPageEditor().setSection(config.get("section").getAsString());
                        this.updateTitle(config.get("title").getAsString());
                        for (AbstractApplication app : TerminalRegistry.getAllApps()) {
                            Object object;
                            if (!(app instanceof GuideApp) || (object = ((GuideApp)app).ofJson(config)) == null) continue;
                            this.type = app.getUnlocalizedName();
                            if (object instanceof ItemGuideApp.GuideItem) {
                                this.handler.setStackInSlot(0, ((ItemGuideApp.GuideItem)object).stack.func_77946_l());
                            } else if (object instanceof MetaTileEntity) {
                                this.handler.setStackInSlot(0, ((MetaTileEntity)object).getStackForm());
                            } else if (object instanceof ItemStack) {
                                this.handler.setStackInSlot(0, ((ItemStack)object).func_77946_l());
                            } else {
                                this.handler.setStackInSlot(0, ItemStack.field_190927_a);
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        TerminalDialogWidget.showInfoDialog(this.app.getOs(), "terminal.component.error", "terminal.component.load_file.error").setClientSide().open();
                    }
                }
            }).setClientSide().open();
        }
    }

    public void saveJson() {
        if (this.pageEditor != null) {
            File file = new File(TerminalRegistry.TERMINAL_PATH, "guide");
            TerminalDialogWidget.showFileDialog(this.app.getOs(), "terminal.component.save_file", file, false, result -> {
                if (result != null && !FileUtility.saveJson(result, (JsonElement)this.saveType(this.pageEditor.getJsonConfig()))) {
                    TerminalDialogWidget.showInfoDialog(this.app.getOs(), "terminal.component.error", "terminal.component.save_file.error").setClientSide().open();
                }
            }).setClientSide().open();
        }
    }

    private JsonObject saveType(JsonObject jsonObject) {
        ItemStack stack = this.handler.getStackInSlot(0);
        for (AbstractApplication app : TerminalRegistry.getAllApps()) {
            if (!(app instanceof GuideApp) || !this.type.equals(app.getUnlocalizedName())) continue;
            if (app instanceof ItemGuideApp) {
                if (stack.func_190926_b()) {
                    TerminalDialogWidget.showInfoDialog(app.getOs(), "terminal.component.warning", "terminal.guide_editor.error_type").setClientSide().open();
                } else {
                    jsonObject.addProperty("item", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString() + ":" + stack.func_77960_j());
                }
            } else if ((app instanceof MultiBlockGuideApp || app instanceof SimpleMachineGuideApp) && stack.func_77973_b() instanceof MachineItemBlock) {
                MetaTileEntity mte = GregTechAPI.MTE_REGISTRY.getObjectById(stack.func_77952_i());
                if (mte != null) {
                    jsonObject.addProperty("metatileentity", GregTechAPI.MTE_REGISTRY.getNameForObject(mte).func_110623_a());
                } else {
                    TerminalDialogWidget.showInfoDialog(app.getOs(), "terminal.component.warning", "terminal.guide_editor.error_type").setClientSide().open();
                }
            }
            return jsonObject;
        }
        return jsonObject;
    }

    private void addFixed(Widget.ClickData data) {
        if (this.pageEditor != null && this.selected != null) {
            this.selected.setStroke(0);
            this.pageEditor.addGuideWidget(this.selected, true);
            this.selected.setStroke(-8609281);
        }
    }

    private void addStream(Widget.ClickData data) {
        if (this.pageEditor != null && this.selected != null) {
            this.selected.setStroke(0);
            this.pageEditor.addGuideWidget(this.selected, false);
            this.selected.setStroke(-8609281);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean flag = super.mouseClicked(mouseX, mouseY, button);
        if (this.selectedTabIndex == 1 && this.widgetSelector != null) {
            for (Widget widget : this.widgetSelector.widgets) {
                if (!widget.isMouseOverElement(mouseX, mouseY)) continue;
                if (widget instanceof IGuideWidget) {
                    if (this.selected != null) {
                        this.selected.setStroke(0);
                    }
                    ((IGuideWidget)((Object)widget)).setStroke(-8609281);
                    this.selected = (IGuideWidget)((Object)widget);
                }
                GuideConfigEditor.playButtonClickSound();
                return true;
            }
        }
        return flag;
    }
}

